<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
    
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<a class="skip-link" href="#main"><?php _e('Ana içeriğe geç', 'firma-rehberi-pro'); ?></a>

<header class="site-header" role="banner">
    <?php if (get_theme_mod('show_top_bar', true)) : ?>
    <div class="header-top">
        <div class="container">
            <div class="flex justify-between items-center">
                <div class="header-contact">
                    <span>📞 <?php echo esc_html(get_theme_mod('header_phone', '+90 (212) 555 0123')); ?></span>
                    <span class="ml-4">✉️ <?php echo esc_html(get_theme_mod('header_email', 'info@firmarehberi.com')); ?></span>
                </div>
                <div class="header-social">
                    <?php if (get_theme_mod('facebook_url')) : ?>
                        <a href="<?php echo esc_url(get_theme_mod('facebook_url')); ?>" target="_blank" rel="noopener" aria-label="Facebook">📘</a>
                    <?php endif; ?>
                    <?php if (get_theme_mod('twitter_url')) : ?>
                        <a href="<?php echo esc_url(get_theme_mod('twitter_url')); ?>" target="_blank" rel="noopener" aria-label="Twitter">🐦</a>
                    <?php endif; ?>
                    <?php if (get_theme_mod('instagram_url')) : ?>
                        <a href="<?php echo esc_url(get_theme_mod('instagram_url')); ?>" target="_blank" rel="noopener" aria-label="Instagram">📷</a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    <div class="header-main">
        <div class="container">
            <div class="flex justify-between items-center">
                <div class="site-branding">
                    <?php if (has_custom_logo()) : ?>
                        <?php the_custom_logo(); ?>
                    <?php else : ?>
                        <a href="<?php echo esc_url(home_url('/')); ?>" rel="home" class="logo">
                            <?php bloginfo('name'); ?>
                        </a>
                    <?php endif; ?>
                    
                    <?php
                    $description = get_bloginfo('description', 'display');
                    if ($description || is_customize_preview()) :
                    ?>
                        <p class="site-description"><?php echo $description; ?></p>
                    <?php endif; ?>
                </div>
                
                <nav class="main-nav" role="navigation" aria-label="<?php _e('Ana menü', 'firma-rehberi-pro'); ?>">
                    <button class="mobile-menu-toggle" aria-expanded="false" aria-controls="primary-menu">
                        <span class="sr-only"><?php _e('Menüyü aç/kapat', 'firma-rehberi-pro'); ?></span>
                        <span class="hamburger"></span>
                    </button>
                    
                    <?php
                    wp_nav_menu(array(
                        'theme_location' => 'primary',
                        'menu_id'        => 'primary-menu',
                        'menu_class'     => 'nav-menu',
                        'container'      => false,
                        'fallback_cb'    => 'firma_rehberi_fallback_menu',
                    ));
                    ?>
                </nav>
            </div>
        </div>
    </div>
</header>

<?php
/**
 * Fallback menu function
 */
function firma_rehberi_fallback_menu() {
    echo '<ul class="nav-menu">';
    echo '<li><a href="' . esc_url(home_url('/')) . '">' . __('Ana Sayfa', 'firma-rehberi-pro') . '</a></li>';
    echo '<li><a href="' . esc_url(get_post_type_archive_link('company')) . '">' . __('Firmalar', 'firma-rehberi-pro') . '</a></li>';
    echo '<li><a href="' . esc_url(get_permalink(get_option('page_for_posts'))) . '">' . __('Haberler', 'firma-rehberi-pro') . '</a></li>';
    echo '<li><a href="' . esc_url(home_url('/iletisim')) . '">' . __('İletişim', 'firma-rehberi-pro') . '</a></li>';
    echo '</ul>';
}
?>
