# Dans Dersleri - Türkiye'nin Dans Kursu Rehberi

Türkiye'nin en kapsamlı dans kursu rehberi platformu. İstanbul, Ankara, İzmir ve tüm şehirlerde profesyonel dans kurslarını keşfedin.

## 🎭 Özellikler

### Ana Özellikler
- **Kapsamlı Kurs Arama**: Şehir, dans türü, seviye ve fiyat bazlı filtreleme
- **Detaylı Kurs Profilleri**: Fotoğraf galerisi, öğretmen bilgileri, ders programı
- **Kullanıcı Değerlendirmeleri**: Yıldız puanlama ve yorum sistemi
- **Harita Entegrasyonu**: Kurs konumları ve yol tarifi
- **Responsive Tasarım**: Mobil ve masaüstü uyumlu

### Dans Türleri
- Salsa & Bachata
- Tango
- Hip-Hop
- Klasik Bale
- Modern Dans
- Latin Dansları
- Swing
- Ve daha fazlası...

### Şehirler
- İstanbul, Ankara, İzmir (Öncelikli)
- Bursa, Antalya, Adana
- Konya, Gaziantep, Mersin
- Tüm Türkiye genelinde

## 🚀 Kurulum

### Gereksinimler
- Node.js 18+ 
- npm veya yarn

### Adımlar

1. **Projeyi klonlayın**
```bash
git clone https://github.com/yourusername/dansdersleri.git
cd dansdersleri
```

2. **Bağımlılıkları yükleyin**
```bash
npm install
# veya
yarn install
```

3. **Environment variables ayarlayın**
```bash
# env.example dosyasını kopyalayın
cp env.example .env.local

# .env.local dosyasını düzenleyin ve değerleri girin
```

⚠️ **ÖNEMLİ GÜVENLİK NOTU**: 
- `.env.local` dosyası asla Git'e commit edilmemelidir
- Production'da güvenli şifreler kullanın
- API anahtarları ve secretlar çevresel değişkenlerde tutun

4. **Geliştirme sunucusunu başlatın**
```bash
npm run dev
# veya
yarn dev
```

4. **Tarayıcıda açın**
```
http://localhost:3000
```

## 🛠️ Teknoloji Stack

### Frontend
- **Next.js 14** - React framework
- **TypeScript** - Type safety
- **Tailwind CSS** - Styling
- **Framer Motion** - Animations
- **Lucide React** - Icons

### Backend (Planlanan)
- **Node.js** - Runtime
- **Express.js** - Web framework
- **PostgreSQL** - Database
- **Prisma** - ORM

### Deployment
- **Vercel** - Hosting
- **Google Maps API** - Maps integration
- **Cloudinary** - Image storage

## 📁 Proje Yapısı

```
dansdersleri/
├── app/                    # Next.js App Router
│   ├── globals.css        # Global styles
│   ├── layout.tsx         # Root layout
│   ├── page.tsx           # Home page
│   ├── kurslar/           # Course pages
│   └── arama/             # Search pages
├── components/            # React components
│   ├── course/            # Course-related components
│   ├── search/            # Search components
│   └── ...                # Other components
├── public/                # Static assets
├── package.json           # Dependencies
├── tailwind.config.js     # Tailwind config
└── README.md             # This file
```

## 🎨 Tasarım Sistemi

### Renkler
- **Primary**: Kırmızı tonları (#ef4444)
- **Secondary**: Mavi tonları (#0ea5e9)
- **Accent**: Mor tonları (#d946ef)

### Tipografi
- **Başlıklar**: Poppins
- **Metin**: Inter

### Bileşenler
- Modern card tasarımları
- Hover efektleri
- Responsive grid sistem
- Smooth animasyonlar

## 🔧 Geliştirme

### Scripts
```bash
npm run dev          # Geliştirme sunucusu
npm run build        # Production build
npm run start        # Production sunucusu
npm run lint         # ESLint kontrolü
```

### Kod Standartları
- TypeScript strict mode
- ESLint + Prettier
- Component-based architecture
- Responsive design principles

## 📱 Responsive Tasarım

- **Mobile First**: 320px+
- **Tablet**: 768px+
- **Desktop**: 1024px+
- **Large Desktop**: 1280px+

## 🔍 SEO Optimizasyonu

- Meta tagları
- Open Graph
- Twitter Cards
- Sitemap
- Schema markup
- Page speed optimization

## 🚀 Deployment

### Vercel (Önerilen)
1. GitHub'a push edin
2. Vercel'e bağlayın
3. Otomatik deployment

### Diğer Platformlar
- Netlify
- AWS Amplify
- Railway

## 📊 Analytics & Monitoring

- Google Analytics
- Vercel Analytics
- Error tracking
- Performance monitoring

## 🤝 Katkıda Bulunma

1. Fork edin
2. Feature branch oluşturun (`git checkout -b feature/amazing-feature`)
3. Commit edin (`git commit -m 'Add amazing feature'`)
4. Push edin (`git push origin feature/amazing-feature`)
5. Pull Request oluşturun

## 📄 Lisans

Bu proje MIT lisansı altında lisanslanmıştır. Detaylar için [LICENSE](LICENSE) dosyasına bakın.

## 📞 İletişim

- **Website**: [dansdersleri.com](https://dansdersleri.com)
- **Email**: info@dansdersleri.com
- **GitHub**: [@dansdersleri](https://github.com/dansdersleri)

## 🙏 Teşekkürler

- Next.js ekibine
- Tailwind CSS ekibine
- Tüm açık kaynak katkıcılarına
- Dans topluluğuna

---

**Dans Dersleri** - Türkiye'nin en kapsamlı dans kursu rehberi 🎭💃🕺
