# 📈 SEO Optimizasyonu - Dans Dersleri

## ✅ Uygulanmış SEO Özellikleri

### 1. **Technical SEO**

#### Sitemap.xml
- ✅ Otomatik sitemap oluşturma
- ✅ Tüm önemli sayfalar dahil
- ✅ Priority ve frequency ayarları
- **URL**: `https://dansdersleri.com/sitemap.xml`

#### Robots.txt
- ✅ Arama motorları için yönlendirme
- ✅ Admin paneli engellemesi
- ✅ Sitemap referansı
- **URL**: `https://dansdersleri.com/robots.txt`

#### Structured Data (Schema.org)
- ✅ Organization Schema
- ✅ Website Schema
- ✅ Course Schema
- ✅ LocalBusiness Schema
- ✅ FAQ Schema
- ✅ Breadcrumb Schema

### 2. **On-Page SEO**

#### Meta Tags
```typescript
// Her sayfada:
- title (50-60 karakter)
- description (150-160 karakter)
- keywords
- og:image, og:title, og:description
- twitter:card
```

#### URL Yapısı
```
✅ SEO-friendly URLs:
/kurslar/1
/sehirler/istanbul
/dans-turleri/salsa
/arama?q=salsa&city=istanbul
```

#### Header Tags
```html
H1: Ana başlık (her sayfada 1 adet)
H2: Bölüm başlıkları
H3: Alt başlıklar
```

### 3. **Content SEO**

#### Keyword Optimization
**Ana Keywords:**
- Dans dersleri
- Dans kursu
- Dans okulu
- Salsa dersi
- Bachata kursu
- Tango dersleri

**Long-tail Keywords:**
- İstanbul dans kursu
- Ankara salsa dersi
- İzmir tango kursu
- Uygun fiyatlı dans dersleri

#### Content Strategy
- ✅ SSS sayfası (10+ soru-cevap)
- ✅ Blog sistemi hazır
- ✅ Kurs detay sayfaları
- ✅ Şehir sayfaları
- ✅ Dans türü sayfaları

### 4. **Performance SEO**

#### Page Speed
```javascript
// Optimizasyonlar:
✅ Image optimization (AVIF, WebP)
✅ Lazy loading
✅ Code minification
✅ Gzip compression
✅ Browser caching
✅ CDN ready
```

#### Core Web Vitals
- **LCP** (Largest Contentful Paint): < 2.5s
- **FID** (First Input Delay): < 100ms
- **CLS** (Cumulative Layout Shift): < 0.1

### 5. **Mobile SEO**
- ✅ Responsive design
- ✅ Mobile-first approach
- ✅ Touch-friendly buttons
- ✅ Fast mobile loading

### 6. **Local SEO**

#### Google My Business Hazırlığı
```json
{
  "name": "Dans Dersleri",
  "address": "İstanbul, Türkiye",
  "phone": "+90 212 555 0123",
  "website": "https://dansdersleri.com",
  "category": "Eğitim Merkezi",
  "hours": "09:00-18:00"
}
```

#### Local Keywords
- Dans kursu [şehir]
- [Şehir] dans dersleri
- [İlçe] dans okulu

### 7. **Link Building (Yapılacaklar)**

#### Internal Linking
- ✅ Ana sayfadan alt sayfalara linkler
- ✅ Breadcrumb navigation
- ✅ İlgili kurslar
- ✅ Footer linkler

#### External Linking (Öneriler)
- [ ] Dans bloglarından backlink
- [ ] Yerel dizinlere kayıt
- [ ] Sosyal medya profilleri
- [ ] İşletme rehberleri

## 📊 SEO Performans Metrikleri

### Google Search Console
```bash
# Takip edilecek metrikler:
- İmpression (Gösterim)
- Clicks (Tıklama)
- CTR (Click-Through Rate)
- Average Position
- Page Experience
```

### Google Analytics
```bash
# Takip edilecek:
- Organic Traffic
- Bounce Rate
- Average Session Duration
- Pages per Session
- Conversion Rate
```

## 🎯 SEO Hedefleri

### Kısa Vadeli (1-3 Ay)
- [ ] Google Search Console'a kayıt
- [ ] İlk 100 anahtar kelime için ranking
- [ ] Aylık 1000+ organik ziyaretçi

### Orta Vadeli (3-6 Ay)
- [ ] İlk 50 anahtar kelime için ilk sayfa
- [ ] Aylık 5000+ organik ziyaretçi
- [ ] 100+ backlink

### Uzun Vadeli (6-12 Ay)
- [ ] 20+ anahtar kelime için ilk 3
- [ ] Aylık 20,000+ organik ziyaretçi
- [ ] Domain Authority 40+

## 🔧 SEO Araçları

### Kullanılması Gerekenler
1. **Google Search Console** - Performance tracking
2. **Google Analytics** - Traffic analysis
3. **Ahrefs / SEMrush** - Keyword research
4. **PageSpeed Insights** - Performance
5. **Screaming Frog** - Technical SEO audit

## 📝 SEO Checklist

### Her Yeni Sayfa İçin
- [ ] Unique title tag (50-60 karakter)
- [ ] Meta description (150-160 karakter)
- [ ] H1 tag (1 adet)
- [ ] Alt tags for images
- [ ] Internal links
- [ ] Structured data
- [ ] Mobile-friendly test
- [ ] Page speed test

### Haftalık
- [ ] Yeni içerik yayınlama
- [ ] Backlink kontrolü
- [ ] Ranking takibi
- [ ] Competitor analysis

### Aylık
- [ ] Technical SEO audit
- [ ] Content update
- [ ] Performance review
- [ ] Strategy adjustment

## 🚀 Quick Wins

### Hemen Yapılabilecekler
1. ✅ Google Search Console'a site ekleme
2. ✅ Google Analytics kurulumu
3. ✅ Sitemap submit etme
4. ✅ Sosyal medya profillerini tamamlama
5. ✅ Google My Business profili oluşturma

## 📞 SEO Support

SEO konusunda destek için:
- **Email**: seo@dansdersleri.com
- **Dokümantasyon**: https://nextjs.org/docs/app/building-your-application/optimizing

---

**Son Güncelleme**: 4 Ekim 2024  
**Versiyon**: 1.0.0

