'use client'

import { useState } from 'react'
import { Save, Search, Globe, RefreshCw } from 'lucide-react'

export default function SEOSettings() {
  const [seoSettings, setSeoSettings] = useState({
    metaTitle: 'Dans Dersleri - Türkiye\'nin En Kapsamlı Dans Kursu Rehberi',
    metaDescription: 'İstanbul, Ankara, İzmir ve tüm Türkiye\'de salsa, bachata, tango, hip-hop ve daha fazla dans türü için en iyi kursları keşfedin.',
    metaKeywords: 'dans kursu, salsa, bachata, tango, hip-hop, dans dersleri, istanbul, ankara, izmir',
    ogTitle: 'Dans Dersleri - Profesyonel Dans Kursları',
    ogDescription: 'Türkiye\'nin en kapsamlı dans kursu rehberi. Profesyonel öğretmenler, uygun fiyatlar.',
    ogImage: 'https://dansdersleri.com/og-image.jpg',
    twitterCard: 'summary_large_image',
    robots: 'index, follow',
    canonicalUrl: 'https://dansdersleri.com',
    sitemapUrl: 'https://dansdersleri.com/sitemap.xml',
    googleAnalytics: 'GA-XXXXXXXXX-X',
    googleSearchConsole: 'https://search.google.com/search-console',
    facebookPixel: '1234567890123456'
  })

  const [loading, setLoading] = useState(false)

  const handleSave = async () => {
    setLoading(true)
    await new Promise(resolve => setTimeout(resolve, 1000))
    setLoading(false)
    alert('SEO ayarları kaydedildi!')
  }

  return (
    <div className="space-y-6">
      {/* Page Header */}
      <div className="flex items-center justify-between">
        <div>
          <h1 className="text-3xl font-bold text-gray-900">SEO Ayarları</h1>
          <p className="text-gray-600 mt-2">Arama motoru optimizasyonu ayarlarını yönetin</p>
        </div>
        <button
          onClick={handleSave}
          disabled={loading}
          className="btn-primary flex items-center space-x-2"
        >
          {loading ? (
            <RefreshCw className="w-4 h-4 animate-spin" />
          ) : (
            <Save className="w-4 h-4" />
          )}
          <span>{loading ? 'Kaydediliyor...' : 'Kaydet'}</span>
        </button>
      </div>

      {/* Meta Tags */}
      <div className="bg-white rounded-xl shadow-lg p-6">
        <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
          <Search className="w-5 h-5 mr-2" />
          Meta Etiketleri
        </h2>
        
        <div className="space-y-4">
          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">
              Meta Title (50-60 karakter)
            </label>
            <input
              type="text"
              value={seoSettings.metaTitle}
              onChange={(e) => setSeoSettings({...seoSettings, metaTitle: e.target.value})}
              className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
              maxLength={60}
            />
            <p className="text-xs text-gray-500 mt-1">{seoSettings.metaTitle.length}/60 karakter</p>
          </div>

          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">
              Meta Description (150-160 karakter)
            </label>
            <textarea
              rows={3}
              value={seoSettings.metaDescription}
              onChange={(e) => setSeoSettings({...seoSettings, metaDescription: e.target.value})}
              className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
              maxLength={160}
            />
            <p className="text-xs text-gray-500 mt-1">{seoSettings.metaDescription.length}/160 karakter</p>
          </div>

          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">
              Meta Keywords
            </label>
            <input
              type="text"
              value={seoSettings.metaKeywords}
              onChange={(e) => setSeoSettings({...seoSettings, metaKeywords: e.target.value})}
              className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
              placeholder="dans kursu, salsa, bachata, tango"
            />
          </div>
        </div>
      </div>

      {/* Open Graph */}
      <div className="bg-white rounded-xl shadow-lg p-6">
        <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
          <Globe className="w-5 h-5 mr-2" />
          Open Graph (Sosyal Medya)
        </h2>
        
        <div className="space-y-4">
          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">
              OG Title
            </label>
            <input
              type="text"
              value={seoSettings.ogTitle}
              onChange={(e) => setSeoSettings({...seoSettings, ogTitle: e.target.value})}
              className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
            />
          </div>

          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">
              OG Description
            </label>
            <textarea
              rows={3}
              value={seoSettings.ogDescription}
              onChange={(e) => setSeoSettings({...seoSettings, ogDescription: e.target.value})}
              className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
            />
          </div>

          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">
              OG Image URL
            </label>
            <input
              type="url"
              value={seoSettings.ogImage}
              onChange={(e) => setSeoSettings({...seoSettings, ogImage: e.target.value})}
              className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
            />
          </div>

          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">
              Twitter Card Type
            </label>
            <select
              value={seoSettings.twitterCard}
              onChange={(e) => setSeoSettings({...seoSettings, twitterCard: e.target.value})}
              className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
            >
              <option value="summary">Summary</option>
              <option value="summary_large_image">Summary Large Image</option>
            </select>
          </div>
        </div>
      </div>

      {/* Technical SEO */}
      <div className="bg-white rounded-xl shadow-lg p-6">
        <h2 className="text-xl font-semibold text-gray-900 mb-4">
          Teknik SEO
        </h2>
        
        <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">
              Canonical URL
            </label>
            <input
              type="url"
              value={seoSettings.canonicalUrl}
              onChange={(e) => setSeoSettings({...seoSettings, canonicalUrl: e.target.value})}
              className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
            />
          </div>

          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">
              Sitemap URL
            </label>
            <input
              type="url"
              value={seoSettings.sitemapUrl}
              onChange={(e) => setSeoSettings({...seoSettings, sitemapUrl: e.target.value})}
              className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
            />
          </div>

          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">
              Robots
            </label>
            <select
              value={seoSettings.robots}
              onChange={(e) => setSeoSettings({...seoSettings, robots: e.target.value})}
              className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
            >
              <option value="index, follow">Index, Follow</option>
              <option value="noindex, nofollow">No Index, No Follow</option>
              <option value="index, nofollow">Index, No Follow</option>
              <option value="noindex, follow">No Index, Follow</option>
            </select>
          </div>
        </div>
      </div>

      {/* Analytics */}
      <div className="bg-white rounded-xl shadow-lg p-6">
        <h2 className="text-xl font-semibold text-gray-900 mb-4">
          Analytics & Tracking
        </h2>
        
        <div className="space-y-4">
          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">
              Google Analytics ID
            </label>
            <input
              type="text"
              value={seoSettings.googleAnalytics}
              onChange={(e) => setSeoSettings({...seoSettings, googleAnalytics: e.target.value})}
              className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
              placeholder="GA-XXXXXXXXX-X"
            />
          </div>

          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">
              Google Search Console URL
            </label>
            <input
              type="url"
              value={seoSettings.googleSearchConsole}
              onChange={(e) => setSeoSettings({...seoSettings, googleSearchConsole: e.target.value})}
              className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
            />
          </div>

          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">
              Facebook Pixel ID
            </label>
            <input
              type="text"
              value={seoSettings.facebookPixel}
              onChange={(e) => setSeoSettings({...seoSettings, facebookPixel: e.target.value})}
              className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
              placeholder="1234567890123456"
            />
          </div>
        </div>
      </div>
    </div>
  )
}

