'use client'

import { useState } from 'react'
import { FileText, BookOpen, HelpCircle, Plus, Search, Filter } from 'lucide-react'

export default function IcerikPage() {
  const [searchTerm, setSearchTerm] = useState('')
  const [filterType, setFilterType] = useState('all')

  const contentStats = [
    {
      title: 'Blog Yazıları',
      value: '24',
      change: '+3',
      changeType: 'positive',
      icon: FileText
    },
    {
      title: 'Sayfalar',
      value: '8',
      change: '+1',
      changeType: 'positive',
      icon: BookOpen
    },
    {
      title: 'SSS',
      value: '15',
      change: '+2',
      changeType: 'positive',
      icon: HelpCircle
    },
    {
      title: 'Toplam Görüntüleme',
      value: '12,456',
      change: '+15.2%',
      changeType: 'positive',
      icon: FileText
    }
  ]

  const recentContent = [
    {
      id: 1,
      title: 'Dans Kursu Seçerken Dikkat Edilmesi Gerekenler',
      type: 'Blog',
      status: 'Yayında',
      views: 1250,
      publishDate: '2024-03-15',
      author: 'Admin'
    },
    {
      id: 2,
      title: 'Hakkımızda',
      type: 'Sayfa',
      status: 'Yayında',
      views: 890,
      publishDate: '2024-03-10',
      author: 'Admin'
    },
    {
      id: 3,
      title: 'Sıkça Sorulan Sorular',
      type: 'SSS',
      status: 'Yayında',
      views: 2100,
      publishDate: '2024-03-08',
      author: 'Admin'
    }
  ]

  const getStatusColor = (status: string) => {
    switch (status) {
      case 'Yayında':
        return 'bg-green-100 text-green-800'
      case 'Taslak':
        return 'bg-yellow-100 text-yellow-800'
      case 'Beklemede':
        return 'bg-blue-100 text-blue-800'
      default:
        return 'bg-gray-100 text-gray-800'
    }
  }

  const getTypeIcon = (type: string) => {
    switch (type) {
      case 'Blog':
        return <FileText className="w-4 h-4" />
      case 'Sayfa':
        return <BookOpen className="w-4 h-4" />
      case 'SSS':
        return <HelpCircle className="w-4 h-4" />
      default:
        return <FileText className="w-4 h-4" />
    }
  }

  return (
    <div className="space-y-6">
      {/* Header */}
      <div className="flex justify-between items-center">
        <div>
          <h1 className="text-2xl font-bold text-gray-900">İçerik Yönetimi</h1>
          <p className="text-gray-600">Blog, sayfalar ve SSS içeriklerini yönetin</p>
        </div>
        <button className="bg-primary-600 hover:bg-primary-700 text-white px-4 py-2 rounded-lg flex items-center space-x-2">
          <Plus className="w-4 h-4" />
          <span>Yeni İçerik</span>
        </button>
      </div>

      {/* Stats Cards */}
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        {contentStats.map((stat, index) => (
          <div key={index} className="bg-white p-6 rounded-lg shadow">
            <div className="flex items-center">
              <div className="p-2 bg-primary-100 rounded-lg">
                <stat.icon className="w-6 h-6 text-primary-600" />
              </div>
              <div className="ml-4 flex-1">
                <p className="text-sm font-medium text-gray-600">{stat.title}</p>
                <p className="text-2xl font-bold text-gray-900">{stat.value}</p>
                <p className={`text-sm ${
                  stat.changeType === 'positive' ? 'text-green-600' : 'text-red-600'
                }`}>
                  {stat.change}
                </p>
              </div>
            </div>
          </div>
        ))}
      </div>

      {/* Quick Actions */}
      <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
        <div className="bg-white p-6 rounded-lg shadow">
          <div className="flex items-center mb-4">
            <div className="p-2 bg-blue-100 rounded-lg">
              <FileText className="w-6 h-6 text-blue-600" />
            </div>
            <h3 className="text-lg font-semibold text-gray-900 ml-3">Blog Yazıları</h3>
          </div>
          <p className="text-gray-600 mb-4">Blog yazılarını yönetin ve yeni yazılar ekleyin</p>
          <button className="w-full bg-blue-600 hover:bg-blue-700 text-white py-2 px-4 rounded-lg">
            Blog Yönetimi
          </button>
        </div>

        <div className="bg-white p-6 rounded-lg shadow">
          <div className="flex items-center mb-4">
            <div className="p-2 bg-green-100 rounded-lg">
              <BookOpen className="w-6 h-6 text-green-600" />
            </div>
            <h3 className="text-lg font-semibold text-gray-900 ml-3">Sayfalar</h3>
          </div>
          <p className="text-gray-600 mb-4">Statik sayfaları düzenleyin ve yönetin</p>
          <button className="w-full bg-green-600 hover:bg-green-700 text-white py-2 px-4 rounded-lg">
            Sayfa Yönetimi
          </button>
        </div>

        <div className="bg-white p-6 rounded-lg shadow">
          <div className="flex items-center mb-4">
            <div className="p-2 bg-purple-100 rounded-lg">
              <HelpCircle className="w-6 h-6 text-purple-600" />
            </div>
            <h3 className="text-lg font-semibold text-gray-900 ml-3">SSS</h3>
          </div>
          <p className="text-gray-600 mb-4">Sıkça sorulan soruları yönetin</p>
          <button className="w-full bg-purple-600 hover:bg-purple-700 text-white py-2 px-4 rounded-lg">
            SSS Yönetimi
          </button>
        </div>
      </div>

      {/* Filters */}
      <div className="bg-white p-6 rounded-lg shadow">
        <div className="flex flex-col sm:flex-row gap-4">
          <div className="flex-1">
            <div className="relative">
              <Search className="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400 w-4 h-4" />
              <input
                type="text"
                placeholder="İçerik ara..."
                value={searchTerm}
                onChange={(e) => setSearchTerm(e.target.value)}
                className="w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
              />
            </div>
          </div>
          <div className="flex gap-2">
            <select
              value={filterType}
              onChange={(e) => setFilterType(e.target.value)}
              className="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
            >
              <option value="all">Tüm Türler</option>
              <option value="Blog">Blog</option>
              <option value="Sayfa">Sayfa</option>
              <option value="SSS">SSS</option>
            </select>
            <button className="px-4 py-2 border border-gray-300 rounded-lg hover:bg-gray-50 flex items-center space-x-2">
              <Filter className="w-4 h-4" />
              <span>Filtrele</span>
            </button>
          </div>
        </div>
      </div>

      {/* Recent Content */}
      <div className="bg-white rounded-lg shadow">
        <div className="px-6 py-4 border-b border-gray-200">
          <h3 className="text-lg font-semibold text-gray-900">Son İçerikler</h3>
        </div>
        <div className="divide-y divide-gray-200">
          {recentContent.map((content) => (
            <div key={content.id} className="p-6 hover:bg-gray-50">
              <div className="flex items-center justify-between">
                <div className="flex-1">
                  <div className="flex items-center space-x-3 mb-2">
                    <div className="flex items-center text-gray-600">
                      {getTypeIcon(content.type)}
                      <span className="ml-2 text-sm">{content.type}</span>
                    </div>
                    <span className={`inline-flex px-2 py-1 text-xs font-semibold rounded-full ${getStatusColor(content.status)}`}>
                      {content.status}
                    </span>
                  </div>
                  <h4 className="text-lg font-medium text-gray-900 mb-2">{content.title}</h4>
                  <div className="flex items-center space-x-4 text-sm text-gray-500">
                    <span>Yazar: {content.author}</span>
                    <span>Görüntüleme: {content.views}</span>
                    <span>Yayın: {new Date(content.publishDate).toLocaleDateString('tr-TR')}</span>
                  </div>
                </div>
                <div className="flex space-x-2">
                  <button className="text-blue-600 hover:text-blue-900 px-3 py-1 rounded">
                    Düzenle
                  </button>
                  <button className="text-green-600 hover:text-green-900 px-3 py-1 rounded">
                    Görüntüle
                  </button>
                </div>
              </div>
            </div>
          ))}
        </div>
      </div>
    </div>
  )
}

