'use client'

import { useState } from 'react'
import { Search, Plus, Edit, Trash2, ChevronDown, ChevronUp } from 'lucide-react'

export default function SSSPage() {
  const [searchTerm, setSearchTerm] = useState('')
  const [expandedId, setExpandedId] = useState<number | null>(null)

  const faqs = [
    {
      id: 1,
      question: 'Dans kurslarına nasıl kayıt olabilirim?',
      answer: 'Dans kurslarına kayıt olmak için öncelikle kurs detay sayfasını ziyaret edin. Sayfadaki "Kayıt Ol" butonuna tıklayarak kurs sahibiyle iletişime geçebilir veya online kayıt formunu doldurabilirsiniz.',
      category: 'Kayıt',
      status: 'Yayında',
      order: 1
    },
    {
      id: 2,
      question: 'Ücretler nasıl belirleniyor?',
      answer: 'Her kurs sahibi kendi ücretlerini belirlemektedir. Ücretler kursun seviyesine, süresine ve içeriğine göre değişiklik gösterebilir. Detaylı fiyat bilgisi için kurs detay sayfalarını inceleyebilirsiniz.',
      category: 'Ücretler',
      status: 'Yayında',
      order: 2
    },
    {
      id: 3,
      question: 'Kurs sahipleri nasıl kayıt olur?',
      answer: 'Kurs sahipleri "Kurs Ekle" butonuna tıklayarak kayıt formunu doldurabilir. Kayıt işlemi sonrası admin onayı ile kursunuz yayına alınacaktır.',
      category: 'Kurs Sahipleri',
      status: 'Yayında',
      order: 3
    },
    {
      id: 4,
      question: 'İade politikası nedir?',
      answer: 'İade politikaları kurs sahipleri tarafından belirlenmektedir. Her kursun iade koşulları kurs detay sayfasında belirtilmiştir.',
      category: 'İade',
      status: 'Taslak',
      order: 4
    }
  ]

  const filteredFaqs = faqs.filter(faq => 
    faq.question.toLowerCase().includes(searchTerm.toLowerCase()) ||
    faq.answer.toLowerCase().includes(searchTerm.toLowerCase()) ||
    faq.category.toLowerCase().includes(searchTerm.toLowerCase())
  )

  const toggleExpand = (id: number) => {
    setExpandedId(expandedId === id ? null : id)
  }

  const getStatusColor = (status: string) => {
    switch (status) {
      case 'Yayında':
        return 'bg-green-100 text-green-800'
      case 'Taslak':
        return 'bg-yellow-100 text-yellow-800'
      default:
        return 'bg-gray-100 text-gray-800'
    }
  }

  return (
    <div className="space-y-6">
      {/* Header */}
      <div className="flex justify-between items-center">
        <div>
          <h1 className="text-2xl font-bold text-gray-900">Sıkça Sorulan Sorular</h1>
          <p className="text-gray-600">SSS içeriklerini yönetin</p>
        </div>
        <button className="bg-primary-600 hover:bg-primary-700 text-white px-4 py-2 rounded-lg flex items-center space-x-2">
          <Plus className="w-4 h-4" />
          <span>Yeni Soru</span>
        </button>
      </div>

      {/* Stats */}
      <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
        <div className="bg-white p-6 rounded-lg shadow">
          <div className="flex items-center">
            <div className="p-2 bg-blue-100 rounded-lg">
              <div className="w-6 h-6 bg-blue-600 rounded"></div>
            </div>
            <div className="ml-4">
              <p className="text-sm font-medium text-gray-600">Toplam Soru</p>
              <p className="text-2xl font-bold text-gray-900">15</p>
            </div>
          </div>
        </div>
        <div className="bg-white p-6 rounded-lg shadow">
          <div className="flex items-center">
            <div className="p-2 bg-green-100 rounded-lg">
              <div className="w-6 h-6 bg-green-600 rounded"></div>
            </div>
            <div className="ml-4">
              <p className="text-sm font-medium text-gray-600">Yayında</p>
              <p className="text-2xl font-bold text-gray-900">12</p>
            </div>
          </div>
        </div>
        <div className="bg-white p-6 rounded-lg shadow">
          <div className="flex items-center">
            <div className="p-2 bg-yellow-100 rounded-lg">
              <div className="w-6 h-6 bg-yellow-600 rounded"></div>
            </div>
            <div className="ml-4">
              <p className="text-sm font-medium text-gray-600">Taslak</p>
              <p className="text-2xl font-bold text-gray-900">3</p>
            </div>
          </div>
        </div>
      </div>

      {/* Search */}
      <div className="bg-white p-6 rounded-lg shadow">
        <div className="relative">
          <Search className="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400 w-4 h-4" />
          <input
            type="text"
            placeholder="SSS ara..."
            value={searchTerm}
            onChange={(e) => setSearchTerm(e.target.value)}
            className="w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
          />
        </div>
      </div>

      {/* FAQ List */}
      <div className="space-y-4">
        {filteredFaqs.map((faq) => (
          <div key={faq.id} className="bg-white rounded-lg shadow">
            <div className="p-6">
              <div className="flex justify-between items-start mb-2">
                <div className="flex-1">
                  <div className="flex items-center space-x-3 mb-2">
                    <span className="px-2 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">
                      {faq.category}
                    </span>
                    <span className={`inline-flex px-2 py-1 text-xs font-semibold rounded-full ${getStatusColor(faq.status)}`}>
                      {faq.status}
                    </span>
                    <span className="text-sm text-gray-500">
                      Sıra: {faq.order}
                    </span>
                  </div>
                  <button
                    onClick={() => toggleExpand(faq.id)}
                    className="flex items-center justify-between w-full text-left"
                  >
                    <h3 className="text-lg font-semibold text-gray-900">{faq.question}</h3>
                    {expandedId === faq.id ? (
                      <ChevronUp className="w-5 h-5 text-gray-400" />
                    ) : (
                      <ChevronDown className="w-5 h-5 text-gray-400" />
                    )}
                  </button>
                </div>
              </div>

              {expandedId === faq.id && (
                <div className="mt-4 pt-4 border-t border-gray-200">
                  <p className="text-gray-600 mb-4">{faq.answer}</p>
                  <div className="flex space-x-2">
                    <button className="text-blue-600 hover:text-blue-900 px-3 py-1 rounded flex items-center">
                      <Edit className="w-4 h-4 mr-1" />
                      Düzenle
                    </button>
                    <button className="text-red-600 hover:text-red-900 px-3 py-1 rounded flex items-center">
                      <Trash2 className="w-4 h-4 mr-1" />
                      Sil
                    </button>
                  </div>
                </div>
              )}
            </div>
          </div>
        ))}
      </div>
    </div>
  )
}

