'use client'

import { useState } from 'react'
import { Search, Filter, Plus, MoreVertical, Edit, Trash2, Eye, Check, X } from 'lucide-react'

export default function PaketlerPage() {
  const [searchTerm, setSearchTerm] = useState('')
  const [filterStatus, setFilterStatus] = useState('all')

  const packages = [
    {
      id: 1,
      name: 'Temel Paket',
      description: 'Temel kurs listeleme ve yönetim özellikleri',
      price: 99,
      duration: 'Aylık',
      features: ['5 Kurs Listeleme', 'Temel İstatistikler', 'E-posta Desteği'],
      status: 'Aktif',
      subscribers: 45,
      revenue: 4455
    },
    {
      id: 2,
      name: 'Profesyonel Paket',
      description: 'Gelişmiş özellikler ve daha fazla kurs listeleme',
      price: 199,
      duration: 'Aylık',
      features: ['20 Kurs Listeleme', 'Gelişmiş İstatistikler', 'Öncelikli Destek', 'Özel Tasarım'],
      status: 'Aktif',
      subscribers: 23,
      revenue: 4577
    },
    {
      id: 3,
      name: 'Kurumsal Paket',
      description: 'Sınırsız özellikler ve özel destek',
      price: 399,
      duration: 'Aylık',
      features: ['Sınırsız Kurs', 'API Erişimi', '7/24 Destek', 'Özel Entegrasyonlar'],
      status: 'Aktif',
      subscribers: 8,
      revenue: 3192
    },
    {
      id: 4,
      name: 'Yıllık Temel',
      description: 'Temel paket yıllık indirimli',
      price: 999,
      duration: 'Yıllık',
      features: ['5 Kurs Listeleme', 'Temel İstatistikler', 'E-posta Desteği', '2 Ay Ücretsiz'],
      status: 'Aktif',
      subscribers: 12,
      revenue: 11988
    }
  ]

  const filteredPackages = packages.filter(pkg => {
    const matchesSearch = pkg.name.toLowerCase().includes(searchTerm.toLowerCase()) ||
                         pkg.description.toLowerCase().includes(searchTerm.toLowerCase())
    const matchesStatus = filterStatus === 'all' || pkg.status === filterStatus
    return matchesSearch && matchesStatus
  })

  return (
    <div className="space-y-6">
      {/* Header */}
      <div className="flex justify-between items-center">
        <div>
          <h1 className="text-2xl font-bold text-gray-900">Üyelik Paketleri</h1>
          <p className="text-gray-600">Kurs sahipleri için üyelik paketlerini yönetin</p>
        </div>
        <button className="bg-primary-600 hover:bg-primary-700 text-white px-4 py-2 rounded-lg flex items-center space-x-2">
          <Plus className="w-4 h-4" />
          <span>Yeni Paket</span>
        </button>
      </div>

      {/* Stats Cards */}
      <div className="grid grid-cols-1 md:grid-cols-4 gap-6">
        <div className="bg-white p-6 rounded-lg shadow">
          <div className="flex items-center">
            <div className="p-2 bg-blue-100 rounded-lg">
              <div className="w-6 h-6 bg-blue-600 rounded"></div>
            </div>
            <div className="ml-4">
              <p className="text-sm font-medium text-gray-600">Toplam Paket</p>
              <p className="text-2xl font-bold text-gray-900">4</p>
            </div>
          </div>
        </div>
        <div className="bg-white p-6 rounded-lg shadow">
          <div className="flex items-center">
            <div className="p-2 bg-green-100 rounded-lg">
              <div className="w-6 h-6 bg-green-600 rounded"></div>
            </div>
            <div className="ml-4">
              <p className="text-sm font-medium text-gray-600">Aktif Abone</p>
              <p className="text-2xl font-bold text-gray-900">88</p>
            </div>
          </div>
        </div>
        <div className="bg-white p-6 rounded-lg shadow">
          <div className="flex items-center">
            <div className="p-2 bg-purple-100 rounded-lg">
              <div className="w-6 h-6 bg-purple-600 rounded"></div>
            </div>
            <div className="ml-4">
              <p className="text-sm font-medium text-gray-600">Aylık Gelir</p>
              <p className="text-2xl font-bold text-gray-900">₺24,212</p>
            </div>
          </div>
        </div>
        <div className="bg-white p-6 rounded-lg shadow">
          <div className="flex items-center">
            <div className="p-2 bg-orange-100 rounded-lg">
              <div className="w-6 h-6 bg-orange-600 rounded"></div>
            </div>
            <div className="ml-4">
              <p className="text-sm font-medium text-gray-600">Ortalama Fiyat</p>
              <p className="text-2xl font-bold text-gray-900">₺275</p>
            </div>
          </div>
        </div>
      </div>

      {/* Filters */}
      <div className="bg-white p-6 rounded-lg shadow">
        <div className="flex flex-col sm:flex-row gap-4">
          <div className="flex-1">
            <div className="relative">
              <Search className="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400 w-4 h-4" />
              <input
                type="text"
                placeholder="Paket ara..."
                value={searchTerm}
                onChange={(e) => setSearchTerm(e.target.value)}
                className="w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
              />
            </div>
          </div>
          <div className="flex gap-2">
            <select
              value={filterStatus}
              onChange={(e) => setFilterStatus(e.target.value)}
              className="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
            >
              <option value="all">Tüm Durumlar</option>
              <option value="Aktif">Aktif</option>
              <option value="Pasif">Pasif</option>
              <option value="Taslak">Taslak</option>
            </select>
            <button className="px-4 py-2 border border-gray-300 rounded-lg hover:bg-gray-50 flex items-center space-x-2">
              <Filter className="w-4 h-4" />
              <span>Filtrele</span>
            </button>
          </div>
        </div>
      </div>

      {/* Packages Grid */}
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        {filteredPackages.map((pkg) => (
          <div key={pkg.id} className="bg-white rounded-lg shadow-lg overflow-hidden">
            <div className="p-6">
              <div className="flex justify-between items-start mb-4">
                <div>
                  <h3 className="text-xl font-bold text-gray-900">{pkg.name}</h3>
                  <p className="text-gray-600 text-sm">{pkg.description}</p>
                </div>
                <span className={`inline-flex px-2 py-1 text-xs font-semibold rounded-full ${
                  pkg.status === 'Aktif' 
                    ? 'bg-green-100 text-green-800'
                    : 'bg-red-100 text-red-800'
                }`}>
                  {pkg.status}
                </span>
              </div>

              <div className="mb-6">
                <div className="flex items-baseline">
                  <span className="text-3xl font-bold text-gray-900">₺{pkg.price}</span>
                  <span className="text-gray-600 ml-1">/{pkg.duration}</span>
                </div>
              </div>

              <div className="mb-6">
                <h4 className="text-sm font-medium text-gray-900 mb-3">Özellikler:</h4>
                <ul className="space-y-2">
                  {pkg.features.map((feature, index) => (
                    <li key={index} className="flex items-center text-sm text-gray-600">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      {feature}
                    </li>
                  ))}
                </ul>
              </div>

              <div className="border-t pt-4 mb-6">
                <div className="grid grid-cols-2 gap-4 text-sm">
                  <div>
                    <p className="text-gray-600">Abone Sayısı</p>
                    <p className="font-semibold text-gray-900">{pkg.subscribers}</p>
                  </div>
                  <div>
                    <p className="text-gray-600">Aylık Gelir</p>
                    <p className="font-semibold text-gray-900">₺{pkg.revenue.toLocaleString()}</p>
                  </div>
                </div>
              </div>

              <div className="flex space-x-2">
                <button className="flex-1 bg-primary-600 hover:bg-primary-700 text-white py-2 px-4 rounded-lg text-sm font-medium">
                  Düzenle
                </button>
                <button className="px-3 py-2 border border-gray-300 rounded-lg hover:bg-gray-50">
                  <MoreVertical className="w-4 h-4" />
                </button>
              </div>
            </div>
          </div>
        ))}
      </div>

      {/* Create New Package Card */}
      <div className="bg-white rounded-lg shadow-lg border-2 border-dashed border-gray-300 hover:border-primary-500 transition-colors">
        <div className="p-6 text-center">
          <div className="w-12 h-12 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
            <Plus className="w-6 h-6 text-gray-400" />
          </div>
          <h3 className="text-lg font-medium text-gray-900 mb-2">Yeni Paket Oluştur</h3>
          <p className="text-gray-600 mb-4">Kurs sahipleri için yeni bir üyelik paketi ekleyin</p>
          <button className="bg-primary-600 hover:bg-primary-700 text-white px-4 py-2 rounded-lg">
            Paket Oluştur
          </button>
        </div>
      </div>
    </div>
  )
}

