import type { Metadata } from 'next'
import { Inter, Poppins } from 'next/font/google'
import './globals.css'
import Header from '@/components/Header'
import Footer from '@/components/Footer'
import Analytics from '@/components/Analytics'

const inter = Inter({ 
  subsets: ['latin'],
  variable: '--font-inter',
  display: 'swap',
  preload: true,
})

const poppins = Poppins({ 
  subsets: ['latin'],
  weight: ['300', '400', '500', '600', '700', '800'],
  variable: '--font-poppins',
  display: 'swap',
  preload: true,
})

export const metadata: Metadata = {
  title: 'Dans Dersleri - Türkiye\'nin En Kapsamlı Dans Kursu Rehberi',
  description: 'İstanbul, Ankara, İzmir ve tüm Türkiye\'de salsa, bachata, tango, hip-hop ve daha fazla dans türü için en iyi kursları keşfedin. Profesyonel öğretmenler, uygun fiyatlar, kolay rezervasyon.',
  keywords: 'dans kursu, salsa, bachata, tango, hip-hop, dans dersleri, istanbul, ankara, izmir, dans okulu',
  authors: [{ name: 'Dans Dersleri' }],
  creator: 'Dans Dersleri',
  publisher: 'Dans Dersleri',
  formatDetection: {
    email: false,
    address: false,
    telephone: false,
  },
  metadataBase: new URL(process.env.NEXT_PUBLIC_BASE_URL || 'https://dansdersleri.com'),
  alternates: {
    canonical: '/',
    languages: {
      'tr-TR': '/',
    },
  },
  openGraph: {
    title: 'Dans Dersleri - Türkiye\'nin En Kapsamlı Dans Kursu Rehberi',
    description: 'İstanbul, Ankara, İzmir ve tüm Türkiye\'de salsa, bachata, tango, hip-hop ve daha fazla dans türü için en iyi kursları keşfedin.',
    url: 'https://dansdersleri.com',
    siteName: 'Dans Dersleri',
    images: [
      {
        url: '/og-image.jpg',
        width: 1200,
        height: 630,
        alt: 'Dans Dersleri - Dans Kursu Rehberi',
      },
    ],
    locale: 'tr_TR',
    type: 'website',
  },
  twitter: {
    card: 'summary_large_image',
    title: 'Dans Dersleri - Türkiye\'nin En Kapsamlı Dans Kursu Rehberi',
    description: 'İstanbul, Ankara, İzmir ve tüm Türkiye\'de salsa, bachata, tango, hip-hop ve daha fazla dans türü için en iyi kursları keşfedin.',
    images: ['/og-image.jpg'],
    creator: '@dansdersleri',
  },
  robots: {
    index: true,
    follow: true,
    googleBot: {
      index: true,
      follow: true,
      'max-video-preview': -1,
      'max-image-preview': 'large',
      'max-snippet': -1,
    },
  },
  verification: {
    google: process.env.NEXT_PUBLIC_GOOGLE_VERIFICATION,
    yandex: process.env.NEXT_PUBLIC_YANDEX_VERIFICATION,
    other: {
      'msvalidate.01': process.env.NEXT_PUBLIC_BING_VERIFICATION || '',
    },
  },
  category: 'education',
}

export default function RootLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return (
    <html lang="tr" className={`${inter.variable} ${poppins.variable}`}>
      <head>
        <link rel="icon" href="/favicon.ico" sizes="any" />
        <link rel="apple-touch-icon" href="/apple-touch-icon.png" />
        <meta name="theme-color" content="#ef4444" />
      </head>
      <body className="font-sans antialiased">
        <Analytics />
        <Header />
        <main className="min-h-screen">
          {children}
        </main>
        <Footer />
      </body>
    </html>
  )
}
