import { Metadata } from 'next'
import FAQSection from '@/components/FAQSection'
import StructuredData from '@/components/StructuredData'
import { generateFAQSchema } from '@/lib/schema'
import { ChevronDown } from 'lucide-react'

export const metadata: Metadata = {
  title: 'Sık Sorulan Sorular (SSS) - Dans Dersleri',
  description: 'Dans kursları hakkında en çok sorulan sorular ve cevapları. Dans dersleri, fiyatlar, kayıt süreci ve daha fazlası.',
}

const faqs = [
  {
    question: 'Dans dersleri ne kadar sürer?',
    answer: 'Dans derslerinin süresi kursa göre değişiklik gösterir. Genellikle 6-16 hafta arasında değişen programlar sunulmaktadır. Her ders 1.5-2 saat sürmektedir.'
  },
  {
    question: 'Hiç dans deneyimim yok, başlangıç seviyesi için uygun mu?',
    answer: 'Evet! Platformumuzdaki kursların çoğu başlangıç seviyesi öğrenciler için uygundur. Her kurs detayında seviye bilgisi belirtilmektedir.'
  },
  {
    question: 'Fiyatlar nasıl belirleniyor?',
    answer: 'Kurs fiyatları, eğitmenin deneyimi, dersin süresi, grup büyüklüğü ve konum gibi faktörlere göre belirlenmektedir. Ortalama aylık ücretler 100-200 TL arasında değişmektedir.'
  },
  {
    question: 'Kurslara nasıl kayıt olabilirim?',
    answer: 'İlgilendiğiniz kursun detay sayfasından "Hemen Ara" veya "WhatsApp" butonlarını kullanarak doğrudan kurs sahibi ile iletişime geçebilirsiniz.'
  },
  {
    question: 'Hangi dans türlerini öğrenebilirim?',
    answer: 'Platformumuzda Salsa, Bachata, Tango, Hip-Hop, Klasik Bale, Modern Dans, Latin Dansları, Swing ve daha birçok dans türü için kurslar bulabilirsiniz.'
  },
  {
    question: 'Kurs iptali ve iade politikası nedir?',
    answer: 'İptal ve iade politikaları her kurs için farklılık gösterebilir. Kayıt olmadan önce kurs sahibi ile bu detayları konuşmanızı öneririz.'
  },
  {
    question: 'Grup dersleri mi yoksa özel dersler mi daha iyi?',
    answer: 'Her ikisinin de avantajları vardır. Grup dersleri sosyal ortam ve uygun fiyat sunarken, özel dersler kişiselleştirilmiş eğitim ve hızlı ilerleme sağlar.'
  },
  {
    question: 'Hangi şehirlerde kurs var?',
    answer: 'İstanbul, Ankara, İzmir başta olmak üzere Türkiye\'nin 50\'den fazla şehrinde dans kursları bulabilirsiniz.'
  },
  {
    question: 'Kursuma nasıl ekleyebilirim?',
    answer: 'Kurs sahiplerinin "Kurs Ekle" butonuna tıklayarak başvuru yapabilirler. Başvurular incelendikten sonra onaylanır ve yayına alınır.'
  },
  {
    question: 'Öğrenci indirimi var mı?',
    answer: 'Bazı kurslar öğrenci indirimi sunmaktadır. Kurs detaylarında veya doğrudan kurs sahibi ile iletişime geçerek bu konuda bilgi alabilirsiniz.'
  }
]

export default function SSS() {
  return (
    <>
      <StructuredData data={generateFAQSchema(faqs)} />
      
      <div className="min-h-screen bg-gray-50">
        {/* Hero */}
        <div className="bg-gradient-to-br from-primary-600 via-primary-700 to-accent-600 text-white py-16">
          <div className="container-custom">
            <div className="max-w-3xl mx-auto text-center">
              <h1 className="text-4xl md:text-5xl font-bold mb-6">
                Sık Sorulan Sorular
              </h1>
              <p className="text-xl text-gray-100">
                Dans kursları hakkında merak ettikleriniz
              </p>
            </div>
          </div>
        </div>

        {/* FAQ Content */}
        <div className="container-custom py-16">
          <FAQSection faqs={faqs} />
        </div>

        {/* Contact CTA */}
        <div className="container-custom pb-16">
          <div className="bg-white rounded-xl shadow-lg p-8 md:p-12 text-center max-w-4xl mx-auto">
            <h2 className="text-2xl font-bold text-gray-900 mb-4">
              Sorunuzun cevabını bulamadınız mı?
            </h2>
            <p className="text-gray-600 mb-6">
              Size yardımcı olmaktan mutluluk duyarız. Bizimle iletişime geçin.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <a
                href="tel:+902125550123"
                className="btn-primary"
              >
                Bizi Arayın
              </a>
              <a
                href="mailto:info@dansdersleri.com"
                className="btn-outline"
              >
                E-posta Gönderin
              </a>
            </div>
          </div>
        </div>
      </div>
    </>
  )
}

