'use client'

import Link from 'next/link'
import { ChevronRight, Home } from 'lucide-react'

interface BreadcrumbItem {
  name: string
  url: string
}

interface BreadcrumbProps {
  items: BreadcrumbItem[]
  className?: string
}

export default function Breadcrumb({ items, className = '' }: BreadcrumbProps) {
  return (
    <nav 
      aria-label="Breadcrumb" 
      className={`flex items-center space-x-2 text-sm ${className}`}
    >
      <ol className="flex items-center space-x-2 flex-wrap">
        {/* Home link */}
        <li className="flex items-center">
          <Link 
            href="/" 
            className="flex items-center text-gray-600 hover:text-red-500 transition-colors"
            aria-label="Ana Sayfa"
          >
            <Home className="w-4 h-4" />
          </Link>
        </li>

        {items.map((item, index) => {
          const isLast = index === items.length - 1

          return (
            <li key={item.url} className="flex items-center">
              <ChevronRight className="w-4 h-4 text-gray-400 mx-1" />
              {isLast ? (
                <span 
                  className="text-gray-900 font-medium"
                  aria-current="page"
                >
                  {item.name}
                </span>
              ) : (
                <Link 
                  href={item.url}
                  className="text-gray-600 hover:text-red-500 transition-colors"
                >
                  {item.name}
                </Link>
              )}
            </li>
          )
        })}
      </ol>
    </nav>
  )
}

// Alternative compact version
export function BreadcrumbCompact({ items, className = '' }: BreadcrumbProps) {
  if (items.length === 0) return null
  
  return (
    <nav 
      aria-label="Breadcrumb" 
      className={`text-sm ${className}`}
    >
      <ol className="flex items-center space-x-1">
        <li>
          <Link href="/" className="text-gray-500 hover:text-red-500">
            Ana Sayfa
          </Link>
        </li>
        {items.map((item, index) => {
          const isLast = index === items.length - 1
          return (
            <li key={item.url} className="flex items-center">
              <span className="mx-1 text-gray-400">/</span>
              {isLast ? (
                <span className="text-gray-900">{item.name}</span>
              ) : (
                <Link href={item.url} className="text-gray-500 hover:text-red-500">
                  {item.name}
                </Link>
              )}
            </li>
          )
        })}
      </ol>
    </nav>
  )
}

