'use client'

import Link from 'next/link'
import { ArrowRight, Award, CheckCircle } from 'lucide-react'

export default function CTA() {
  const features = [
    '500+ Doğrulanmış Dans Kursu',
    '50+ Şehirde Hizmet',
    'Profesyonel Öğretmenler',
    'Uygun Fiyat Garantisi',
    '7/24 Müşteri Desteği'
  ]

  return (
    <section className="section-padding bg-gradient-to-br from-primary-600 via-primary-700 to-accent-600 text-white relative overflow-hidden">
      {/* Background Pattern */}
      <div className="absolute inset-0 bg-black/20"></div>
      <div className="absolute inset-0 opacity-30" style={{
        backgroundImage: `url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Ccircle cx='30' cy='30' r='2'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E")`
      }}></div>
      
      <div className="relative container-custom">
        <div className="max-w-4xl mx-auto text-center">
          {/* Main Content */}
          <h2 className="text-4xl md:text-6xl font-bold mb-6">
            Dans Etmeye
            <span className="block text-yellow-300">Hemen Başla!</span>
          </h2>
          
          <p className="text-xl md:text-2xl mb-8 text-gray-100 max-w-3xl mx-auto">
            Türkiye'nin en kapsamlı dans kursu rehberi ile hayalindeki dansı öğren. 
            Profesyonel öğretmenler, kaliteli eğitim ve unutulmaz deneyimler seni bekliyor.
          </p>

          {/* Features */}
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 mb-12 max-w-4xl mx-auto">
            {features.map((feature, index) => (
              <div key={index} className="flex items-center space-x-3 bg-white/10 backdrop-blur-sm rounded-lg p-4">
                <CheckCircle className="w-5 h-5 text-yellow-300 flex-shrink-0" />
                <span className="text-gray-100 font-medium">{feature}</span>
              </div>
            ))}
          </div>

          {/* CTA Buttons */}
          <div className="flex flex-col sm:flex-row gap-4 justify-center items-center mb-12">
            <Link
              href="/kurslar"
              className="bg-white text-primary-600 hover:bg-gray-100 font-bold py-4 px-8 rounded-xl text-lg transition-all duration-300 hover:scale-105 shadow-xl inline-flex items-center space-x-2"
            >
              <span>Kurs Ara</span>
              <ArrowRight className="w-5 h-5" />
            </Link>
            <Link
              href="/kurs-ekle"
              className="border-2 border-white text-white hover:bg-white hover:text-primary-600 font-bold py-4 px-8 rounded-xl text-lg transition-all duration-300 hover:scale-105 inline-flex items-center space-x-2"
            >
              <span>Kurs Ekle</span>
              <Award className="w-5 h-5" />
            </Link>
          </div>

          {/* Stats */}
          <div className="grid grid-cols-2 md:grid-cols-4 gap-8 max-w-3xl mx-auto">
            <div className="text-center">
              <div className="text-3xl md:text-4xl font-bold text-yellow-300 mb-2">500+</div>
              <div className="text-gray-200 text-sm">Dans Kursu</div>
            </div>
            <div className="text-center">
              <div className="text-3xl md:text-4xl font-bold text-yellow-300 mb-2">50+</div>
              <div className="text-gray-200 text-sm">Şehir</div>
            </div>
            <div className="text-center">
              <div className="text-3xl md:text-4xl font-bold text-yellow-300 mb-2">10K+</div>
              <div className="text-gray-200 text-sm">Mutlu Öğrenci</div>
            </div>
            <div className="text-center">
              <div className="text-3xl md:text-4xl font-bold text-yellow-300 mb-2">4.9</div>
              <div className="text-gray-200 text-sm">Ortalama Puan</div>
            </div>
          </div>
        </div>
      </div>

      {/* Floating Elements */}
      <div className="absolute top-20 left-10 animate-bounce-slow">
        <div className="w-20 h-20 bg-yellow-300/20 rounded-full flex items-center justify-center">
          <span className="text-3xl">💃</span>
        </div>
      </div>
      <div className="absolute bottom-20 right-10 animate-bounce-slow" style={{ animationDelay: '1s' }}>
        <div className="w-24 h-24 bg-pink-300/20 rounded-full flex items-center justify-center">
          <span className="text-4xl">🕺</span>
        </div>
      </div>
      <div className="absolute top-1/2 left-20 animate-bounce-slow" style={{ animationDelay: '2s' }}>
        <div className="w-16 h-16 bg-blue-300/20 rounded-full flex items-center justify-center">
          <span className="text-2xl">🎵</span>
        </div>
      </div>
    </section>
  )
}

