'use client'

import { useState } from 'react'
import { Search, MapPin, Filter, Star } from 'lucide-react'
import Link from 'next/link'

export default function Hero() {
  const [searchQuery, setSearchQuery] = useState('')
  const [selectedCity, setSelectedCity] = useState('')
  const [selectedDanceType, setSelectedDanceType] = useState('')

  const cities = [
    'İstanbul', 'Ankara', 'İzmir', 'Bursa', 'Antalya', 'Adana', 'Konya', 'Gaziantep'
  ]

  const danceTypes = [
    'Salsa', 'Bachata', 'Tango', 'Hip-Hop', 'Klasik Bale', 'Modern Dans', 'Latin Dansları'
  ]

  return (
    <section className="relative bg-gradient-to-br from-primary-600 via-primary-700 to-accent-600 text-white overflow-hidden">
      {/* Background Pattern */}
      <div className="absolute inset-0 bg-black/20"></div>
      <div className="absolute inset-0 opacity-30" style={{
        backgroundImage: `url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Ccircle cx='30' cy='30' r='2'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E")`
      }}></div>
      
      <div className="relative container-custom section-padding">
        <div className="max-w-4xl mx-auto text-center">
          {/* Main Heading */}
          <h1 className="text-4xl md:text-6xl font-bold mb-6 animate-fade-in">
            Türkiye'nin En Kapsamlı
            <span className="block text-yellow-300">Dans Kursu Rehberi</span>
          </h1>
          
          <p className="text-xl md:text-2xl mb-8 text-gray-100 animate-slide-up">
            İstanbul, Ankara, İzmir ve tüm şehirlerde profesyonel dans kurslarını keşfedin.
            <br />
            Salsa, Bachata, Tango, Hip-Hop ve daha fazlası...
          </p>

          {/* Search Form */}
          <div className="bg-white rounded-2xl p-6 shadow-2xl mb-8 animate-slide-up">
            <div className="grid grid-cols-1 md:grid-cols-4 gap-4">
              {/* Search Input */}
              <div className="md:col-span-2">
                <div className="relative">
                  <Search className="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400 w-5 h-5" aria-hidden="true" />
                  <input
                    type="text"
                    placeholder="Dans türü veya kurs adı ara..."
                    value={searchQuery}
                    onChange={(e) => setSearchQuery(e.target.value)}
                    aria-label="Dans türü veya kurs adı ara"
                    className="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent text-gray-900"
                  />
                </div>
              </div>

              {/* City Select */}
              <div>
                <label htmlFor="hero-city-select" className="sr-only">Şehir seçin</label>
                <div className="relative">
                  <MapPin className="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400 w-5 h-5" aria-hidden="true" />
                  <select
                    id="hero-city-select"
                    value={selectedCity}
                    onChange={(e) => setSelectedCity(e.target.value)}
                    aria-label="Şehir seçin"
                    className="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent text-gray-900 appearance-none bg-white"
                  >
                    <option value="">Şehir Seçin</option>
                    {cities.map((city) => (
                      <option key={city} value={city}>{city}</option>
                    ))}
                  </select>
                </div>
              </div>

              {/* Dance Type Select */}
              <div>
                <label htmlFor="hero-dance-type-select" className="sr-only">Dans türü seçin</label>
                <div className="relative">
                  <Filter className="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400 w-5 h-5" aria-hidden="true" />
                  <select
                    id="hero-dance-type-select"
                    value={selectedDanceType}
                    onChange={(e) => setSelectedDanceType(e.target.value)}
                    aria-label="Dans türü seçin"
                    className="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent text-gray-900 appearance-none bg-white"
                  >
                    <option value="">Dans Türü</option>
                    {danceTypes.map((type) => (
                      <option key={type} value={type}>{type}</option>
                    ))}
                  </select>
                </div>
              </div>
            </div>

            {/* Search Button */}
            <div className="mt-4">
              <Link 
                href={`/arama?q=${encodeURIComponent(searchQuery)}&city=${selectedCity}&type=${selectedDanceType}`}
                className="btn-primary text-lg px-8 py-3 inline-flex items-center space-x-2"
              >
                <Search className="w-5 h-5" />
                <span>Kurs Ara</span>
              </Link>
            </div>
          </div>

          {/* Stats */}
          <div className="grid grid-cols-2 md:grid-cols-4 gap-6 text-center">
            <div className="animate-fade-in">
              <div className="text-3xl md:text-4xl font-bold text-yellow-300 mb-2">500+</div>
              <div className="text-gray-200">Dans Kursu</div>
            </div>
            <div className="animate-fade-in" style={{ animationDelay: '0.1s' }}>
              <div className="text-3xl md:text-4xl font-bold text-yellow-300 mb-2">50+</div>
              <div className="text-gray-200">Şehir</div>
            </div>
            <div className="animate-fade-in" style={{ animationDelay: '0.2s' }}>
              <div className="text-3xl md:text-4xl font-bold text-yellow-300 mb-2">15+</div>
              <div className="text-gray-200">Dans Türü</div>
            </div>
            <div className="animate-fade-in" style={{ animationDelay: '0.3s' }}>
              <div className="text-3xl md:text-4xl font-bold text-yellow-300 mb-2">10K+</div>
              <div className="text-gray-200">Mutlu Öğrenci</div>
            </div>
          </div>
        </div>
      </div>

      {/* Floating Elements */}
      <div className="absolute top-20 left-10 animate-bounce-slow">
        <div className="w-16 h-16 bg-yellow-300/20 rounded-full flex items-center justify-center">
          <span className="text-2xl">💃</span>
        </div>
      </div>
      <div className="absolute bottom-20 right-10 animate-bounce-slow" style={{ animationDelay: '1s' }}>
        <div className="w-20 h-20 bg-pink-300/20 rounded-full flex items-center justify-center">
          <span className="text-3xl">🕺</span>
        </div>
      </div>
    </section>
  )
}
