'use client'

import Link from 'next/link'
import { School, Eye, Edit, Trash2, Star, MapPin } from 'lucide-react'

export default function RecentCourses() {
  const courses = [
    {
      id: 1,
      name: 'Salsa & Bachata Akademi',
      city: 'İstanbul',
      rating: 4.9,
      students: 127,
      status: 'active',
      date: '2024-01-15'
    },
    {
      id: 2,
      name: 'Modern Dans Stüdyosu',
      city: 'Ankara',
      rating: 4.8,
      students: 89,
      status: 'active',
      date: '2024-01-14'
    },
    {
      id: 3,
      name: 'Tango Passion',
      city: 'İzmir',
      rating: 4.9,
      students: 156,
      status: 'pending',
      date: '2024-01-13'
    },
    {
      id: 4,
      name: 'Hip-Hop Academy',
      city: 'İstanbul',
      rating: 4.7,
      students: 203,
      status: 'active',
      date: '2024-01-12'
    },
    {
      id: 5,
      name: 'Bale & Dans Okulu',
      city: 'Bursa',
      rating: 4.9,
      students: 78,
      status: 'active',
      date: '2024-01-11'
    }
  ]

  return (
    <div className="bg-white rounded-xl shadow-lg p-6">
      <div className="flex items-center justify-between mb-6">
        <div>
          <h3 className="text-lg font-semibold text-gray-900 flex items-center space-x-2">
            <School className="w-5 h-5 text-primary-600" />
            <span>Son Eklenen Kurslar</span>
          </h3>
          <p className="text-sm text-gray-600 mt-1">En yeni kurs kayıtları</p>
        </div>
        <Link
          href="/admin/kurslar"
          className="text-sm text-primary-600 hover:text-primary-700 font-medium"
        >
          Tümünü Gör →
        </Link>
      </div>

      {/* Table */}
      <div className="overflow-x-auto">
        <table className="w-full">
          <thead>
            <tr className="border-b border-gray-200">
              <th className="text-left py-3 px-2 text-xs font-semibold text-gray-600 uppercase">Kurs Adı</th>
              <th className="text-left py-3 px-2 text-xs font-semibold text-gray-600 uppercase">Şehir</th>
              <th className="text-left py-3 px-2 text-xs font-semibold text-gray-600 uppercase">Puan</th>
              <th className="text-left py-3 px-2 text-xs font-semibold text-gray-600 uppercase">Durum</th>
              <th className="text-right py-3 px-2 text-xs font-semibold text-gray-600 uppercase">İşlemler</th>
            </tr>
          </thead>
          <tbody>
            {courses.map((course) => (
              <tr key={course.id} className="border-b border-gray-100 hover:bg-gray-50">
                <td className="py-3 px-2">
                  <div>
                    <p className="text-sm font-medium text-gray-900">{course.name}</p>
                    <p className="text-xs text-gray-500">{course.students} öğrenci</p>
                  </div>
                </td>
                <td className="py-3 px-2">
                  <div className="flex items-center space-x-1 text-sm text-gray-600">
                    <MapPin className="w-3 h-3" />
                    <span>{course.city}</span>
                  </div>
                </td>
                <td className="py-3 px-2">
                  <div className="flex items-center space-x-1">
                    <Star className="w-4 h-4 text-yellow-400 fill-current" />
                    <span className="text-sm font-medium text-gray-900">{course.rating}</span>
                  </div>
                </td>
                <td className="py-3 px-2">
                  <span
                    className={`inline-flex items-center px-2 py-1 rounded-full text-xs font-medium ${
                      course.status === 'active'
                        ? 'bg-green-100 text-green-800'
                        : 'bg-yellow-100 text-yellow-800'
                    }`}
                  >
                    {course.status === 'active' ? 'Aktif' : 'Beklemede'}
                  </span>
                </td>
                <td className="py-3 px-2">
                  <div className="flex items-center justify-end space-x-2">
                    <button className="p-1 text-gray-400 hover:text-blue-600 transition-colors">
                      <Eye className="w-4 h-4" />
                    </button>
                    <button className="p-1 text-gray-400 hover:text-green-600 transition-colors">
                      <Edit className="w-4 h-4" />
                    </button>
                    <button className="p-1 text-gray-400 hover:text-red-600 transition-colors">
                      <Trash2 className="w-4 h-4" />
                    </button>
                  </div>
                </td>
              </tr>
            ))}
          </tbody>
        </table>
      </div>
    </div>
  )
}
