'use client'

import { DollarSign, CheckCircle, Clock, XCircle } from 'lucide-react'

export default function RecentPayments() {
  const payments = [
    {
      id: 1,
      courseName: 'Salsa & Bachata Akademi',
      amount: 399,
      date: '2024-01-15',
      status: 'completed',
      package: 'VIP'
    },
    {
      id: 2,
      courseName: 'Modern Dans Stüdyosu',
      amount: 199,
      date: '2024-01-15',
      status: 'completed',
      package: 'Premium'
    },
    {
      id: 3,
      courseName: 'Tango Passion',
      amount: 399,
      date: '2024-01-14',
      status: 'pending',
      package: 'VIP'
    },
    {
      id: 4,
      courseName: 'Hip-Hop Academy',
      amount: 199,
      date: '2024-01-14',
      status: 'completed',
      package: 'Premium'
    },
    {
      id: 5,
      courseName: 'Bale & Dans Okulu',
      amount: 99,
      date: '2024-01-13',
      status: 'failed',
      package: 'Basic'
    }
  ]

  const getStatusIcon = (status: string) => {
    switch (status) {
      case 'completed':
        return <CheckCircle className="w-5 h-5 text-green-600" />
      case 'pending':
        return <Clock className="w-5 h-5 text-yellow-600" />
      case 'failed':
        return <XCircle className="w-5 h-5 text-red-600" />
      default:
        return null
    }
  }

  const getStatusText = (status: string) => {
    switch (status) {
      case 'completed':
        return { text: 'Tamamlandı', color: 'bg-green-100 text-green-800' }
      case 'pending':
        return { text: 'Beklemede', color: 'bg-yellow-100 text-yellow-800' }
      case 'failed':
        return { text: 'Başarısız', color: 'bg-red-100 text-red-800' }
      default:
        return { text: 'Bilinmiyor', color: 'bg-gray-100 text-gray-800' }
    }
  }

  const getPackageColor = (pkg: string) => {
    switch (pkg) {
      case 'VIP':
        return 'bg-purple-100 text-purple-800'
      case 'Premium':
        return 'bg-blue-100 text-blue-800'
      case 'Basic':
        return 'bg-gray-100 text-gray-800'
      default:
        return 'bg-gray-100 text-gray-800'
    }
  }

  const totalAmount = payments
    .filter(p => p.status === 'completed')
    .reduce((sum, p) => sum + p.amount, 0)

  return (
    <div className="bg-white rounded-xl shadow-lg p-6">
      <div className="flex items-center justify-between mb-6">
        <div>
          <h3 className="text-lg font-semibold text-gray-900 flex items-center space-x-2">
            <DollarSign className="w-5 h-5 text-primary-600" />
            <span>Son Ödemeler</span>
          </h3>
          <p className="text-sm text-gray-600 mt-1">Son yapılan işlemler</p>
        </div>
        <div className="text-right">
          <p className="text-sm text-gray-600">Toplam</p>
          <p className="text-xl font-bold text-green-600">₺{totalAmount}</p>
        </div>
      </div>

      {/* Payment List */}
      <div className="space-y-4">
        {payments.map((payment) => {
          const statusInfo = getStatusText(payment.status)
          return (
            <div
              key={payment.id}
              className="flex items-center justify-between p-4 rounded-lg border border-gray-200 hover:bg-gray-50 transition-colors"
            >
              <div className="flex items-center space-x-4">
                <div className="flex-shrink-0">
                  {getStatusIcon(payment.status)}
                </div>
                <div>
                  <p className="text-sm font-medium text-gray-900">{payment.courseName}</p>
                  <div className="flex items-center space-x-2 mt-1">
                    <span className={`inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium ${getPackageColor(payment.package)}`}>
                      {payment.package}
                    </span>
                    <span className="text-xs text-gray-500">{payment.date}</span>
                  </div>
                </div>
              </div>
              <div className="text-right">
                <p className="text-sm font-bold text-gray-900">₺{payment.amount}</p>
                <span className={`inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium mt-1 ${statusInfo.color}`}>
                  {statusInfo.text}
                </span>
              </div>
            </div>
          )
        })}
      </div>

      {/* Summary */}
      <div className="mt-6 pt-6 border-t border-gray-200">
        <div className="grid grid-cols-3 gap-4 text-center">
          <div>
            <p className="text-xs text-gray-600">Tamamlanan</p>
            <p className="text-lg font-bold text-green-600">
              {payments.filter(p => p.status === 'completed').length}
            </p>
          </div>
          <div>
            <p className="text-xs text-gray-600">Bekleyen</p>
            <p className="text-lg font-bold text-yellow-600">
              {payments.filter(p => p.status === 'pending').length}
            </p>
          </div>
          <div>
            <p className="text-xs text-gray-600">Başarısız</p>
            <p className="text-lg font-bold text-red-600">
              {payments.filter(p => p.status === 'failed').length}
            </p>
          </div>
        </div>
      </div>
    </div>
  )
}
