'use client'

import { useState } from 'react'
import { TrendingUp } from 'lucide-react'

export default function RevenueChart() {
  const [period, setPeriod] = useState<'week' | 'month' | 'year'>('month')

  // Mock data - gerçek uygulamada API'den gelecek
  const monthlyData = [
    { month: 'Oca', gelir: 35000, kurs: 42 },
    { month: 'Şub', gelir: 38000, kurs: 48 },
    { month: 'Mar', gelir: 42000, kurs: 53 },
    { month: 'Nis', gelir: 39000, kurs: 49 },
    { month: 'May', gelir: 45000, kurs: 58 },
    { month: 'Haz', gelir: 48000, kurs: 62 }
  ]

  const maxGelir = Math.max(...monthlyData.map(d => d.gelir))

  return (
    <div className="bg-white rounded-xl shadow-lg p-6">
      <div className="flex items-center justify-between mb-6">
        <div>
          <h3 className="text-lg font-semibold text-gray-900 flex items-center space-x-2">
            <TrendingUp className="w-5 h-5 text-primary-600" />
            <span>Gelir Analizi</span>
          </h3>
          <p className="text-sm text-gray-600 mt-1">Son 6 aylık gelir trendi</p>
        </div>
        <div className="flex space-x-2">
          <button
            onClick={() => setPeriod('week')}
            className={`px-3 py-1 text-sm rounded-lg ${
              period === 'week'
                ? 'bg-primary-600 text-white'
                : 'bg-gray-100 text-gray-600 hover:bg-gray-200'
            }`}
          >
            Hafta
          </button>
          <button
            onClick={() => setPeriod('month')}
            className={`px-3 py-1 text-sm rounded-lg ${
              period === 'month'
                ? 'bg-primary-600 text-white'
                : 'bg-gray-100 text-gray-600 hover:bg-gray-200'
            }`}
          >
            Ay
          </button>
          <button
            onClick={() => setPeriod('year')}
            className={`px-3 py-1 text-sm rounded-lg ${
              period === 'year'
                ? 'bg-primary-600 text-white'
                : 'bg-gray-100 text-gray-600 hover:bg-gray-200'
            }`}
          >
            Yıl
          </button>
        </div>
      </div>

      {/* Chart */}
      <div className="space-y-4">
        {monthlyData.map((data, index) => (
          <div key={index}>
            <div className="flex items-center justify-between mb-2">
              <span className="text-sm font-medium text-gray-700">{data.month}</span>
              <div className="text-right">
                <span className="text-sm font-bold text-gray-900">₺{data.gelir.toLocaleString('tr-TR')}</span>
                <span className="text-xs text-gray-500 ml-2">({data.kurs} kurs)</span>
              </div>
            </div>
            <div className="w-full bg-gray-200 rounded-full h-3">
              <div
                className="bg-gradient-to-r from-primary-600 to-accent-600 h-3 rounded-full transition-all duration-300"
                style={{ width: `${(data.gelir / maxGelir) * 100}%` }}
              ></div>
            </div>
          </div>
        ))}
      </div>

      {/* Summary */}
      <div className="mt-6 pt-6 border-t border-gray-200">
        <div className="grid grid-cols-2 gap-4">
          <div>
            <p className="text-sm text-gray-600">Toplam Gelir</p>
            <p className="text-2xl font-bold text-gray-900">₺247,000</p>
          </div>
          <div>
            <p className="text-sm text-gray-600">Ortalama</p>
            <p className="text-2xl font-bold text-gray-900">₺41,167</p>
          </div>
        </div>
      </div>
    </div>
  )
}
