interface Course {
  id: string
  name: string
  location: string
  danceTypes: string[]
  description: string
  longDescription: string
  features: string[]
  price: number
  currency: string
  duration: string
  level: string
}

interface CourseDetailsProps {
  course: Course
}

export default function CourseDetails({ course }: CourseDetailsProps) {
  return (
    <div className="bg-white rounded-xl shadow-lg p-6 md:p-8">
      <h2 className="text-2xl font-bold text-gray-900 mb-6">Kurs Detayları</h2>
      
      {/* Long Description */}
      <div className="mb-8">
        <h3 className="text-lg font-semibold text-gray-900 mb-3">Açıklama</h3>
        <div className="prose prose-gray max-w-none">
          {course.longDescription.split('\n\n').map((paragraph, index) => (
            <p key={index} className="text-gray-700 leading-relaxed mb-4">
              {paragraph}
            </p>
          ))}
        </div>
      </div>

      {/* Course Info Grid */}
      <div className="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
        <div className="space-y-4">
          <div>
            <h4 className="font-semibold text-gray-900 mb-2">Dans Türleri</h4>
            <div className="flex flex-wrap gap-2">
              {course.danceTypes.map((type) => (
                <span
                  key={type}
                  className="bg-primary-100 text-primary-800 px-3 py-1 rounded-full text-sm font-medium"
                >
                  {type}
                </span>
              ))}
            </div>
          </div>

          <div>
            <h4 className="font-semibold text-gray-900 mb-2">Seviye</h4>
            <span className="bg-blue-100 text-blue-800 px-3 py-1 rounded-full text-sm font-medium">
              {course.level}
            </span>
          </div>

          <div>
            <h4 className="font-semibold text-gray-900 mb-2">Süre</h4>
            <span className="text-gray-700">{course.duration}</span>
          </div>
        </div>

        <div className="space-y-4">
          <div>
            <h4 className="font-semibold text-gray-900 mb-2">Fiyat</h4>
            <span className="text-2xl font-bold text-primary-600">
              {course.price} {course.currency}/ay
            </span>
          </div>

          <div>
            <h4 className="font-semibold text-gray-900 mb-2">Konum</h4>
            <span className="text-gray-700">{course.location}</span>
          </div>

          <div>
            <h4 className="font-semibold text-gray-900 mb-2">Kurs ID</h4>
            <span className="text-gray-500 font-mono text-sm">#{course.id}</span>
          </div>
        </div>
      </div>

      {/* Features */}
      <div>
        <h3 className="text-lg font-semibold text-gray-900 mb-4">Kurs Özellikleri</h3>
        <div className="grid grid-cols-1 md:grid-cols-2 gap-3">
          {course.features.map((feature, index) => (
            <div key={index} className="flex items-center space-x-3">
              <div className="w-2 h-2 bg-primary-500 rounded-full flex-shrink-0"></div>
              <span className="text-gray-700">{feature}</span>
            </div>
          ))}
        </div>
      </div>
    </div>
  )
}

