import Image from 'next/image'
import { Award, Star, Calendar, Users } from 'lucide-react'

interface Instructor {
  name: string
  title: string
  experience: string
  specialties: string[]
  image: string
  bio: string
  achievements: string[]
}

interface CourseInstructorProps {
  instructor: Instructor
}

export default function CourseInstructor({ instructor }: CourseInstructorProps) {
  return (
    <div className="bg-white rounded-xl shadow-lg p-6 md:p-8">
      <h2 className="text-2xl font-bold text-gray-900 mb-6">Eğitmen</h2>
      
      <div className="flex flex-col md:flex-row gap-6">
        {/* Instructor Image */}
        <div className="flex-shrink-0">
          <Image
            src={instructor.image}
            alt={instructor.name}
            width={200}
            height={200}
            className="w-48 h-48 rounded-xl object-cover mx-auto md:mx-0"
          />
        </div>

        {/* Instructor Info */}
        <div className="flex-1">
          <div className="mb-4">
            <h3 className="text-2xl font-bold text-gray-900 mb-1">
              {instructor.name}
            </h3>
            <p className="text-lg text-primary-600 font-semibold mb-2">
              {instructor.title}
            </p>
            <div className="flex items-center space-x-4 text-sm text-gray-600">
              <div className="flex items-center space-x-1">
                <Calendar className="w-4 h-4" />
                <span>{instructor.experience} deneyim</span>
              </div>
            </div>
          </div>

          {/* Bio */}
          <p className="text-gray-700 leading-relaxed mb-6">
            {instructor.bio}
          </p>

          {/* Specialties */}
          <div className="mb-6">
            <h4 className="font-semibold text-gray-900 mb-3">Uzmanlık Alanları</h4>
            <div className="flex flex-wrap gap-2">
              {instructor.specialties.map((specialty) => (
                <span
                  key={specialty}
                  className="bg-primary-100 text-primary-800 px-3 py-1 rounded-full text-sm font-medium"
                >
                  {specialty}
                </span>
              ))}
            </div>
          </div>

          {/* Achievements */}
          <div>
            <h4 className="font-semibold text-gray-900 mb-3">Başarılar & Sertifikalar</h4>
            <div className="space-y-2">
              {instructor.achievements.map((achievement, index) => (
                <div key={index} className="flex items-start space-x-3">
                  <Award className="w-5 h-5 text-yellow-500 flex-shrink-0 mt-0.5" />
                  <span className="text-gray-700 text-sm">{achievement}</span>
                </div>
              ))}
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}

