# PHP 8.1 Kurulum Rehberi - Firma Rehberi Pro

Bu rehber, **Firma Rehberi Pro** temasını PHP 8.1.21 sunucunuzda nasıl kuracağınızı adım adım açıklar.

## 🚀 **Hızlı Kurulum**

### **1. Sunucu Gereksinimleri**
- ✅ **PHP 8.1.21** (Mevcut)
- ✅ **WordPress 6.6+**
- ✅ **MySQL 5.7+** veya **MariaDB 10.3+**
- ✅ **Apache/Nginx** web sunucusu
- ✅ **SSL Sertifikası** (HTTPS)

### **2. Tema Dosyalarını Yükleme**

```bash
# Tema klasörünü sunucunuza yükleyin
# Örnek: /public_html/wp-content/themes/firma-rehberi-pro/

# Dosya izinlerini ayarlayın
chmod -R 755 /public_html/wp-content/themes/firma-rehberi-pro/
chmod -R 644 /public_html/wp-content/themes/firma-rehberi-pro/assets/
```

### **3. WordPress Admin'de Aktivasyon**

1. **WordPress Admin'e giriş yapın**
   ```
   https://yourdomain.com/wp-admin
   ```

2. **Tema aktivasyonu**
   - Görünüm → Temalar
   - "Firma Rehberi Pro" temasını bulun
   - "Etkinleştir" tıklayın

3. **PHP 8.1 uyumluluk kontrolü**
   - Tema otomatik olarak PHP sürümünüzü kontrol eder
   - Uyumsuzluk varsa admin panelinde uyarı görürsünüz

## ⚙️ **Detaylı Konfigürasyon**

### **1. PHP 8.1 Optimizasyonları**

Tema, PHP 8.1 için özel optimizasyonlar içerir:

```php
// wp-config.php dosyasına ekleyin
define('WP_MEMORY_LIMIT', '256M');
define('WP_MAX_MEMORY_LIMIT', '512M');

// OPcache ayarları (sunucu yöneticisi ile)
opcache.memory_consumption=128
opcache.interned_strings_buffer=8
opcache.max_accelerated_files=4000
opcache.revalidate_freq=2
opcache.fast_shutdown=1
```

### **2. Veritabanı Optimizasyonları**

```sql
-- MySQL optimizasyonları
ALTER TABLE wp_posts ADD INDEX idx_post_type_status (post_type, post_status);
ALTER TABLE wp_postmeta ADD INDEX idx_meta_key_value (meta_key, meta_value(191));
ALTER TABLE wp_term_relationships ADD INDEX idx_object_term (object_id, term_taxonomy_id);
```

### **3. .htaccess Optimizasyonları**

```apache
# Gzip sıkıştırma
<IfModule mod_deflate.c>
    AddOutputFilterByType DEFLATE text/plain
    AddOutputFilterByType DEFLATE text/html
    AddOutputFilterByType DEFLATE text/xml
    AddOutputFilterByType DEFLATE text/css
    AddOutputFilterByType DEFLATE application/xml
    AddOutputFilterByType DEFLATE application/xhtml+xml
    AddOutputFilterByType DEFLATE application/rss+xml
    AddOutputFilterByType DEFLATE application/javascript
    AddOutputFilterByType DEFLATE application/x-javascript
</IfModule>

# Browser caching
<IfModule mod_expires.c>
    ExpiresActive on
    ExpiresByType text/css "access plus 1 year"
    ExpiresByType application/javascript "access plus 1 year"
    ExpiresByType image/png "access plus 1 year"
    ExpiresByType image/jpg "access plus 1 year"
    ExpiresByType image/jpeg "access plus 1 year"
    ExpiresByType image/gif "access plus 1 year"
    ExpiresByType image/svg+xml "access plus 1 year"
</IfModule>

# Security headers
<IfModule mod_headers.c>
    Header always set X-Content-Type-Options nosniff
    Header always set X-Frame-Options DENY
    Header always set X-XSS-Protection "1; mode=block"
    Header always set Referrer-Policy "strict-origin-when-cross-origin"
</IfModule>
```

## 🎯 **Tema Özelleştirme**

### **1. Temel Ayarlar**

```php
// Görünüm → Özelleştir
- Site Kimliği: Site adı ve açıklaması
- Renkler: Tema renklerini ayarlayın
- Menüler: Ana menü oluşturun
- Widget'lar: Sidebar widget'ları ekleyin
```

### **2. Firma Rehberi Ayarları**

```php
// Görünüm → Özelleştir → Firma Rehberi Ayarları
- Google Maps API Key
- İletişim bilgileri
- Sosyal medya linkleri
- SEO ayarları
- Performans ayarları
```

### **3. Örnek Veri Ekleme**

```php
// WordPress Admin → Firmalar → Yeni Ekle
// Her firma için:
- Başlık: "ABC Teknoloji Ltd."
- İçerik: Firma açıklaması
- Kategori: Teknoloji
- Şehir: İstanbul
- Öne Çıkan Resim: Logo yükleyin
- Firma Detayları:
  - Kısa Açıklama
  - Adres
  - Telefon
  - E-posta
  - Web sitesi
  - Sosyal medya linkleri
  - Çalışma saatleri
  - Harita koordinatları
```

## 🔧 **PHP 8.1 Özel Özellikler**

### **1. Performans Optimizasyonları**

Tema, PHP 8.1 için özel optimizasyonlar içerir:

- ✅ **OPcache optimizasyonu**
- ✅ **Memory management**
- ✅ **Query optimization**
- ✅ **Asset loading optimization**
- ✅ **Caching strategies**

### **2. Hata Yönetimi**

```php
// PHP 8.1 uyumlu hata yönetimi
- Deprecated function uyarıları
- Type hinting optimizasyonları
- Memory usage monitoring
- Performance tracking
```

### **3. Güvenlik Özellikleri**

```php
// PHP 8.1 güvenlik özellikleri
- Input sanitization
- Output escaping
- Nonce verification
- Capability checks
- SQL injection prevention
```

## 📊 **Performans Testi**

### **1. Lighthouse Testi**

```bash
# Google PageSpeed Insights
https://pagespeed.web.dev/

# Beklenen sonuçlar:
- Performance: 100/100
- Accessibility: 100/100
- Best Practices: 100/100
- SEO: 100/100
```

### **2. GTmetrix Testi**

```bash
# GTmetrix
https://gtmetrix.com/

# Beklenen sonuçlar:
- PageSpeed Score: A (90-100)
- YSlow Score: A (90-100)
- Load Time: < 2 saniye
- Total Page Size: < 1 MB
```

### **3. PHP 8.1 Performans**

```php
// Performans metrikleri
- Memory Usage: < 64MB
- Execution Time: < 0.5 saniye
- Database Queries: < 50
- Cache Hit Rate: > 80%
```

## 🐛 **Sorun Giderme**

### **1. PHP 8.1 Uyumluluk Sorunları**

```php
// wp-config.php'de debug modunu açın
define('WP_DEBUG', true);
define('WP_DEBUG_LOG', true);
define('WP_DEBUG_DISPLAY', false);

// Hata loglarını kontrol edin
tail -f /wp-content/debug.log
```

### **2. Performans Sorunları**

```php
// OPcache durumunu kontrol edin
php -m | grep opcache

// Memory kullanımını kontrol edin
php -r "echo 'Memory Limit: ' . ini_get('memory_limit') . PHP_EOL;"
php -r "echo 'Max Execution Time: ' . ini_get('max_execution_time') . PHP_EOL;"
```

### **3. Veritabanı Sorunları**

```sql
-- Slow query log'u kontrol edin
SHOW VARIABLES LIKE 'slow_query_log';
SHOW VARIABLES LIKE 'long_query_time';

-- Index'leri kontrol edin
SHOW INDEX FROM wp_posts;
SHOW INDEX FROM wp_postmeta;
```

## 📈 **Optimizasyon Önerileri**

### **1. Sunucu Optimizasyonları**

```bash
# PHP-FPM ayarları
pm.max_children = 50
pm.start_servers = 5
pm.min_spare_servers = 5
pm.max_spare_servers = 35
pm.max_requests = 1000

# MySQL ayarları
innodb_buffer_pool_size = 256M
innodb_log_file_size = 64M
query_cache_size = 32M
query_cache_limit = 2M
```

### **2. WordPress Optimizasyonları**

```php
// wp-config.php optimizasyonları
define('WP_CACHE', true);
define('COMPRESS_CSS', true);
define('COMPRESS_SCRIPTS', true);
define('ENFORCE_GZIP', true);
define('WP_MEMORY_LIMIT', '256M');
```

### **3. Tema Optimizasyonları**

```php
// Tema özel ayarlar
- Lazy loading aktif
- Minification aktif
- Caching aktif
- CDN kullanımı
- Image optimization
```

## 🎉 **Sonuç**

**Firma Rehberi Pro** teması PHP 8.1.21 sunucunuzda tam uyumlu çalışacak ve en iyi performansı sağlayacaktır. Tema, PHP 8.1'in tüm avantajlarını kullanarak:

- ✅ **Ultra hızlı** yükleme süreleri
- ✅ **SEO optimize** edilmiş yapı
- ✅ **Mobil uyumlu** tasarım
- ✅ **Güvenli** kod yapısı
- ✅ **Ölçeklenebilir** mimari

sağlar.

Herhangi bir sorunla karşılaştığınızda, lütfen destek ekibimizle iletişime geçin.

---

**PHP 8.1 ile Firma Rehberi Pro - Mükemmel Uyum! 🚀**
