<?php
/**
 * The template for displaying the contact page
 *
 * @package FirmaRehberiPro
 */

get_header(); ?>

<main id="main" class="site-main" role="main">
    <div class="container">
        <!-- Breadcrumb -->
        <?php get_template_part('template-parts/breadcrumb'); ?>
        
        <!-- Contact Header -->
        <header class="contact-header">
            <h1 class="contact-title"><?php _e('İletişim', 'firma-rehberi-pro'); ?></h1>
            <p class="contact-description"><?php _e('Bizimle iletişime geçin. Sorularınızı yanıtlamaktan mutluluk duyarız.', 'firma-rehberi-pro'); ?></p>
        </header>

        <div class="contact-content">
            <div class="contact-grid">
                <!-- Contact Form -->
                <div class="contact-form-section">
                    <h2><?php _e('Bize Mesaj Gönderin', 'firma-rehberi-pro'); ?></h2>
                    <form class="contact-form" method="post" action="">
                        <?php wp_nonce_field('contact_form', 'contact_nonce'); ?>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label for="contact_name"><?php _e('Ad Soyad', 'firma-rehberi-pro'); ?> <span class="required">*</span></label>
                                <input type="text" id="contact_name" name="contact_name" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="contact_email"><?php _e('E-posta', 'firma-rehberi-pro'); ?> <span class="required">*</span></label>
                                <input type="email" id="contact_email" name="contact_email" required>
                            </div>
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label for="contact_phone"><?php _e('Telefon', 'firma-rehberi-pro'); ?></label>
                                <input type="tel" id="contact_phone" name="contact_phone">
                            </div>
                            
                            <div class="form-group">
                                <label for="contact_subject"><?php _e('Konu', 'firma-rehberi-pro'); ?> <span class="required">*</span></label>
                                <input type="text" id="contact_subject" name="contact_subject" required>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="contact_message"><?php _e('Mesaj', 'firma-rehberi-pro'); ?> <span class="required">*</span></label>
                            <textarea id="contact_message" name="contact_message" rows="6" required></textarea>
                        </div>
                        
                        <div class="form-group">
                            <button type="submit" class="submit-btn"><?php _e('Mesaj Gönder', 'firma-rehberi-pro'); ?></button>
                        </div>
                    </form>
                </div>

                <!-- Contact Information -->
                <div class="contact-info-section">
                    <h2><?php _e('İletişim Bilgileri', 'firma-rehberi-pro'); ?></h2>
                    
                    <div class="contact-info">
                        <div class="contact-item">
                            <div class="contact-icon">📞</div>
                            <div class="contact-details">
                                <h3><?php _e('Telefon', 'firma-rehberi-pro'); ?></h3>
                                <p><?php echo esc_html(get_theme_mod('header_phone', '+90 (212) 555 0123')); ?></p>
                            </div>
                        </div>
                        
                        <div class="contact-item">
                            <div class="contact-icon">✉️</div>
                            <div class="contact-details">
                                <h3><?php _e('E-posta', 'firma-rehberi-pro'); ?></h3>
                                <p><?php echo esc_html(get_theme_mod('header_email', 'info@firmarehberi.com')); ?></p>
                            </div>
                        </div>
                        
                        <div class="contact-item">
                            <div class="contact-icon">📍</div>
                            <div class="contact-details">
                                <h3><?php _e('Adres', 'firma-rehberi-pro'); ?></h3>
                                <p><?php echo esc_html(get_theme_mod('contact_address', 'İstanbul, Türkiye')); ?></p>
                            </div>
                        </div>
                        
                        <div class="contact-item">
                            <div class="contact-icon">🕒</div>
                            <div class="contact-details">
                                <h3><?php _e('Çalışma Saatleri', 'firma-rehberi-pro'); ?></h3>
                                <p><?php echo esc_html(get_theme_mod('working_hours', 'Pazartesi - Cuma: 09:00 - 18:00')); ?></p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Social Media -->
                    <div class="social-media">
                        <h3><?php _e('Sosyal Medya', 'firma-rehberi-pro'); ?></h3>
                        <div class="social-links">
                            <?php if (get_theme_mod('facebook_url')) : ?>
                                <a href="<?php echo esc_url(get_theme_mod('facebook_url')); ?>" target="_blank" rel="noopener" aria-label="Facebook">📘</a>
                            <?php endif; ?>
                            <?php if (get_theme_mod('twitter_url')) : ?>
                                <a href="<?php echo esc_url(get_theme_mod('twitter_url')); ?>" target="_blank" rel="noopener" aria-label="Twitter">🐦</a>
                            <?php endif; ?>
                            <?php if (get_theme_mod('instagram_url')) : ?>
                                <a href="<?php echo esc_url(get_theme_mod('instagram_url')); ?>" target="_blank" rel="noopener" aria-label="Instagram">📷</a>
                            <?php endif; ?>
                            <?php if (get_theme_mod('linkedin_url')) : ?>
                                <a href="<?php echo esc_url(get_theme_mod('linkedin_url')); ?>" target="_blank" rel="noopener" aria-label="LinkedIn">💼</a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<style>
.contact-header {
    text-align: center;
    padding: 3rem 0;
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
    margin-bottom: 3rem;
    border-radius: 12px;
}

.contact-title {
    font-size: 2.5rem;
    font-weight: 800;
    margin-bottom: 1rem;
    color: #1a1a1a;
}

.contact-description {
    font-size: 1.25rem;
    color: #6b7280;
    max-width: 600px;
    margin: 0 auto;
}

.contact-content {
    margin-bottom: 3rem;
}

.contact-grid {
    display: grid;
    grid-template-columns: 2fr 1fr;
    gap: 3rem;
}

.contact-form-section,
.contact-info-section {
    background: #ffffff;
    padding: 2rem;
    border-radius: 12px;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
    border: 1px solid #e5e7eb;
}

.contact-form-section h2,
.contact-info-section h2 {
    font-size: 1.5rem;
    font-weight: 700;
    margin-bottom: 1.5rem;
    color: #1a1a1a;
    border-bottom: 2px solid #1e40af;
    padding-bottom: 0.5rem;
}

.contact-form {
    display: flex;
    flex-direction: column;
    gap: 1.5rem;
}

.form-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 1rem;
}

.form-group {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.form-group label {
    font-weight: 600;
    color: #374151;
    font-size: 0.875rem;
}

.required {
    color: #e74c3c;
}

.form-group input,
.form-group textarea {
    padding: 0.75rem;
    border: 1px solid #d1d5db;
    border-radius: 6px;
    font-size: 1rem;
    transition: border-color 0.2s ease;
}

.form-group input:focus,
.form-group textarea:focus {
    outline: none;
    border-color: #1e40af;
    box-shadow: 0 0 0 3px rgba(30, 64, 175, 0.1);
}

.submit-btn {
    background: #1e40af;
    color: #ffffff;
    padding: 0.75rem 2rem;
    border: none;
    border-radius: 6px;
    font-weight: 600;
    cursor: pointer;
    transition: background 0.2s ease;
    font-size: 1rem;
}

.submit-btn:hover {
    background: #1d4ed8;
}

.contact-info {
    display: flex;
    flex-direction: column;
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.contact-item {
    display: flex;
    align-items: flex-start;
    gap: 1rem;
}

.contact-icon {
    font-size: 1.5rem;
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: #f8fafc;
    border-radius: 8px;
    flex-shrink: 0;
}

.contact-details h3 {
    font-size: 1rem;
    font-weight: 600;
    margin-bottom: 0.25rem;
    color: #1a1a1a;
}

.contact-details p {
    color: #6b7280;
    margin: 0;
}

.social-media h3 {
    font-size: 1rem;
    font-weight: 600;
    margin-bottom: 1rem;
    color: #1a1a1a;
}

.social-links {
    display: flex;
    gap: 1rem;
}

.social-links a {
    display: inline-block;
    width: 40px;
    height: 40px;
    background: #1e40af;
    color: #ffffff;
    border-radius: 50%;
    text-align: center;
    line-height: 40px;
    text-decoration: none;
    font-size: 1.25rem;
    transition: background 0.2s ease;
}

.social-links a:hover {
    background: #1d4ed8;
    color: #ffffff;
}

@media (max-width: 768px) {
    .contact-grid {
        grid-template-columns: 1fr;
        gap: 2rem;
    }
    
    .form-row {
        grid-template-columns: 1fr;
    }
    
    .contact-title {
        font-size: 2rem;
    }
}
</style>

<?php
// Handle form submission
if (isset($_POST['contact_nonce']) && wp_verify_nonce($_POST['contact_nonce'], 'contact_form')) {
    $name = sanitize_text_field($_POST['contact_name']);
    $email = sanitize_email($_POST['contact_email']);
    $phone = sanitize_text_field($_POST['contact_phone']);
    $subject = sanitize_text_field($_POST['contact_subject']);
    $message = sanitize_textarea_field($_POST['contact_message']);
    
    if ($name && $email && $subject && $message) {
        $to = get_option('admin_email');
        $email_subject = '[' . get_bloginfo('name') . '] ' . $subject;
        $email_message = "Ad Soyad: $name\n";
        $email_message .= "E-posta: $email\n";
        if ($phone) {
            $email_message .= "Telefon: $phone\n";
        }
        $email_message .= "Mesaj:\n$message";
        
        $headers = array(
            'From: ' . $name . ' <' . $email . '>',
            'Reply-To: ' . $email,
        );
        
        if (wp_mail($to, $email_subject, $email_message, $headers)) {
            echo '<div class="notice notice-success"><p>' . __('Mesajınız başarıyla gönderildi. En kısa sürede size dönüş yapacağız.', 'firma-rehberi-pro') . '</p></div>';
        } else {
            echo '<div class="notice notice-error"><p>' . __('Mesaj gönderilirken bir hata oluştu. Lütfen tekrar deneyin.', 'firma-rehberi-pro') . '</p></div>';
        }
    } else {
        echo '<div class="notice notice-error"><p>' . __('Lütfen tüm gerekli alanları doldurun.', 'firma-rehberi-pro') . '</p></div>';
    }
}
?>

<?php get_footer(); ?>
