// SEO Configuration
// Centralized SEO settings for the entire site

export const seoConfig = {
  // Site information
  site: {
    name: 'Dans Dersleri',
    title: 'Dans Dersleri - Türkiye\'nin En Kapsamlı Dans Kursu Rehberi',
    description: 'İstanbul, Ankara, İzmir ve tüm Türkiye\'de salsa, bachata, tango, hip-hop ve daha fazla dans türü için en iyi kursları keşfedin. Profesyonel öğretmenler, uygun fiyatlar, kolay rezervasyon.',
    url: process.env.NEXT_PUBLIC_BASE_URL || 'https://dansdersleri.com',
    logo: '/logo.png',
    ogImage: '/og-image.jpg',
  },

  // Company information
  company: {
    name: 'Dans Dersleri',
    legalName: 'Dans Dersleri A.Ş.',
    email: 'info@dansdersleri.com',
    phone: '+90 212 555 0123',
    address: {
      street: 'Örnek Caddesi No: 123',
      city: 'İstanbul',
      region: 'İstanbul',
      postalCode: '34000',
      country: 'TR',
    },
  },

  // Social media profiles
  social: {
    facebook: 'https://facebook.com/dansdersleri',
    instagram: 'https://instagram.com/dansdersleri',
    twitter: 'https://twitter.com/dansdersleri',
    youtube: 'https://youtube.com/@dansdersleri',
    linkedin: 'https://linkedin.com/company/dansdersleri',
    tiktok: 'https://tiktok.com/@dansdersleri',
  },

  // Default metadata
  defaultMetadata: {
    locale: 'tr_TR',
    type: 'website',
    siteName: 'Dans Dersleri',
    twitterUsername: '@dansdersleri',
    twitterCard: 'summary_large_image',
  },

  // Keywords for different pages
  keywords: {
    home: [
      'dans kursu',
      'dans dersleri',
      'dans okulu',
      'salsa dersi',
      'bachata kursu',
      'tango dersleri',
      'istanbul dans kursu',
      'ankara dans kursu',
      'izmir dans kursu',
      'online dans dersi',
    ],
    cities: [
      'istanbul',
      'ankara',
      'izmir',
      'bursa',
      'antalya',
      'adana',
      'konya',
      'gaziantep',
      'mersin',
      'diyarbakir',
    ],
    danceTypes: [
      'salsa',
      'bachata',
      'tango',
      'hip-hop',
      'klasik bale',
      'modern dans',
      'latin dansları',
      'swing',
      'cha cha',
      'rumba',
      'vals',
      'kizomba',
      'samba',
      'folk dans',
      'halk oyunları',
    ],
  },

  // Analytics & Tracking
  analytics: {
    googleAnalytics: process.env.NEXT_PUBLIC_GA_ID || '',
    googleTagManager: process.env.NEXT_PUBLIC_GTM_ID || '',
    facebookPixel: process.env.NEXT_PUBLIC_FB_PIXEL_ID || '',
    hotjar: process.env.NEXT_PUBLIC_HOTJAR_ID || '',
  },

  // Search Console & Webmaster Tools
  verification: {
    google: process.env.NEXT_PUBLIC_GOOGLE_VERIFICATION || '',
    bing: process.env.NEXT_PUBLIC_BING_VERIFICATION || '',
    yandex: process.env.NEXT_PUBLIC_YANDEX_VERIFICATION || '',
  },

  // JSON-LD Organization Schema
  organizationSchema: {
    '@context': 'https://schema.org',
    '@type': 'Organization',
    '@id': 'https://dansdersleri.com/#organization',
    name: 'Dans Dersleri',
    url: 'https://dansdersleri.com',
    logo: 'https://dansdersleri.com/logo.png',
    description: 'Türkiye\'nin en kapsamlı dans kursu rehberi platformu',
    email: 'info@dansdersleri.com',
    telephone: '+90-212-555-0123',
    address: {
      '@type': 'PostalAddress',
      streetAddress: 'Örnek Caddesi No: 123',
      addressLocality: 'İstanbul',
      postalCode: '34000',
      addressCountry: 'TR',
    },
    sameAs: [
      'https://facebook.com/dansdersleri',
      'https://instagram.com/dansdersleri',
      'https://twitter.com/dansdersleri',
      'https://youtube.com/@dansdersleri',
      'https://linkedin.com/company/dansdersleri',
    ],
  },
}

// Helper function to get full URL
export function getFullUrl(path: string): string {
  const baseUrl = seoConfig.site.url
  const cleanPath = path.startsWith('/') ? path : `/${path}`
  return `${baseUrl}${cleanPath}`
}

// Helper function to get social media URLs
export function getSocialMediaUrls() {
  return Object.values(seoConfig.social).filter(Boolean)
}

// Helper function to get analytics IDs
export function getAnalyticsIds() {
  return seoConfig.analytics
}

// Helper function to get verification codes
export function getVerificationCodes() {
  return seoConfig.verification
}

