# Firma Rehberi Pro WordPress Teması

Modern ve profesyonel firma rehberi, ilan sitesi WordPress teması. Demo siteye benzer özellikler ile kapsamlı bir platform sunar.

## 🚀 Özellikler

### Ana Özellikler
- **Firma Rehberi**: Detaylı firma bilgileri, değerlendirmeler, iletişim bilgileri
- **İlan Sistemi**: Konut, araba, arsa, iş yeri ilanları
- **Haber Sistemi**: KAP haberleri ve güncel içerikler
- **Şehir Bazlı Filtreleme**: İstanbul, Ankara, İzmir ve diğer şehirler
- **Gelişmiş Arama**: Tüm içerik türlerinde arama
- **Responsive Tasarım**: Mobil uyumlu modern tasarım

### Teknik Özellikler
- **Custom Post Types**: Firma, İlan, Haber
- **Custom Taxonomies**: Kategoriler, Şehirler
- **Meta Boxes**: Özel alanlar ve veri yönetimi
- **Widget Sistemi**: Popüler ilanlar, en iyi firmalar, son haberler
- **AJAX Desteği**: Dinamik içerik yükleme
- **SEO Optimized**: Arama motoru dostu yapı

## 📁 Dosya Yapısı

```
wordpress-theme/
├── style.css                 # Ana CSS dosyası
├── index.php                 # Ana sayfa template
├── functions.php             # Tema fonksiyonları
├── header.php               # Header template
├── footer.php               # Footer template
├── search.php               # Arama sayfası
├── single-firma.php         # Firma detay sayfası
├── single-ilan.php          # İlan detay sayfası
├── archive-firma.php        # Firma listesi
├── archive-ilan.php         # İlan listesi
├── js/
│   └── main.js              # JavaScript dosyası
└── widgets/
    ├── popular-listings-widget.php
    ├── best-companies-widget.php
    └── recent-news-widget.php
```

## 🛠️ Kurulum

1. **Tema Dosyalarını Yükleyin**
   - `wordpress-theme` klasörünü WordPress'inizdeki `/wp-content/themes/` dizinine kopyalayın
   - Klasör adını `firma-rehberi-pro` olarak değiştirin

2. **Temayı Aktifleştirin**
   - WordPress admin panelinde **Görünüm > Temalar** bölümüne gidin
   - "Firma Rehberi Pro" temasını aktifleştirin

3. **Gerekli Ayarlar**
   - **Ayarlar > Kalıcı Bağlantılar** bölümünde "Özel Yapı" seçin
   - Kalıcı bağlantı yapısını `/blog/%postname%/` olarak ayarlayın

## 📋 Kullanım

### Firma Ekleme
1. **Firmalar > Yeni Ekle** menüsüne gidin
2. Firma bilgilerini doldurun:
   - Başlık: Firma adı
   - İçerik: Firma açıklaması
   - Öne Çıkan Görsel: Firma logosu
   - Firma Detayları meta kutusu:
     - Telefon
     - E-posta
     - Website
     - Adres
     - Değerlendirme (1-5)

### İlan Ekleme
1. **İlanlar > Yeni Ekle** menüsüne gidin
2. İlan bilgilerini doldurun:
   - Başlık: İlan başlığı
   - İçerik: İlan açıklaması
   - Öne Çıkan Görsel: İlan fotoğrafı
   - İlan Detayları meta kutusu:
     - Fiyat
     - Konum
     - İletişim Telefonu
     - İletişim E-postası

### Widget Kullanımı
1. **Görünüm > Widget'lar** bölümüne gidin
2. Mevcut widget'ları sidebar alanlarına sürükleyin:
   - **Popüler İlanlar**: En çok görüntülenen ilanlar
   - **En İyi Firmalar**: En yüksek puanlı firmalar
   - **Son Haberler**: En son yayınlanan haberler

## 🎨 Özelleştirme

### Renk Değişiklikleri
Ana renkleri değiştirmek için `style.css` dosyasındaki renk kodlarını düzenleyin:
- Ana renk: `#e74c3c` (kırmızı)
- İkincil renk: `#2c3e50` (koyu mavi)
- Arka plan: `#f8f9fa` (açık gri)

### Logo Ekleme
1. **Görünüm > Özelleştir > Site Kimliği** bölümüne gidin
2. Logo yükleyin ve ayarlayın

### Menü Ayarları
1. **Görünüm > Menüler** bölümüne gidin
2. Ana menüyü oluşturun ve düzenleyin

## 📱 Responsive Tasarım

Tema tüm cihazlarda mükemmel görünüm sağlar:
- **Desktop**: 1200px+ genişlik
- **Tablet**: 768px - 1199px genişlik
- **Mobile**: 767px ve altı genişlik

## 🔧 Gelişmiş Özellikler

### AJAX Filtreleme
- Firma ve ilan listelerinde dinamik filtreleme
- Sayfa yenilenmeden sonuç güncelleme

### Görüntülenme Sayacı
- Her firma ve ilan için otomatik görüntülenme sayacı
- Popüler içerik belirleme

### SEO Optimizasyonu
- Yapılandırılmış veri desteği
- Meta tag optimizasyonu
- Hızlı yükleme süreleri

## 🐛 Sorun Giderme

### Yaygın Sorunlar
1. **Tema görünmüyor**: Dosya izinlerini kontrol edin
2. **Widget'lar çalışmıyor**: Tema dosyalarının tam yüklendiğinden emin olun
3. **Arama çalışmıyor**: Kalıcı bağlantı ayarlarını kontrol edin

### Destek
Herhangi bir sorun yaşarsanız:
1. WordPress hata loglarını kontrol edin
2. Tema dosyalarının bütünlüğünü doğrulayın
3. Plugin çakışmalarını kontrol edin

## 📄 Lisans

Bu tema MIT lisansı altında lisanslanmıştır. Ticari ve kişisel projelerde kullanabilirsiniz.

## 🔄 Güncellemeler

### v1.0.0
- İlk sürüm yayınlandı
- Temel tema özellikleri eklendi
- Demo site benzeri tasarım tamamlandı

---

**Not**: Bu tema demo siteye benzer özellikler sunar ancak tamamen özgün kodlarla geliştirilmiştir.
