<?php get_header(); ?>

<main class="main-content">
    <div class="container">
        <div class="archive-header">
            <h1 class="archive-title">Firma Rehberi</h1>
            <p class="archive-description">Güvenilir işletmeleri keşfedin ve size en yakın hizmetleri bulun</p>
        </div>
        
        <!-- Filtreler -->
        <div class="filters-section">
            <div class="filters">
                <div class="filter-group">
                    <label>Kategori:</label>
                    <select id="category-filter">
                        <option value="">Tüm Kategoriler</option>
                        <?php
                        $categories = get_terms(array(
                            'taxonomy' => 'firma_kategori',
                            'hide_empty' => false,
                        ));
                        foreach ($categories as $category) :
                        ?>
                            <option value="<?php echo $category->slug; ?>"><?php echo $category->name; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="filter-group">
                    <label>Şehir:</label>
                    <select id="city-filter">
                        <option value="">Tüm Şehirler</option>
                        <?php
                        $cities = get_terms(array(
                            'taxonomy' => 'sehir',
                            'hide_empty' => false,
                        ));
                        foreach ($cities as $city) :
                        ?>
                            <option value="<?php echo $city->slug; ?>"><?php echo $city->name; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="filter-group">
                    <label>Değerlendirme:</label>
                    <select id="rating-filter">
                        <option value="">Tüm Değerlendirmeler</option>
                        <option value="5">5 Yıldız</option>
                        <option value="4">4+ Yıldız</option>
                        <option value="3">3+ Yıldız</option>
                    </select>
                </div>
            </div>
        </div>
        
        <!-- Firma Listesi -->
        <div class="firmas-grid">
            <?php if (have_posts()) : ?>
                <?php while (have_posts()) : the_post(); ?>
                    <div class="firma-card">
                        <div class="firma-image">
                            <?php if (has_post_thumbnail()) : ?>
                                <?php the_post_thumbnail('medium'); ?>
                            <?php else : ?>
                                <div class="no-image">🏢</div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="firma-content">
                            <h2 class="firma-title">
                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                            </h2>
                            
                            <div class="firma-meta">
                                <?php if (get_post_meta(get_the_ID(), 'rating', true)) : ?>
                                    <div class="rating">
                                        <?php 
                                        $rating = get_post_meta(get_the_ID(), 'rating', true);
                                        for ($i = 1; $i <= 5; $i++) {
                                            echo $i <= $rating ? '⭐' : '☆';
                                        }
                                        ?>
                                        <span>(<?php echo $rating; ?>/5)</span>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if (get_post_meta(get_the_ID(), 'phone', true)) : ?>
                                    <div class="contact-info">
                                        <span>📞 <?php echo get_post_meta(get_the_ID(), 'phone', true); ?></span>
                                    </div>
                                <?php endif; ?>
                                
                                <div class="firma-categories">
                                    <?php
                                    $categories = get_the_terms(get_the_ID(), 'firma_kategori');
                                    if ($categories && !is_wp_error($categories)) :
                                        foreach ($categories as $category) :
                                    ?>
                                        <span class="category-tag"><?php echo $category->name; ?></span>
                                    <?php 
                                        endforeach;
                                    endif;
                                    ?>
                                </div>
                                
                                <div class="firma-location">
                                    <?php
                                    $cities = get_the_terms(get_the_ID(), 'sehir');
                                    if ($cities && !is_wp_error($cities)) :
                                        foreach ($cities as $city) :
                                    ?>
                                        <span class="location-tag"><?php echo $city->name; ?></span>
                                    <?php 
                                        endforeach;
                                    endif;
                                    ?>
                                </div>
                            </div>
                            
                            <div class="firma-excerpt">
                                <?php echo wp_trim_words(get_the_excerpt(), 20); ?>
                            </div>
                            
                            <a href="<?php the_permalink(); ?>" class="view-firma-btn">Detayları Gör</a>
                        </div>
                    </div>
                <?php endwhile; ?>
            <?php else : ?>
                <div class="no-firmas">
                    <h2>Firma bulunamadı</h2>
                    <p>Aradığınız kriterlere uygun firma bulunamadı. Lütfen filtreleri değiştirerek tekrar deneyin.</p>
                </div>
            <?php endif; ?>
        </div>
        
        <!-- Pagination -->
        <div class="pagination">
            <?php
            echo paginate_links(array(
                'prev_text' => '← Önceki',
                'next_text' => 'Sonraki →',
                'mid_size' => 2,
            ));
            ?>
        </div>
    </div>
</main>

<style>
.archive-header {
    text-align: center;
    margin: 40px 0 60px 0;
}

.archive-title {
    font-size: 48px;
    font-weight: 700;
    color: #2c3e50;
    margin-bottom: 20px;
}

.archive-description {
    font-size: 20px;
    color: #666;
}

.filters-section {
    background: white;
    padding: 30px;
    border-radius: 15px;
    box-shadow: 0 3px 15px rgba(0,0,0,0.1);
    margin-bottom: 40px;
}

.filters {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    align-items: end;
}

.filter-group {
    display: flex;
    flex-direction: column;
}

.filter-group label {
    font-weight: 600;
    margin-bottom: 8px;
    color: #2c3e50;
}

.filter-group select {
    padding: 12px;
    border: 2px solid #e0e0e0;
    border-radius: 8px;
    font-size: 16px;
    background: white;
}

.firmas-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
    gap: 30px;
    margin-bottom: 60px;
}

.firma-card {
    background: white;
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    transition: transform 0.3s, box-shadow 0.3s;
}

.firma-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 40px rgba(0,0,0,0.15);
}

.firma-image {
    height: 200px;
    overflow: hidden;
}

.firma-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.no-image {
    width: 100%;
    height: 100%;
    background: #f8f9fa;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 48px;
}

.firma-content {
    padding: 25px;
}

.firma-title {
    font-size: 24px;
    font-weight: 600;
    margin-bottom: 15px;
}

.firma-title a {
    color: #2c3e50;
    text-decoration: none;
}

.firma-title a:hover {
    color: #e74c3c;
}

.firma-meta {
    margin-bottom: 15px;
}

.rating {
    font-size: 16px;
    margin-bottom: 10px;
}

.contact-info {
    font-size: 14px;
    color: #666;
    margin-bottom: 10px;
}

.category-tag, .location-tag {
    display: inline-block;
    background: #e74c3c;
    color: white;
    padding: 4px 12px;
    border-radius: 15px;
    margin: 2px 5px 2px 0;
    font-size: 12px;
    font-weight: 500;
}

.firma-excerpt {
    color: #666;
    line-height: 1.6;
    margin-bottom: 20px;
}

.view-firma-btn {
    display: inline-block;
    background: #e74c3c;
    color: white;
    padding: 12px 25px;
    border-radius: 25px;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s;
}

.view-firma-btn:hover {
    background: #c0392b;
    transform: translateY(-2px);
}

.no-firmas {
    text-align: center;
    padding: 60px 20px;
    color: #666;
}

.pagination {
    text-align: center;
    margin-top: 40px;
}

.pagination a, .pagination span {
    display: inline-block;
    padding: 10px 15px;
    margin: 0 5px;
    background: white;
    color: #2c3e50;
    text-decoration: none;
    border-radius: 5px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    transition: all 0.3s;
}

.pagination a:hover, .pagination .current {
    background: #e74c3c;
    color: white;
}

@media (max-width: 768px) {
    .filters {
        grid-template-columns: 1fr;
    }
    
    .firmas-grid {
        grid-template-columns: 1fr;
    }
    
    .archive-title {
        font-size: 36px;
    }
}
</style>

<script>
// Filtreleme JavaScript'i
document.addEventListener('DOMContentLoaded', function() {
    const categoryFilter = document.getElementById('category-filter');
    const cityFilter = document.getElementById('city-filter');
    const ratingFilter = document.getElementById('rating-filter');
    
    function applyFilters() {
        const url = new URL(window.location);
        
        if (categoryFilter.value) {
            url.searchParams.set('firma_kategori', categoryFilter.value);
        } else {
            url.searchParams.delete('firma_kategori');
        }
        
        if (cityFilter.value) {
            url.searchParams.set('sehir', cityFilter.value);
        } else {
            url.searchParams.delete('sehir');
        }
        
        if (ratingFilter.value) {
            url.searchParams.set('rating', ratingFilter.value);
        } else {
            url.searchParams.delete('rating');
        }
        
        window.location.href = url.toString();
    }
    
    categoryFilter.addEventListener('change', applyFilters);
    cityFilter.addEventListener('change', applyFilters);
    ratingFilter.addEventListener('change', applyFilters);
});
</script>

<?php get_footer(); ?>
