<?php get_header(); ?>

<main class="main-content">
    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <h1 class="hero-title">Güvenilir İşletmeleri Keşfedin</h1>
            <p class="hero-subtitle">Size en yakın hizmetleri, yorumları ve iletişim bilgileriyle hemen bulun</p>
            <div class="hero-buttons">
                <a href="#firma-rehberi" class="btn btn-primary">Firma Rehberi</a>
                <a href="#ilanlar" class="btn btn-secondary">İlanları İncele</a>
            </div>
        </div>
    </section>

    <!-- Main Services Cards -->
    <section class="main-content">
        <div class="container">
            <div class="cards-grid">
                <div class="card">
                    <div class="card-icon">🏢</div>
                    <h3 class="card-title">Firma Rehberi</h3>
                    <p class="card-description">Güvenilir işletmeleri kolayca keşfedin. Size en yakın hizmetleri, yorumları ve iletişim bilgileriyle hemen bulun.</p>
                    <a href="<?php echo get_post_type_archive_link('firma'); ?>" class="btn btn-primary">Göz At</a>
                </div>
                
                <div class="card">
                    <div class="card-icon">🏠</div>
                    <h3 class="card-title">Konut İlanları</h3>
                    <p class="card-description">Hayalinizdeki evi burada arayın. Satılık ve kiralık konut ilanlarını detaylı filtrelerle kolayca inceleyin.</p>
                    <a href="<?php echo get_post_type_archive_link('ilan'); ?>?kategori=konut" class="btn btn-primary">Göz At</a>
                </div>
                
                <div class="card">
                    <div class="card-icon">🚗</div>
                    <h3 class="card-title">Araba İlanları</h3>
                    <p class="card-description">Aradığınız araç bir tık uzağınızda. İkinci el ve sıfır araç ilanlarını karşılaştırın, en uygun fırsatları yakalayın.</p>
                    <a href="<?php echo get_post_type_archive_link('ilan'); ?>?kategori=araba" class="btn btn-primary">Göz At</a>
                </div>
            </div>
        </div>
    </section>

    <!-- Cities Section -->
    <section class="cities-section">
        <div class="container">
            <h2 class="section-title">Popüler Şehirler</h2>
            <div class="cities-grid">
                <?php
                $cities = array(
                    'İstanbul' => '100K İlan',
                    'Ankara' => '100K İlan', 
                    'Antalya' => '100K İlan',
                    'İzmir' => '100K İlan',
                    'Balıkesir' => '100K İlan',
                    'Kıbrıs' => '100K İlan'
                );
                
                foreach($cities as $city => $count): ?>
                    <div class="city-card">
                        <div class="city-name"><?php echo $city; ?></div>
                        <div class="city-count"><?php echo $count; ?></div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- Premium Companies -->
    <section class="premium-companies">
        <div class="container">
            <h2 class="section-title">Premium Firmalar</h2>
            <div class="companies-grid">
                <?php
                $premium_companies = array('Tiktok', 'Spixer', 'Kanews', 'Cargomatic', 'Facebook', 'Google');
                foreach($premium_companies as $company): ?>
                    <div class="company-logo">
                        <strong><?php echo $company; ?></strong>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- News and Content Section -->
    <section class="news-section">
        <div class="container">
            <div class="news-grid">
                <div class="news-main">
                    <h2 class="section-title">KAP Haberleri</h2>
                    <?php
                    $news_query = new WP_Query(array(
                        'post_type' => 'post',
                        'posts_per_page' => 6,
                        'category_name' => 'haberler'
                    ));
                    
                    if($news_query->have_posts()):
                        while($news_query->have_posts()): $news_query->the_post(); ?>
                            <article class="news-item">
                                <div class="news-content">
                                    <span class="news-category"><?php echo get_the_category()[0]->name; ?></span>
                                    <h3 class="news-title">
                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                    </h3>
                                    <p class="news-excerpt"><?php echo wp_trim_words(get_the_excerpt(), 20); ?></p>
                                </div>
                            </article>
                        <?php endwhile;
                        wp_reset_postdata();
                    endif; ?>
                </div>
                
                <aside class="sidebar">
                    <!-- Popular Listings Widget -->
                    <div class="widget">
                        <h3 class="widget-title">Popüler İlanlar</h3>
                        <?php
                        $popular_listings = new WP_Query(array(
                            'post_type' => 'ilan',
                            'posts_per_page' => 5,
                            'meta_key' => 'views_count',
                            'orderby' => 'meta_value_num',
                            'order' => 'DESC'
                        ));
                        
                        if($popular_listings->have_posts()):
                            while($popular_listings->have_posts()): $popular_listings->the_post(); ?>
                                <div class="listing-item">
                                    <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                    <p><?php echo get_post_meta(get_the_ID(), 'location', true); ?></p>
                                </div>
                            <?php endwhile;
                            wp_reset_postdata();
                        endif; ?>
                    </div>
                    
                    <!-- Best Companies Widget -->
                    <div class="widget">
                        <h3 class="widget-title">En İyi Firmalar</h3>
                        <?php
                        $best_companies = new WP_Query(array(
                            'post_type' => 'firma',
                            'posts_per_page' => 5,
                            'meta_key' => 'rating',
                            'orderby' => 'meta_value_num',
                            'order' => 'DESC'
                        ));
                        
                        if($best_companies->have_posts()):
                            $counter = 1;
                            while($best_companies->have_posts()): $best_companies->the_post(); ?>
                                <div class="company-item">
                                    <span class="rank"><?php echo $counter; ?></span>
                                    <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                </div>
                            <?php 
                            $counter++;
                            endwhile;
                            wp_reset_postdata();
                        endif; ?>
                    </div>
                </aside>
            </div>
        </div>
    </section>
</main>

<?php get_footer(); ?>
