<?php get_header(); ?>

<main class="main-content">
    <div class="container">
        <?php while (have_posts()) : the_post(); ?>
            <article class="firma-detail">
                <div class="firma-header">
                    <div class="firma-info">
                        <h1 class="firma-title"><?php the_title(); ?></h1>
                        <div class="firma-meta">
                            <?php if (get_post_meta(get_the_ID(), 'rating', true)) : ?>
                                <div class="rating">
                                    <span>Değerlendirme: </span>
                                    <?php 
                                    $rating = get_post_meta(get_the_ID(), 'rating', true);
                                    for ($i = 1; $i <= 5; $i++) {
                                        echo $i <= $rating ? '⭐' : '☆';
                                    }
                                    ?>
                                    <span>(<?php echo $rating; ?>/5)</span>
                                </div>
                            <?php endif; ?>
                            
                            <?php if (get_post_meta(get_the_ID(), 'phone', true)) : ?>
                                <div class="contact-info">
                                    <span>📞 <?php echo get_post_meta(get_the_ID(), 'phone', true); ?></span>
                                </div>
                            <?php endif; ?>
                            
                            <?php if (get_post_meta(get_the_ID(), 'email', true)) : ?>
                                <div class="contact-info">
                                    <span>✉️ <?php echo get_post_meta(get_the_ID(), 'email', true); ?></span>
                                </div>
                            <?php endif; ?>
                            
                            <?php if (get_post_meta(get_the_ID(), 'website', true)) : ?>
                                <div class="contact-info">
                                    <span>🌐 <a href="<?php echo get_post_meta(get_the_ID(), 'website', true); ?>" target="_blank">Website</a></span>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <?php if (has_post_thumbnail()) : ?>
                        <div class="firma-image">
                            <?php the_post_thumbnail('large'); ?>
                        </div>
                    <?php endif; ?>
                </div>
                
                <div class="firma-content">
                    <div class="firma-description">
                        <h2>Hakkında</h2>
                        <?php the_content(); ?>
                    </div>
                    
                    <?php if (get_post_meta(get_the_ID(), 'address', true)) : ?>
                        <div class="firma-address">
                            <h2>Adres</h2>
                            <p>📍 <?php echo get_post_meta(get_the_ID(), 'address', true); ?></p>
                        </div>
                    <?php endif; ?>
                    
                    <div class="firma-categories">
                        <h2>Kategoriler</h2>
                        <?php
                        $categories = get_the_terms(get_the_ID(), 'firma_kategori');
                        if ($categories && !is_wp_error($categories)) :
                            foreach ($categories as $category) :
                        ?>
                            <span class="category-tag"><?php echo $category->name; ?></span>
                        <?php 
                            endforeach;
                        endif;
                        ?>
                    </div>
                    
                    <div class="firma-location">
                        <h2>Konum</h2>
                        <?php
                        $cities = get_the_terms(get_the_ID(), 'sehir');
                        if ($cities && !is_wp_error($cities)) :
                            foreach ($cities as $city) :
                        ?>
                            <span class="location-tag"><?php echo $city->name; ?></span>
                        <?php 
                            endforeach;
                        endif;
                        ?>
                    </div>
                </div>
            </article>
        <?php endwhile; ?>
    </div>
</main>

<style>
.firma-detail {
    background: white;
    border-radius: 15px;
    padding: 40px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    margin: 40px 0;
}

.firma-header {
    display: grid;
    grid-template-columns: 2fr 1fr;
    gap: 40px;
    margin-bottom: 40px;
    align-items: start;
}

.firma-title {
    font-size: 36px;
    font-weight: 700;
    color: #2c3e50;
    margin-bottom: 20px;
}

.firma-meta {
    display: grid;
    gap: 15px;
}

.rating {
    font-size: 18px;
    font-weight: 600;
}

.contact-info {
    font-size: 16px;
    color: #666;
}

.contact-info a {
    color: #e74c3c;
    text-decoration: none;
}

.firma-image img {
    width: 100%;
    height: 300px;
    object-fit: cover;
    border-radius: 10px;
}

.firma-content h2 {
    font-size: 24px;
    font-weight: 600;
    color: #2c3e50;
    margin: 30px 0 15px 0;
    border-bottom: 2px solid #e74c3c;
    padding-bottom: 10px;
}

.category-tag, .location-tag {
    display: inline-block;
    background: #e74c3c;
    color: white;
    padding: 8px 16px;
    border-radius: 20px;
    margin: 5px 10px 5px 0;
    font-size: 14px;
    font-weight: 500;
}

@media (max-width: 768px) {
    .firma-header {
        grid-template-columns: 1fr;
    }
    
    .firma-detail {
        padding: 20px;
    }
}
</style>

<?php get_footer(); ?>
