<?php get_header(); ?>

<main class="main-content">
    <div class="container">
        <?php while (have_posts()) : the_post(); ?>
            <article class="ilan-detail">
                <div class="ilan-header">
                    <div class="ilan-info">
                        <h1 class="ilan-title"><?php the_title(); ?></h1>
                        <div class="ilan-meta">
                            <?php if (get_post_meta(get_the_ID(), 'price', true)) : ?>
                                <div class="price">
                                    <span class="price-label">Fiyat: </span>
                                    <span class="price-value"><?php echo get_post_meta(get_the_ID(), 'price', true); ?></span>
                                </div>
                            <?php endif; ?>
                            
                            <?php if (get_post_meta(get_the_ID(), 'location', true)) : ?>
                                <div class="location">
                                    <span>📍 <?php echo get_post_meta(get_the_ID(), 'location', true); ?></span>
                                </div>
                            <?php endif; ?>
                            
                            <div class="ilan-date">
                                <span>📅 <?php echo get_the_date(); ?></span>
                            </div>
                            
                            <div class="views-count">
                                <span>👁️ <?php echo get_post_meta(get_the_ID(), 'views_count', true) ?: 0; ?> görüntülenme</span>
                            </div>
                        </div>
                    </div>
                    
                    <?php if (has_post_thumbnail()) : ?>
                        <div class="ilan-image">
                            <?php the_post_thumbnail('large'); ?>
                        </div>
                    <?php endif; ?>
                </div>
                
                <div class="ilan-content">
                    <div class="ilan-description">
                        <h2>Detaylar</h2>
                        <?php the_content(); ?>
                    </div>
                    
                    <div class="ilan-categories">
                        <h2>Kategoriler</h2>
                        <?php
                        $categories = get_the_terms(get_the_ID(), 'ilan_kategori');
                        if ($categories && !is_wp_error($categories)) :
                            foreach ($categories as $category) :
                        ?>
                            <span class="category-tag"><?php echo $category->name; ?></span>
                        <?php 
                            endforeach;
                        endif;
                        ?>
                    </div>
                    
                    <div class="ilan-location">
                        <h2>Konum</h2>
                        <?php
                        $cities = get_the_terms(get_the_ID(), 'sehir');
                        if ($cities && !is_wp_error($cities)) :
                            foreach ($cities as $city) :
                        ?>
                            <span class="location-tag"><?php echo $city->name; ?></span>
                        <?php 
                            endforeach;
                        endif;
                        ?>
                    </div>
                    
                    <div class="contact-section">
                        <h2>İletişim</h2>
                        <div class="contact-buttons">
                            <?php if (get_post_meta(get_the_ID(), 'contact_phone', true)) : ?>
                                <a href="tel:<?php echo get_post_meta(get_the_ID(), 'contact_phone', true); ?>" class="contact-btn phone-btn">
                                    📞 <?php echo get_post_meta(get_the_ID(), 'contact_phone', true); ?>
                                </a>
                            <?php endif; ?>
                            
                            <?php if (get_post_meta(get_the_ID(), 'contact_email', true)) : ?>
                                <a href="mailto:<?php echo get_post_meta(get_the_ID(), 'contact_email', true); ?>" class="contact-btn email-btn">
                                    ✉️ E-posta Gönder
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </article>
        <?php endwhile; ?>
    </div>
</main>

<style>
.ilan-detail {
    background: white;
    border-radius: 15px;
    padding: 40px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    margin: 40px 0;
}

.ilan-header {
    display: grid;
    grid-template-columns: 2fr 1fr;
    gap: 40px;
    margin-bottom: 40px;
    align-items: start;
}

.ilan-title {
    font-size: 36px;
    font-weight: 700;
    color: #2c3e50;
    margin-bottom: 20px;
}

.ilan-meta {
    display: grid;
    gap: 15px;
}

.price {
    font-size: 24px;
    font-weight: 700;
    color: #e74c3c;
}

.price-label {
    font-size: 18px;
    color: #666;
}

.location, .ilan-date, .views-count {
    font-size: 16px;
    color: #666;
}

.ilan-image img {
    width: 100%;
    height: 300px;
    object-fit: cover;
    border-radius: 10px;
}

.ilan-content h2 {
    font-size: 24px;
    font-weight: 600;
    color: #2c3e50;
    margin: 30px 0 15px 0;
    border-bottom: 2px solid #e74c3c;
    padding-bottom: 10px;
}

.category-tag, .location-tag {
    display: inline-block;
    background: #e74c3c;
    color: white;
    padding: 8px 16px;
    border-radius: 20px;
    margin: 5px 10px 5px 0;
    font-size: 14px;
    font-weight: 500;
}

.contact-buttons {
    display: flex;
    gap: 20px;
    flex-wrap: wrap;
}

.contact-btn {
    display: inline-block;
    padding: 15px 30px;
    border-radius: 50px;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s;
    border: 2px solid transparent;
}

.phone-btn {
    background: #27ae60;
    color: white;
}

.phone-btn:hover {
    background: #219a52;
    transform: translateY(-2px);
}

.email-btn {
    background: #3498db;
    color: white;
}

.email-btn:hover {
    background: #2980b9;
    transform: translateY(-2px);
}

@media (max-width: 768px) {
    .ilan-header {
        grid-template-columns: 1fr;
    }
    
    .ilan-detail {
        padding: 20px;
    }
    
    .contact-buttons {
        flex-direction: column;
    }
}
</style>

<?php get_footer(); ?>
