<?php
/**
 * Popular Listings Widget
 */

class Popular_Listings_Widget extends WP_Widget {
    
    public function __construct() {
        parent::__construct(
            'popular_listings_widget',
            'Popüler İlanlar',
            array('description' => 'En çok görüntülenen ilanları gösterir')
        );
    }
    
    public function widget($args, $instance) {
        $title = apply_filters('widget_title', $instance['title']);
        $number = !empty($instance['number']) ? absint($instance['number']) : 5;
        
        echo $args['before_widget'];
        
        if (!empty($title)) {
            echo $args['before_title'] . $title . $args['after_title'];
        }
        
        $query = new WP_Query(array(
            'post_type' => 'ilan',
            'posts_per_page' => $number,
            'meta_key' => 'views_count',
            'orderby' => 'meta_value_num',
            'order' => 'DESC'
        ));
        
        if ($query->have_posts()) :
            echo '<div class="popular-listings">';
            while ($query->have_posts()) : $query->the_post();
                $price = get_post_meta(get_the_ID(), 'price', true);
                $location = get_post_meta(get_the_ID(), 'location', true);
                $views = get_post_meta(get_the_ID(), 'views_count', true) ?: 0;
                ?>
                <div class="listing-item">
                    <div class="listing-image">
                        <?php if (has_post_thumbnail()) : ?>
                            <?php the_post_thumbnail('thumbnail'); ?>
                        <?php else : ?>
                            <div class="no-image">📋</div>
                        <?php endif; ?>
                    </div>
                    <div class="listing-content">
                        <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                        <?php if ($price) : ?>
                            <div class="listing-price"><?php echo $price; ?></div>
                        <?php endif; ?>
                        <?php if ($location) : ?>
                            <div class="listing-location">📍 <?php echo $location; ?></div>
                        <?php endif; ?>
                        <div class="listing-views">👁️ <?php echo $views; ?></div>
                    </div>
                </div>
                <?php
            endwhile;
            echo '</div>';
            wp_reset_postdata();
        else :
            echo '<p>Henüz ilan bulunmuyor.</p>';
        endif;
        
        echo $args['after_widget'];
    }
    
    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : 'Popüler İlanlar';
        $number = !empty($instance['number']) ? $instance['number'] : 5;
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">Başlık:</label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('number'); ?>">Gösterilecek İlan Sayısı:</label>
            <input class="tiny-text" id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="number" step="1" min="1" value="<?php echo esc_attr($number); ?>" size="3">
        </p>
        <?php
    }
    
    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        $instance['number'] = (!empty($new_instance['number'])) ? absint($new_instance['number']) : 5;
        return $instance;
    }
}

// Register the widget
function register_popular_listings_widget() {
    register_widget('Popular_Listings_Widget');
}
add_action('widgets_init', 'register_popular_listings_widget');
?>
