<?php
/**
 * Recent News Widget
 */

class Recent_News_Widget extends WP_Widget {
    
    public function __construct() {
        parent::__construct(
            'recent_news_widget',
            'Son Haberler',
            array('description' => 'En son haberleri gösterir')
        );
    }
    
    public function widget($args, $instance) {
        $title = apply_filters('widget_title', $instance['title']);
        $number = !empty($instance['number']) ? absint($instance['number']) : 5;
        $show_excerpt = !empty($instance['show_excerpt']) ? $instance['show_excerpt'] : false;
        
        echo $args['before_widget'];
        
        if (!empty($title)) {
            echo $args['before_title'] . $title . $args['after_title'];
        }
        
        $query = new WP_Query(array(
            'post_type' => 'post',
            'posts_per_page' => $number,
            'post_status' => 'publish'
        ));
        
        if ($query->have_posts()) :
            echo '<div class="recent-news">';
            while ($query->have_posts()) : $query->the_post();
                $categories = get_the_category();
                $category_name = !empty($categories) ? $categories[0]->name : '';
                ?>
                <div class="news-item">
                    <div class="news-image">
                        <?php if (has_post_thumbnail()) : ?>
                            <?php the_post_thumbnail('thumbnail'); ?>
                        <?php else : ?>
                            <div class="no-image">📰</div>
                        <?php endif; ?>
                    </div>
                    <div class="news-content">
                        <?php if ($category_name) : ?>
                            <div class="news-category"><?php echo $category_name; ?></div>
                        <?php endif; ?>
                        <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                        <div class="news-date">📅 <?php echo get_the_date(); ?></div>
                        <?php if ($show_excerpt) : ?>
                            <div class="news-excerpt"><?php echo wp_trim_words(get_the_excerpt(), 15); ?></div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php
            endwhile;
            echo '</div>';
            wp_reset_postdata();
        else :
            echo '<p>Henüz haber bulunmuyor.</p>';
        endif;
        
        echo $args['after_widget'];
    }
    
    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : 'Son Haberler';
        $number = !empty($instance['number']) ? $instance['number'] : 5;
        $show_excerpt = !empty($instance['show_excerpt']) ? $instance['show_excerpt'] : false;
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">Başlık:</label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('number'); ?>">Gösterilecek Haber Sayısı:</label>
            <input class="tiny-text" id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="number" step="1" min="1" value="<?php echo esc_attr($number); ?>" size="3">
        </p>
        <p>
            <input class="checkbox" type="checkbox" <?php checked($show_excerpt); ?> id="<?php echo $this->get_field_id('show_excerpt'); ?>" name="<?php echo $this->get_field_name('show_excerpt'); ?>" />
            <label for="<?php echo $this->get_field_id('show_excerpt'); ?>">Özet göster</label>
        </p>
        <?php
    }
    
    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        $instance['number'] = (!empty($new_instance['number'])) ? absint($new_instance['number']) : 5;
        $instance['show_excerpt'] = !empty($new_instance['show_excerpt']) ? true : false;
        return $instance;
    }
}

// Register the widget
function register_recent_news_widget() {
    register_widget('Recent_News_Widget');
}
add_action('widgets_init', 'register_recent_news_widget');
?>
