<?php
/**
 * The template for displaying single company posts
 *
 * @package FirmaRehberiPro
 */

get_header(); ?>

<main id="main" class="site-main" role="main">
    <?php while (have_posts()) : the_post(); ?>
        <article id="post-<?php the_ID(); ?>" <?php post_class('company-single'); ?>>
            <!-- Company Header -->
            <header class="company-header">
                <div class="container">
                    <div class="company-info">
                        <div class="company-logo-container">
                            <?php if (has_post_thumbnail()) : ?>
                                <?php the_post_thumbnail('company-logo-large', array('class' => 'company-logo-large')); ?>
                            <?php else : ?>
                                <div class="company-logo-placeholder">
                                    <span class="logo-text"><?php echo substr(get_the_title(), 0, 2); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="company-details">
                            <h1 class="company-title"><?php the_title(); ?></h1>
                            
                            <?php
                            $rating = get_post_meta(get_the_ID(), '_rating', true);
                            if ($rating) :
                            ?>
                                <div class="company-rating">
                                    <div class="stars">
                                        <?php for ($i = 1; $i <= 5; $i++) : ?>
                                            <span class="star <?php echo $i <= $rating ? 'filled' : ''; ?>">★</span>
                                        <?php endfor; ?>
                                    </div>
                                    <span class="rating-text"><?php echo esc_html($rating); ?>/5 (<?php echo esc_html(get_post_meta(get_the_ID(), '_review_count', true) ?: 0); ?> değerlendirme)</span>
                                </div>
                            <?php endif; ?>
                            
                            <div class="company-categories">
                                <?php
                                $categories = get_the_terms(get_the_ID(), 'company_category');
                                if ($categories && !is_wp_error($categories)) :
                                    foreach ($categories as $category) :
                                ?>
                                    <span class="category-tag"><?php echo esc_html($category->name); ?></span>
                                <?php 
                                    endforeach;
                                endif;
                                ?>
                            </div>
                            
                            <div class="company-location">
                                <?php
                                $cities = get_the_terms(get_the_ID(), 'company_city');
                                if ($cities && !is_wp_error($cities)) :
                                    foreach ($cities as $city) :
                                ?>
                                    <span class="location-tag">📍 <?php echo esc_html($city->name); ?></span>
                                <?php 
                                    endforeach;
                                endif;
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Company Content -->
            <div class="company-content">
                <div class="container">
                    <div class="content-grid">
                        <div class="main-content">
                            <!-- Company Description -->
                            <section class="company-description">
                                <h2><?php _e('Hakkında', 'firma-rehberi-pro'); ?></h2>
                                <div class="description-content">
                                    <?php the_content(); ?>
                                </div>
                            </section>

                            <!-- Company Services -->
                            <?php
                            $services = get_post_meta(get_the_ID(), '_services', true);
                            if ($services) :
                            ?>
                                <section class="company-services">
                                    <h2><?php _e('Hizmetler', 'firma-rehberi-pro'); ?></h2>
                                    <ul class="services-list">
                                        <?php foreach (explode("\n", $services) as $service) : ?>
                                            <?php if (trim($service)) : ?>
                                                <li><?php echo esc_html(trim($service)); ?></li>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </ul>
                                </section>
                            <?php endif; ?>

                            <!-- Company Gallery -->
                            <?php
                            $gallery = get_post_meta(get_the_ID(), '_gallery', true);
                            if ($gallery) :
                                $gallery_ids = explode(',', $gallery);
                            ?>
                                <section class="company-gallery">
                                    <h2><?php _e('Galeri', 'firma-rehberi-pro'); ?></h2>
                                    <div class="gallery-grid">
                                        <?php foreach ($gallery_ids as $image_id) : ?>
                                            <?php if ($image_id) : ?>
                                                <div class="gallery-item">
                                                    <?php echo wp_get_attachment_image($image_id, 'medium', false, array('class' => 'gallery-image')); ?>
                                                </div>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </div>
                                </section>
                            <?php endif; ?>

                            <!-- Reviews Section -->
                            <section class="company-reviews">
                                <h2><?php _e('Değerlendirmeler', 'firma-rehberi-pro'); ?></h2>
                                <div class="reviews-container">
                                    <?php
                                    $reviews = get_comments(array(
                                        'post_id' => get_the_ID(),
                                        'status'  => 'approve',
                                        'number'  => 10,
                                    ));
                                    
                                    if ($reviews) :
                                        foreach ($reviews as $review) :
                                    ?>
                                        <div class="review-item">
                                            <div class="review-header">
                                                <div class="reviewer-info">
                                                    <strong class="reviewer-name"><?php echo esc_html($review->comment_author); ?></strong>
                                                    <div class="review-rating">
                                                        <?php
                                                        $review_rating = get_comment_meta($review->comment_ID, '_rating', true);
                                                        for ($i = 1; $i <= 5; $i++) :
                                                        ?>
                                                            <span class="star <?php echo $i <= $review_rating ? 'filled' : ''; ?>">★</span>
                                                        <?php endfor; ?>
                                                    </div>
                                                </div>
                                                <div class="review-date"><?php echo get_comment_date('', $review); ?></div>
                                            </div>
                                            <div class="review-content">
                                                <?php echo wp_kses_post($review->comment_content); ?>
                                            </div>
                                        </div>
                                    <?php 
                                        endforeach;
                                    else :
                                    ?>
                                        <p class="no-reviews"><?php _e('Henüz değerlendirme bulunmuyor.', 'firma-rehberi-pro'); ?></p>
                                    <?php endif; ?>
                                </div>
                            </section>
                        </div>

                        <aside class="sidebar">
                            <!-- Contact Information -->
                            <div class="contact-widget">
                                <h3><?php _e('İletişim Bilgileri', 'firma-rehberi-pro'); ?></h3>
                                
                                <!-- 30 Saniye Geri Sayım -->
                                <div class="contact-countdown" id="contact-countdown">
                                    <div class="loading-spinner"></div>
                                    <div class="countdown-text">Firma bilgileri yükleniyor...</div>
                                    <div class="countdown-time" id="countdown-time">Kalan süre: 30 saniye</div>
                                </div>
                                
                                <?php
                                $phone = get_post_meta(get_the_ID(), '_phone', true);
                                $email = get_post_meta(get_the_ID(), '_email', true);
                                $website = get_post_meta(get_the_ID(), '_website', true);
                                $address = get_post_meta(get_the_ID(), '_address', true);
                                $working_hours = get_post_meta(get_the_ID(), '_working_hours', true);
                                ?>
                                
                                <div class="contact-info" style="display: none;">
                                    <?php if ($phone) : ?>
                                        <div class="contact-item">
                                            <span class="contact-icon">📞</span>
                                            <a href="tel:<?php echo esc_attr($phone); ?>"><?php echo esc_html($phone); ?></a>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if ($email) : ?>
                                        <div class="contact-item">
                                            <span class="contact-icon">✉️</span>
                                            <a href="mailto:<?php echo esc_attr($email); ?>"><?php echo esc_html($email); ?></a>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if ($website) : ?>
                                        <div class="contact-item">
                                            <span class="contact-icon">🌐</span>
                                            <a href="<?php echo esc_url($website); ?>" target="_blank" rel="noopener"><?php _e('Website', 'firma-rehberi-pro'); ?></a>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if ($address) : ?>
                                        <div class="contact-item">
                                            <span class="contact-icon">📍</span>
                                            <span><?php echo esc_html($address); ?></span>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if ($working_hours) : ?>
                                        <div class="contact-item">
                                            <span class="contact-icon">🕒</span>
                                            <span><?php echo esc_html($working_hours); ?></span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <!-- Google Map -->
                            <?php
                            $latitude = get_post_meta(get_the_ID(), '_latitude', true);
                            $longitude = get_post_meta(get_the_ID(), '_longitude', true);
                            $google_maps_api_key = get_theme_mod('google_maps_api_key');
                            
                            if ($latitude && $longitude && $google_maps_api_key) :
                            ?>
                                <div class="map-widget">
                                    <h3><?php _e('Konum', 'firma-rehberi-pro'); ?></h3>
                                    <div class="map-container">
                                        <iframe
                                            src="https://www.google.com/maps/embed/v1/place?key=<?php echo esc_attr($google_maps_api_key); ?>&q=<?php echo esc_attr($latitude); ?>,<?php echo esc_attr($longitude); ?>"
                                            width="100%"
                                            height="200"
                                            style="border:0;"
                                            allowfullscreen=""
                                            loading="lazy"
                                            referrerpolicy="no-referrer-when-downgrade">
                                        </iframe>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <!-- Social Media -->
                            <?php
                            $facebook = get_post_meta(get_the_ID(), '_facebook', true);
                            $twitter = get_post_meta(get_the_ID(), '_twitter', true);
                            $instagram = get_post_meta(get_the_ID(), '_instagram', true);
                            $linkedin = get_post_meta(get_the_ID(), '_linkedin', true);
                            
                            if ($facebook || $twitter || $instagram || $linkedin) :
                            ?>
                                <div class="social-widget">
                                    <h3><?php _e('Sosyal Medya', 'firma-rehberi-pro'); ?></h3>
                                    <div class="social-links">
                                        <?php if ($facebook) : ?>
                                            <a href="<?php echo esc_url($facebook); ?>" target="_blank" rel="noopener" aria-label="Facebook">📘</a>
                                        <?php endif; ?>
                                        <?php if ($twitter) : ?>
                                            <a href="<?php echo esc_url($twitter); ?>" target="_blank" rel="noopener" aria-label="Twitter">🐦</a>
                                        <?php endif; ?>
                                        <?php if ($instagram) : ?>
                                            <a href="<?php echo esc_url($instagram); ?>" target="_blank" rel="noopener" aria-label="Instagram">📷</a>
                                        <?php endif; ?>
                                        <?php if ($linkedin) : ?>
                                            <a href="<?php echo esc_url($linkedin); ?>" target="_blank" rel="noopener" aria-label="LinkedIn">💼</a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <!-- Share Buttons -->
                            <div class="share-widget">
                                <h3><?php _e('Paylaş', 'firma-rehberi-pro'); ?></h3>
                                <div class="share-buttons">
                                    <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode(get_permalink()); ?>" target="_blank" rel="noopener" class="share-btn facebook">Facebook</a>
                                    <a href="https://twitter.com/intent/tweet?url=<?php echo urlencode(get_permalink()); ?>&text=<?php echo urlencode(get_the_title()); ?>" target="_blank" rel="noopener" class="share-btn twitter">Twitter</a>
                                    <a href="https://wa.me/?text=<?php echo urlencode(get_the_title() . ' - ' . get_permalink()); ?>" target="_blank" rel="noopener" class="share-btn whatsapp">WhatsApp</a>
                                </div>
                            </div>
                        </aside>
                    </div>
                </div>
            </div>

            <!-- Related Companies -->
            <section class="related-companies">
                <div class="container">
                    <h2><?php _e('Benzer Firmalar', 'firma-rehberi-pro'); ?></h2>
                    <div class="companies-grid">
                        <?php
                        $related_companies = new WP_Query(array(
                            'post_type'      => 'company',
                            'posts_per_page' => 4,
                            'post__not_in'   => array(get_the_ID()),
                            'tax_query'      => array(
                                array(
                                    'taxonomy' => 'company_category',
                                    'field'    => 'term_id',
                                    'terms'    => wp_get_post_terms(get_the_ID(), 'company_category', array('fields' => 'ids')),
                                ),
                            ),
                        ));
                        
                        if ($related_companies->have_posts()) :
                            while ($related_companies->have_posts()) : $related_companies->the_post();
                                get_template_part('template-parts/company-card');
                            endwhile;
                            wp_reset_postdata();
                        endif;
                        ?>
                    </div>
                </div>
            </section>
        </article>
    <?php endwhile; ?>
</main>

<style>
.company-single {
    background: #ffffff;
}

.company-header {
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
    padding: 3rem 0;
    border-bottom: 1px solid #e5e7eb;
}

.company-info {
    display: grid;
    grid-template-columns: auto 1fr;
    gap: 2rem;
    align-items: start;
}

.company-logo-container {
    flex-shrink: 0;
}

.company-logo-large {
    width: 120px;
    height: 120px;
    border-radius: 12px;
    object-fit: cover;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
}

.company-logo-placeholder {
    width: 120px;
    height: 120px;
    background: #1e40af;
    color: #ffffff;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 2rem;
    font-weight: 700;
}

.company-title {
    font-size: 2.5rem;
    font-weight: 800;
    margin-bottom: 1rem;
    color: #1a1a1a;
}

.company-rating {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 1rem;
}

.stars {
    display: flex;
    gap: 0.25rem;
}

.star {
    color: #d1d5db;
    font-size: 1.25rem;
}

.star.filled {
    color: #fbbf24;
}

.rating-text {
    color: #6b7280;
    font-size: 0.875rem;
}

.company-categories,
.company-location {
    display: flex;
    gap: 0.5rem;
    flex-wrap: wrap;
    margin-bottom: 1rem;
}

.category-tag,
.location-tag {
    background: #1e40af;
    color: #ffffff;
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-size: 0.875rem;
    font-weight: 500;
}

.content-grid {
    display: grid;
    grid-template-columns: 2fr 1fr;
    gap: 3rem;
    padding: 3rem 0;
}

.main-content {
    min-width: 0;
}

.company-description,
.company-services,
.company-gallery,
.company-reviews {
    margin-bottom: 3rem;
}

.company-description h2,
.company-services h2,
.company-gallery h2,
.company-reviews h2 {
    font-size: 1.5rem;
    font-weight: 700;
    margin-bottom: 1.5rem;
    color: #1a1a1a;
    border-bottom: 2px solid #1e40af;
    padding-bottom: 0.5rem;
}

.services-list {
    list-style: none;
    padding: 0;
}

.services-list li {
    padding: 0.75rem 0;
    border-bottom: 1px solid #e5e7eb;
    position: relative;
    padding-left: 1.5rem;
}

.services-list li:before {
    content: "✓";
    color: #1e40af;
    font-weight: bold;
    position: absolute;
    left: 0;
}

.gallery-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1rem;
}

.gallery-item {
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

.gallery-image {
    width: 100%;
    height: 150px;
    object-fit: cover;
    transition: transform 0.2s ease;
}

.gallery-item:hover .gallery-image {
    transform: scale(1.05);
}

.review-item {
    background: #f8fafc;
    padding: 1.5rem;
    border-radius: 8px;
    margin-bottom: 1rem;
}

.review-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1rem;
}

.reviewer-name {
    color: #1a1a1a;
}

.review-rating {
    display: flex;
    gap: 0.25rem;
}

.review-date {
    color: #6b7280;
    font-size: 0.875rem;
}

.review-content {
    color: #4b5563;
    line-height: 1.6;
}

.no-reviews {
    text-align: center;
    color: #6b7280;
    font-style: italic;
    padding: 2rem;
}

.sidebar {
    display: flex;
    flex-direction: column;
    gap: 2rem;
}

.contact-widget,
.map-widget,
.social-widget,
.share-widget {
    background: #f8fafc;
    padding: 1.5rem;
    border-radius: 8px;
    border: 1px solid #e5e7eb;
}

.contact-widget h3,
.map-widget h3,
.social-widget h3,
.share-widget h3 {
    font-size: 1.25rem;
    font-weight: 600;
    margin-bottom: 1rem;
    color: #1a1a1a;
}

.contact-info {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.contact-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 0.75rem;
    background: #ffffff;
    border-radius: 6px;
    border: 1px solid #e5e7eb;
}

.contact-icon {
    font-size: 1.25rem;
    width: 24px;
    text-align: center;
}

.contact-item a {
    color: #1e40af;
    text-decoration: none;
}

.contact-item a:hover {
    text-decoration: underline;
}

.map-container {
    border-radius: 6px;
    overflow: hidden;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

.social-links {
    display: flex;
    gap: 1rem;
}

.social-links a {
    display: inline-block;
    width: 40px;
    height: 40px;
    background: #1e40af;
    color: #ffffff;
    border-radius: 50%;
    text-align: center;
    line-height: 40px;
    text-decoration: none;
    font-size: 1.25rem;
    transition: background 0.2s ease;
}

.social-links a:hover {
    background: #1d4ed8;
    color: #ffffff;
}

.share-buttons {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.share-btn {
    display: block;
    padding: 0.75rem 1rem;
    background: #ffffff;
    color: #1a1a1a;
    text-decoration: none;
    border-radius: 6px;
    border: 1px solid #e5e7eb;
    text-align: center;
    font-weight: 500;
    transition: all 0.2s ease;
}

.share-btn:hover {
    background: #1e40af;
    color: #ffffff;
    border-color: #1e40af;
}

.related-companies {
    background: #f8fafc;
    padding: 3rem 0;
    border-top: 1px solid #e5e7eb;
}

.related-companies h2 {
    text-align: center;
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 2rem;
    color: #1a1a1a;
}

@media (max-width: 768px) {
    .company-info {
        grid-template-columns: 1fr;
        text-align: center;
    }
    
    .content-grid {
        grid-template-columns: 1fr;
        gap: 2rem;
    }
    
    .company-title {
        font-size: 2rem;
    }
    
    .gallery-grid {
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    }
    
    .review-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.5rem;
    }
}
</style>

<?php get_footer(); ?>
