<?php
/**
 * The template for displaying company city archive pages
 *
 * @package FirmaRehberiPro
 */

get_header(); ?>

<main id="main" class="site-main" role="main">
    <div class="container">
        <!-- Breadcrumb -->
        <?php get_template_part('template-parts/breadcrumb'); ?>
        
        <!-- City Header -->
        <header class="city-header">
            <h1 class="city-title">
                <?php single_term_title(); ?> <?php _e('Firmaları', 'firma-rehberi-pro'); ?>
            </h1>
            <p class="city-description">
                <?php
                $term = get_queried_object();
                if ($term->description) {
                    echo esc_html($term->description);
                } else {
                    printf(
                        __('%s şehrindeki firmaları keşfedin. Detaylı bilgileri inceleyin ve en uygun hizmeti bulun.', 'firma-rehberi-pro'),
                        $term->name
                    );
                }
                ?>
            </p>
            <div class="city-meta">
                <span class="company-count">
                    <?php
                    printf(
                        _n(
                            '%d firma bulundu',
                            '%d firma bulundu',
                            $wp_query->found_posts,
                        'firma-rehberi-pro'
                        ),
                        $wp_query->found_posts
                    );
                    ?>
                </span>
            </div>
        </header>

        <!-- Filters Section -->
        <section class="filters-section">
            <form class="filters-form" method="get">
                <input type="hidden" name="company_city" value="<?php echo esc_attr(get_query_var('company_city')); ?>">
                
                <div class="filters-grid">
                    <div class="filter-group">
                        <label for="category-filter" class="filter-label"><?php _e('Kategori', 'firma-rehberi-pro'); ?></label>
                        <select name="company_category" id="category-filter" class="filter-select">
                            <option value=""><?php _e('Tüm Kategoriler', 'firma-rehberi-pro'); ?></option>
                            <?php
                            $categories = get_terms(array(
                                'taxonomy'   => 'company_category',
                                'hide_empty' => true,
                                'orderby'    => 'name',
                                'order'      => 'ASC',
                            ));
                            
                            if ($categories && !is_wp_error($categories)) :
                                foreach ($categories as $category) :
                                    $selected = isset($_GET['company_category']) && $_GET['company_category'] == $category->slug ? 'selected' : '';
                            ?>
                                <option value="<?php echo esc_attr($category->slug); ?>" <?php echo $selected; ?>>
                                    <?php echo esc_html($category->name); ?> (<?php echo esc_html($category->count); ?>)
                                </option>
                            <?php 
                                endforeach;
                            endif;
                            ?>
                        </select>
                    </div>
                    
                    <div class="filter-group">
                        <label for="rating-filter" class="filter-label"><?php _e('Değerlendirme', 'firma-rehberi-pro'); ?></label>
                        <select name="rating" id="rating-filter" class="filter-select">
                            <option value=""><?php _e('Tüm Değerlendirmeler', 'firma-rehberi-pro'); ?></option>
                            <option value="5" <?php selected(isset($_GET['rating']) ? $_GET['rating'] : '', '5'); ?>><?php _e('5 Yıldız', 'firma-rehberi-pro'); ?></option>
                            <option value="4" <?php selected(isset($_GET['rating']) ? $_GET['rating'] : '', '4'); ?>><?php _e('4+ Yıldız', 'firma-rehberi-pro'); ?></option>
                            <option value="3" <?php selected(isset($_GET['rating']) ? $_GET['rating'] : '', '3'); ?>><?php _e('3+ Yıldız', 'firma-rehberi-pro'); ?></option>
                        </select>
                    </div>
                    
                    <div class="filter-group">
                        <label for="sort-filter" class="filter-label"><?php _e('Sıralama', 'firma-rehberi-pro'); ?></label>
                        <select name="orderby" id="sort-filter" class="filter-select">
                            <option value="date" <?php selected(isset($_GET['orderby']) ? $_GET['orderby'] : '', 'date'); ?>><?php _e('En Yeni', 'firma-rehberi-pro'); ?></option>
                            <option value="title" <?php selected(isset($_GET['orderby']) ? $_GET['orderby'] : '', 'title'); ?>><?php _e('A-Z', 'firma-rehberi-pro'); ?></option>
                            <option value="meta_value_num" <?php selected(isset($_GET['orderby']) ? $_GET['orderby'] : '', 'meta_value_num'); ?>><?php _e('En Yüksek Puan', 'firma-rehberi-pro'); ?></option>
                        </select>
                    </div>
                </div>
                
                <div class="filter-actions">
                    <button type="submit" class="filter-button"><?php _e('Filtrele', 'firma-rehberi-pro'); ?></button>
                    <a href="<?php echo esc_url(get_term_link(get_queried_object())); ?>" class="clear-filters"><?php _e('Temizle', 'firma-rehberi-pro'); ?></a>
                </div>
            </form>
        </section>

        <!-- Results Section -->
        <section class="results-section">
            <?php if (have_posts()) : ?>
                <div class="companies-container">
                    <div class="companies-grid">
                        <?php while (have_posts()) : the_post(); ?>
                            <?php get_template_part('template-parts/company-card'); ?>
                        <?php endwhile; ?>
                    </div>
                </div>

                <!-- Pagination -->
                <nav class="pagination" role="navigation" aria-label="<?php _e('Sayfa navigasyonu', 'firma-rehberi-pro'); ?>">
                    <?php
                    echo paginate_links(array(
                        'prev_text' => '← ' . __('Önceki', 'firma-rehberi-pro'),
                        'next_text' => __('Sonraki', 'firma-rehberi-pro') . ' →',
                        'mid_size'  => 2,
                        'end_size'  => 1,
                    ));
                    ?>
                </nav>
            <?php else : ?>
                <div class="no-results">
                    <div class="no-results-content">
                        <h2><?php _e('Firma bulunamadı', 'firma-rehberi-pro'); ?></h2>
                        <p><?php _e('Bu şehirde henüz firma bulunmuyor. Lütfen daha sonra tekrar kontrol edin.', 'firma-rehberi-pro'); ?></p>
                        <a href="<?php echo esc_url(get_post_type_archive_link('company')); ?>" class="btn btn-primary">
                            <?php _e('Tüm Firmaları Görüntüle', 'firma-rehberi-pro'); ?>
                        </a>
                    </div>
                </div>
            <?php endif; ?>
        </section>
    </div>
</main>

<style>
.city-header {
    text-align: center;
    padding: 3rem 0;
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
    margin-bottom: 2rem;
    border-radius: 12px;
}

.city-title {
    font-size: 2.5rem;
    font-weight: 800;
    margin-bottom: 1rem;
    color: #1a1a1a;
}

.city-description {
    font-size: 1.25rem;
    color: #6b7280;
    max-width: 600px;
    margin: 0 auto 1.5rem;
}

.city-meta {
    display: flex;
    justify-content: center;
    gap: 2rem;
    flex-wrap: wrap;
}

.company-count {
    background: #1e40af;
    color: #ffffff;
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-weight: 600;
    font-size: 0.875rem;
}

.filters-section {
    background: #ffffff;
    padding: 2rem;
    border-radius: 12px;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
    margin-bottom: 2rem;
    border: 1px solid #e5e7eb;
}

.filters-form {
    display: flex;
    flex-direction: column;
    gap: 1.5rem;
}

.filters-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1rem;
}

.filter-group {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.filter-label {
    font-weight: 600;
    color: #374151;
    font-size: 0.875rem;
}

.filter-select {
    padding: 0.75rem;
    border: 1px solid #d1d5db;
    border-radius: 6px;
    background: #ffffff;
    font-size: 0.875rem;
    transition: border-color 0.2s ease;
}

.filter-select:focus {
    outline: none;
    border-color: #1e40af;
    box-shadow: 0 0 0 3px rgba(30, 64, 175, 0.1);
}

.filter-actions {
    display: flex;
    gap: 1rem;
    justify-content: center;
    flex-wrap: wrap;
}

.filter-button {
    background: #1e40af;
    color: #ffffff;
    padding: 0.75rem 2rem;
    border: none;
    border-radius: 6px;
    font-weight: 600;
    cursor: pointer;
    transition: background 0.2s ease;
}

.filter-button:hover {
    background: #1d4ed8;
}

.clear-filters {
    color: #6b7280;
    text-decoration: none;
    padding: 0.75rem 1rem;
    border: 1px solid #d1d5db;
    border-radius: 6px;
    transition: all 0.2s ease;
}

.clear-filters:hover {
    background: #f8fafc;
    color: #374151;
    text-decoration: none;
}

.results-section {
    background: #ffffff;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
    border: 1px solid #e5e7eb;
}

.companies-container {
    padding: 2rem;
}

.companies-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
    gap: 1.5rem;
}

.pagination {
    display: flex;
    justify-content: center;
    gap: 0.5rem;
    padding: 2rem;
    background: #f8fafc;
}

.pagination a,
.pagination span {
    padding: 0.75rem 1rem;
    border: 1px solid #d1d5db;
    border-radius: 6px;
    color: #374151;
    text-decoration: none;
    transition: all 0.2s ease;
    min-width: 44px;
    text-align: center;
}

.pagination a:hover {
    background: #1e40af;
    color: #ffffff;
    border-color: #1e40af;
}

.pagination .current {
    background: #1e40af;
    color: #ffffff;
    border-color: #1e40af;
}

.no-results {
    text-align: center;
    padding: 4rem 2rem;
}

.no-results-content h2 {
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 1rem;
    color: #1a1a1a;
}

.no-results-content p {
    font-size: 1.125rem;
    color: #6b7280;
    margin-bottom: 2rem;
    max-width: 500px;
    margin-left: auto;
    margin-right: auto;
}

.btn {
    display: inline-block;
    padding: 0.75rem 1.5rem;
    border-radius: 6px;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.2s ease;
}

.btn-primary {
    background: #1e40af;
    color: #ffffff;
}

.btn-primary:hover {
    background: #1d4ed8;
    color: #ffffff;
    text-decoration: none;
}

@media (max-width: 768px) {
    .city-title {
        font-size: 2rem;
    }
    
    .filters-grid {
        grid-template-columns: 1fr;
    }
    
    .companies-grid {
        grid-template-columns: 1fr;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto-submit form on filter change
    const filterSelects = document.querySelectorAll('.filter-select');
    filterSelects.forEach(select => {
        select.addEventListener('change', function() {
            this.form.submit();
        });
    });
});
</script>

<?php get_footer(); ?>
