<footer class="site-footer" role="contentinfo">
    <div class="container">
        <div class="footer-content">
            <div class="footer-section">
                <h3><?php _e('Hakkımızda', 'firma-rehberi-pro'); ?></h3>
                <p><?php _e('Türkiye\'nin en kapsamlı firma rehberi platformu. Güvenilir işletmeleri keşfedin, detaylı bilgileri inceleyin ve en uygun hizmeti bulun.', 'firma-rehberi-pro'); ?></p>
                
                <div class="footer-social mt-4">
                    <?php if (get_theme_mod('facebook_url')) : ?>
                        <a href="<?php echo esc_url(get_theme_mod('facebook_url')); ?>" target="_blank" rel="noopener" aria-label="Facebook">📘</a>
                    <?php endif; ?>
                    <?php if (get_theme_mod('twitter_url')) : ?>
                        <a href="<?php echo esc_url(get_theme_mod('twitter_url')); ?>" target="_blank" rel="noopener" aria-label="Twitter">🐦</a>
                    <?php endif; ?>
                    <?php if (get_theme_mod('instagram_url')) : ?>
                        <a href="<?php echo esc_url(get_theme_mod('instagram_url')); ?>" target="_blank" rel="noopener" aria-label="Instagram">📷</a>
                    <?php endif; ?>
                    <?php if (get_theme_mod('linkedin_url')) : ?>
                        <a href="<?php echo esc_url(get_theme_mod('linkedin_url')); ?>" target="_blank" rel="noopener" aria-label="LinkedIn">💼</a>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="footer-section">
                <h3><?php _e('Firma Kategorileri', 'firma-rehberi-pro'); ?></h3>
                <ul>
                    <?php
                    $categories = get_terms(array(
                        'taxonomy'   => 'company_category',
                        'hide_empty' => true,
                        'number'     => 6,
                    ));
                    
                    if ($categories && !is_wp_error($categories)) :
                        foreach ($categories as $category) :
                    ?>
                        <li>
                            <a href="<?php echo esc_url(get_term_link($category)); ?>">
                                <?php echo esc_html($category->name); ?>
                            </a>
                        </li>
                    <?php 
                        endforeach;
                    endif;
                    ?>
                </ul>
            </div>
            
            <div class="footer-section">
                <h3><?php _e('Popüler Şehirler', 'firma-rehberi-pro'); ?></h3>
                <ul>
                    <?php
                    $cities = get_terms(array(
                        'taxonomy'   => 'company_city',
                        'hide_empty' => true,
                        'number'     => 6,
                        'orderby'    => 'count',
                        'order'      => 'DESC',
                    ));
                    
                    if ($cities && !is_wp_error($cities)) :
                        foreach ($cities as $city) :
                    ?>
                        <li>
                            <a href="<?php echo esc_url(get_term_link($city)); ?>">
                                <?php echo esc_html($city->name); ?>
                            </a>
                        </li>
                    <?php 
                        endforeach;
                    endif;
                    ?>
                </ul>
            </div>
            
            <div class="footer-section">
                <h3><?php _e('Bize Katılın', 'firma-rehberi-pro'); ?></h3>
                <p><?php _e('Hemen ücretsiz üye olun ve yeni güncellemelerden haberdar olan ilk kişi olun.', 'firma-rehberi-pro'); ?></p>
                
                <form class="newsletter-form mt-4" action="#" method="post">
                    <div class="newsletter-input-group">
                        <input type="email" name="newsletter_email" placeholder="<?php _e('E-posta adresiniz', 'firma-rehberi-pro'); ?>" required>
                        <button type="submit" class="newsletter-button">
                            <?php _e('Abone Ol', 'firma-rehberi-pro'); ?>
                        </button>
                    </div>
                    <input type="hidden" name="newsletter_nonce" value="<?php echo wp_create_nonce('newsletter_subscribe'); ?>">
                </form>
            </div>
        </div>
        
        <div class="footer-bottom">
            <div class="flex justify-between items-center">
                <p>
                    &copy; <?php echo date('Y'); ?> 
                    <a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name'); ?></a>. 
                    <?php _e('Tüm Hakları Saklıdır.', 'firma-rehberi-pro'); ?>
                </p>
                
                <div class="footer-links">
                    <a href="<?php echo esc_url(home_url('/gizlilik-politikasi')); ?>">
                        <?php _e('Gizlilik Politikası', 'firma-rehberi-pro'); ?>
                    </a>
                    <a href="<?php echo esc_url(home_url('/kullanim-kosullari')); ?>">
                        <?php _e('Kullanım Koşulları', 'firma-rehberi-pro'); ?>
                    </a>
                    <a href="<?php echo esc_url(home_url('/iletisim')); ?>">
                        <?php _e('İletişim', 'firma-rehberi-pro'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
</footer>

<?php wp_footer(); ?>

<script>
// Mobile menu toggle
document.addEventListener('DOMContentLoaded', function() {
    const mobileToggle = document.querySelector('.mobile-menu-toggle');
    const navMenu = document.querySelector('.main-nav');
    
    if (mobileToggle && navMenu) {
        mobileToggle.addEventListener('click', function() {
            const isExpanded = this.getAttribute('aria-expanded') === 'true';
            this.setAttribute('aria-expanded', !isExpanded);
            navMenu.classList.toggle('active');
        });
    }
    
    // Newsletter form submission
    const newsletterForm = document.querySelector('.newsletter-form');
    if (newsletterForm) {
        newsletterForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const email = this.querySelector('input[name="newsletter_email"]').value;
            const nonce = this.querySelector('input[name="newsletter_nonce"]').value;
            
            if (email) {
                // Here you would typically send the email to your server
                alert('<?php _e('Bültenimize başarıyla abone oldunuz!', 'firma-rehberi-pro'); ?>');
                this.reset();
            }
        });
    }
    
    // Lazy loading for images
    if ('IntersectionObserver' in window) {
        const imageObserver = new IntersectionObserver((entries, observer) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    const img = entry.target;
                    if (img.dataset.src) {
                        img.src = img.dataset.src;
                        img.classList.remove('lazy');
                        observer.unobserve(img);
                    }
                }
            });
        });
        
        document.querySelectorAll('img[data-src]').forEach(img => {
            imageObserver.observe(img);
        });
    }
});
</script>

</body>
</html>
