'use client'

import { useState } from 'react'
import { Mail, Save, Send, Settings } from 'lucide-react'

export default function EpostaAyarlariPage() {
  const [settings, setSettings] = useState({
    smtpHost: 'smtp.gmail.com',
    smtpPort: 587,
    smtpUsername: 'noreply@dansdersleri.com',
    smtpPassword: '••••••••••••••••',
    fromName: 'Dans Dersleri',
    fromEmail: 'noreply@dansdersleri.com',
    replyTo: 'info@dansdersleri.com',
    useSSL: true,
    useTLS: true
  })

  const [templates, setTemplates] = useState({
    welcomeSubject: 'Hoş Geldiniz!',
    welcomeBody: 'Merhaba {name},\n\nDans Dersleri platformuna hoş geldiniz!\n\nEn iyi dans deneyimi için buradayız.\n\nSaygılarımızla,\nDans Dersleri Ekibi',
    courseApprovalSubject: 'Kursunuz Onaylandı',
    courseApprovalBody: 'Merhaba {instructor_name},\n\n{course_name} kursunuz başarıyla onaylanmıştır.\n\nKursunuz artık platformda görünür durumda.\n\nSaygılarımızla,\nDans Dersleri Ekibi',
    paymentConfirmationSubject: 'Ödeme Onaylandı',
    paymentConfirmationBody: 'Merhaba {customer_name},\n\n{package_name} paketi için ödemeniz başarıyla alınmıştır.\n\nÖdeme Tutarı: {amount}\n\nSaygılarımızla,\nDans Dersleri Ekibi'
  })

  const handleSave = () => {
    alert('E-posta ayarları kaydedildi!')
  }

  const handleTestEmail = () => {
    alert('Test e-postası gönderildi!')
  }

  return (
    <div className="space-y-6">
      {/* Header */}
      <div className="flex justify-between items-center">
        <div>
          <h1 className="text-2xl font-bold text-gray-900">E-posta Ayarları</h1>
          <p className="text-gray-600">E-posta sunucu ayarları ve şablonları yönetin</p>
        </div>
        <div className="flex space-x-2">
          <button 
            onClick={handleTestEmail}
            className="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg flex items-center space-x-2"
          >
            <Send className="w-4 h-4" />
            <span>Test Gönder</span>
          </button>
          <button 
            onClick={handleSave}
            className="bg-primary-600 hover:bg-primary-700 text-white px-4 py-2 rounded-lg flex items-center space-x-2"
          >
            <Save className="w-4 h-4" />
            <span>Kaydet</span>
          </button>
        </div>
      </div>

      {/* SMTP Settings */}
      <div className="bg-white p-6 rounded-lg shadow">
        <div className="flex items-center mb-4">
          <Mail className="w-6 h-6 text-blue-600 mr-3" />
          <h3 className="text-lg font-semibold text-gray-900">SMTP Ayarları</h3>
        </div>
        <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">
              SMTP Sunucu
            </label>
            <input
              type="text"
              value={settings.smtpHost}
              onChange={(e) => setSettings({...settings, smtpHost: e.target.value})}
              className="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
            />
          </div>
          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">
              Port
            </label>
            <input
              type="number"
              value={settings.smtpPort}
              onChange={(e) => setSettings({...settings, smtpPort: parseInt(e.target.value)})}
              className="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
            />
          </div>
          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">
              Kullanıcı Adı
            </label>
            <input
              type="text"
              value={settings.smtpUsername}
              onChange={(e) => setSettings({...settings, smtpUsername: e.target.value})}
              className="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
            />
          </div>
          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">
              Şifre
            </label>
            <input
              type="password"
              value={settings.smtpPassword}
              onChange={(e) => setSettings({...settings, smtpPassword: e.target.value})}
              className="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
            />
          </div>
        </div>
        <div className="mt-4 flex space-x-4">
          <label className="flex items-center">
            <input
              type="checkbox"
              checked={settings.useSSL}
              onChange={(e) => setSettings({...settings, useSSL: e.target.checked})}
              className="mr-2"
            />
            <span className="text-sm text-gray-700">SSL Kullan</span>
          </label>
          <label className="flex items-center">
            <input
              type="checkbox"
              checked={settings.useTLS}
              onChange={(e) => setSettings({...settings, useTLS: e.target.checked})}
              className="mr-2"
            />
            <span className="text-sm text-gray-700">TLS Kullan</span>
          </label>
        </div>
      </div>

      {/* From Settings */}
      <div className="bg-white p-6 rounded-lg shadow">
        <div className="flex items-center mb-4">
          <Settings className="w-6 h-6 text-green-600 mr-3" />
          <h3 className="text-lg font-semibold text-gray-900">Gönderen Bilgileri</h3>
        </div>
        <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">
              Gönderen Adı
            </label>
            <input
              type="text"
              value={settings.fromName}
              onChange={(e) => setSettings({...settings, fromName: e.target.value})}
              className="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
            />
          </div>
          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">
              Gönderen E-posta
            </label>
            <input
              type="email"
              value={settings.fromEmail}
              onChange={(e) => setSettings({...settings, fromEmail: e.target.value})}
              className="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
            />
          </div>
          <div className="md:col-span-2">
            <label className="block text-sm font-medium text-gray-700 mb-2">
              Yanıt Adresi
            </label>
            <input
              type="email"
              value={settings.replyTo}
              onChange={(e) => setSettings({...settings, replyTo: e.target.value})}
              className="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
            />
          </div>
        </div>
      </div>

      {/* Email Templates */}
      <div className="bg-white p-6 rounded-lg shadow">
        <h3 className="text-lg font-semibold text-gray-900 mb-4">E-posta Şablonları</h3>
        
        {/* Welcome Template */}
        <div className="mb-6 p-4 border border-gray-200 rounded-lg">
          <h4 className="font-medium text-gray-900 mb-2">Hoş Geldin E-postası</h4>
          <div className="space-y-3">
            <div>
              <label className="block text-sm font-medium text-gray-700 mb-1">
                Konu
              </label>
              <input
                type="text"
                value={templates.welcomeSubject}
                onChange={(e) => setTemplates({...templates, welcomeSubject: e.target.value})}
                className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
              />
            </div>
            <div>
              <label className="block text-sm font-medium text-gray-700 mb-1">
                İçerik
              </label>
              <textarea
                value={templates.welcomeBody}
                onChange={(e) => setTemplates({...templates, welcomeBody: e.target.value})}
                rows={4}
                className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
              />
            </div>
          </div>
        </div>

        {/* Course Approval Template */}
        <div className="mb-6 p-4 border border-gray-200 rounded-lg">
          <h4 className="font-medium text-gray-900 mb-2">Kurs Onay E-postası</h4>
          <div className="space-y-3">
            <div>
              <label className="block text-sm font-medium text-gray-700 mb-1">
                Konu
              </label>
              <input
                type="text"
                value={templates.courseApprovalSubject}
                onChange={(e) => setTemplates({...templates, courseApprovalSubject: e.target.value})}
                className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
              />
            </div>
            <div>
              <label className="block text-sm font-medium text-gray-700 mb-1">
                İçerik
              </label>
              <textarea
                value={templates.courseApprovalBody}
                onChange={(e) => setTemplates({...templates, courseApprovalBody: e.target.value})}
                rows={4}
                className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
              />
            </div>
          </div>
        </div>

        {/* Payment Confirmation Template */}
        <div className="p-4 border border-gray-200 rounded-lg">
          <h4 className="font-medium text-gray-900 mb-2">Ödeme Onay E-postası</h4>
          <div className="space-y-3">
            <div>
              <label className="block text-sm font-medium text-gray-700 mb-1">
                Konu
              </label>
              <input
                type="text"
                value={templates.paymentConfirmationSubject}
                onChange={(e) => setTemplates({...templates, paymentConfirmationSubject: e.target.value})}
                className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
              />
            </div>
            <div>
              <label className="block text-sm font-medium text-gray-700 mb-1">
                İçerik
              </label>
              <textarea
                value={templates.paymentConfirmationBody}
                onChange={(e) => setTemplates({...templates, paymentConfirmationBody: e.target.value})}
                rows={4}
                className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
              />
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}