'use client'

import Link from 'next/link'
import { Plus, Search, Filter, Download } from 'lucide-react'
import CourseTable from '@/components/admin/CourseTable'

export default function CoursesManagement() {
  return (
    <div className="space-y-6">
      {/* Page Header */}
      <div className="flex items-center justify-between">
        <div>
          <h1 className="text-3xl font-bold text-gray-900">Kurs Yönetimi</h1>
          <p className="text-gray-600 mt-2">Tüm kursları görüntüleyin ve yönetin</p>
        </div>
        <Link
          href="/admin/kurslar/yeni"
          className="btn-primary flex items-center space-x-2"
        >
          <Plus className="w-5 h-5" />
          <span>Yeni Kurs Ekle</span>
        </Link>
      </div>

      {/* Filters */}
      <div className="bg-white rounded-xl shadow-lg p-6">
        <div className="grid grid-cols-1 md:grid-cols-4 gap-4">
          {/* Search */}
          <div className="md:col-span-2">
            <div className="relative">
              <Search className="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400 w-5 h-5" />
              <input
                type="text"
                placeholder="Kurs adı, şehir veya öğretmen ara..."
                className="w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
              />
            </div>
          </div>

          {/* Status Filter */}
          <div>
            <select className="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent">
              <option value="">Tüm Durumlar</option>
              <option value="active">Aktif</option>
              <option value="pending">Onay Bekliyor</option>
              <option value="inactive">Pasif</option>
            </select>
          </div>

          {/* City Filter */}
          <div>
            <select className="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent">
              <option value="">Tüm Şehirler</option>
              <option value="istanbul">İstanbul</option>
              <option value="ankara">Ankara</option>
              <option value="izmir">İzmir</option>
            </select>
          </div>
        </div>

        {/* Action Buttons */}
        <div className="flex items-center justify-between mt-4 pt-4 border-t border-gray-200">
          <div className="flex items-center space-x-2">
            <button className="flex items-center space-x-2 px-4 py-2 text-sm border border-gray-300 rounded-lg hover:bg-gray-50 transition-colors">
              <Filter className="w-4 h-4" />
              <span>Daha Fazla Filtre</span>
            </button>
          </div>
          <button className="flex items-center space-x-2 px-4 py-2 text-sm bg-green-600 hover:bg-green-700 text-white rounded-lg transition-colors">
            <Download className="w-4 h-4" />
            <span>Excel İndir</span>
          </button>
        </div>
      </div>

      {/* Stats */}
      <div className="grid grid-cols-1 md:grid-cols-4 gap-6">
        <div className="bg-white rounded-xl shadow-lg p-6">
          <p className="text-sm text-gray-600 mb-1">Toplam Kurs</p>
          <p className="text-3xl font-bold text-gray-900">486</p>
          <p className="text-sm text-green-600 mt-2">+12 bu ay</p>
        </div>
        <div className="bg-white rounded-xl shadow-lg p-6">
          <p className="text-sm text-gray-600 mb-1">Aktif Kurs</p>
          <p className="text-3xl font-bold text-green-600">412</p>
          <p className="text-sm text-gray-500 mt-2">%84.8 aktif</p>
        </div>
        <div className="bg-white rounded-xl shadow-lg p-6">
          <p className="text-sm text-gray-600 mb-1">Onay Bekleyen</p>
          <p className="text-3xl font-bold text-yellow-600">45</p>
          <p className="text-sm text-gray-500 mt-2">İşlem gerekli</p>
        </div>
        <div className="bg-white rounded-xl shadow-lg p-6">
          <p className="text-sm text-gray-600 mb-1">Pasif Kurs</p>
          <p className="text-3xl font-bold text-red-600">29</p>
          <p className="text-sm text-gray-500 mt-2">%5.9 pasif</p>
        </div>
      </div>

      {/* Course Table */}
      <CourseTable />
    </div>
  )
}
