'use client'

import DashboardStats from '@/components/admin/DashboardStats'
import RecentCourses from '@/components/admin/RecentCourses'
import RecentPayments from '@/components/admin/RecentPayments'
import PopularCities from '@/components/admin/PopularCities'
import RevenueChart from '@/components/admin/RevenueChart'

export default function AdminDashboard() {
  return (
    <div className="space-y-6">
      {/* Page Header */}
      <div>
        <h1 className="text-3xl font-bold text-gray-900">Dashboard</h1>
        <p className="text-gray-600 mt-2">Hoş geldiniz! İşte genel bakış...</p>
      </div>

      {/* Stats */}
      <DashboardStats />

      {/* Charts */}
      <div className="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <RevenueChart />
        <PopularCities />
      </div>

      {/* Tables */}
      <div className="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <RecentCourses />
        <RecentPayments />
      </div>
    </div>
  )
}
