'use client'

import { useState } from 'react'
import { DollarSign, TrendingUp, CreditCard, Calendar, Download } from 'lucide-react'

export default function GelirRaporlariPage() {
  const [selectedPeriod, setSelectedPeriod] = useState('thisMonth')

  const revenueStats = [
    {
      title: 'Toplam Gelir',
      value: '₺124,500',
      change: '+12.5%',
      changeType: 'positive',
      icon: DollarSign
    },
    {
      title: 'Aylık Gelir',
      value: '₺45,200',
      change: '+8.2%',
      changeType: 'positive',
      icon: TrendingUp
    },
    {
      title: 'Aktif Abonelik',
      value: '234',
      change: '+15.3%',
      changeType: 'positive',
      icon: CreditCard
    },
    {
      title: 'Ortalama Fiyat',
      value: '₺275',
      change: '-2.1%',
      changeType: 'negative',
      icon: Calendar
    }
  ]

  const revenueSources = [
    {
      source: 'Temel Paket',
      amount: 12450,
      percentage: 27.5,
      subscribers: 45
    },
    {
      source: 'Profesyonel Paket',
      amount: 22800,
      percentage: 50.4,
      subscribers: 76
    },
    {
      source: 'Kurumsal Paket',
      amount: 9600,
      percentage: 21.2,
      subscribers: 24
    },
    {
      source: 'Yıllık Paketler',
      amount: 350,
      percentage: 0.8,
      subscribers: 2
    }
  ]

  const monthlyRevenue = [
    { month: 'Ocak', revenue: 38000 },
    { month: 'Şubat', revenue: 42000 },
    { month: 'Mart', revenue: 45200 },
    { month: 'Nisan', revenue: 0 },
    { month: 'Mayıs', revenue: 0 },
    { month: 'Haziran', revenue: 0 }
  ]

  return (
    <div className="space-y-6">
      {/* Header */}
      <div className="flex justify-between items-center">
        <div>
          <h1 className="text-2xl font-bold text-gray-900">Gelir Raporları</h1>
          <p className="text-gray-600">Finansal performans ve gelir analizleri</p>
        </div>
        <div className="flex space-x-2">
          <select
            value={selectedPeriod}
            onChange={(e) => setSelectedPeriod(e.target.value)}
            className="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
          >
            <option value="thisWeek">Bu Hafta</option>
            <option value="thisMonth">Bu Ay</option>
            <option value="lastMonth">Geçen Ay</option>
            <option value="thisYear">Bu Yıl</option>
          </select>
          <button className="bg-primary-600 hover:bg-primary-700 text-white px-4 py-2 rounded-lg flex items-center space-x-2">
            <Download className="w-4 h-4" />
            <span>Rapor İndir</span>
          </button>
        </div>
      </div>

      {/* Stats Cards */}
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        {revenueStats.map((stat, index) => (
          <div key={index} className="bg-white p-6 rounded-lg shadow">
            <div className="flex items-center">
              <div className="p-2 bg-primary-100 rounded-lg">
                <stat.icon className="w-6 h-6 text-primary-600" />
              </div>
              <div className="ml-4 flex-1">
                <p className="text-sm font-medium text-gray-600">{stat.title}</p>
                <p className="text-2xl font-bold text-gray-900">{stat.value}</p>
                <p className={`text-sm flex items-center ${
                  stat.changeType === 'positive' ? 'text-green-600' : 'text-red-600'
                }`}>
                  {stat.change}
                </p>
              </div>
            </div>
          </div>
        ))}
      </div>

      {/* Revenue Chart */}
      <div className="bg-white p-6 rounded-lg shadow">
        <h3 className="text-lg font-semibold text-gray-900 mb-4">Aylık Gelir Trendi</h3>
        <div className="h-64 bg-gray-50 rounded-lg flex items-center justify-center">
          <div className="text-center">
            <div className="w-16 h-16 bg-gray-200 rounded-full flex items-center justify-center mx-auto mb-4">
              <TrendingUp className="w-8 h-8 text-gray-400" />
            </div>
            <p className="text-gray-500">Gelir grafiği burada görünecek</p>
          </div>
        </div>
      </div>

      {/* Revenue Sources */}
      <div className="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <div className="bg-white p-6 rounded-lg shadow">
          <h3 className="text-lg font-semibold text-gray-900 mb-4">Gelir Kaynakları</h3>
          <div className="space-y-4">
            {revenueSources.map((source, index) => (
              <div key={index} className="flex items-center justify-between">
                <div className="flex-1">
                  <div className="flex justify-between items-center mb-1">
                    <span className="text-sm font-medium text-gray-900">{source.source}</span>
                    <span className="text-sm text-gray-600">{source.percentage}%</span>
                  </div>
                  <div className="w-full bg-gray-200 rounded-full h-2">
                    <div 
                      className="bg-primary-600 h-2 rounded-full" 
                      style={{ width: `${source.percentage}%` }}
                    ></div>
                  </div>
                  <div className="flex justify-between items-center mt-1">
                    <span className="text-xs text-gray-500">{source.subscribers} abone</span>
                    <span className="text-xs font-medium text-gray-900">₺{source.amount.toLocaleString()}</span>
                  </div>
                </div>
              </div>
            ))}
          </div>
        </div>

        <div className="bg-white p-6 rounded-lg shadow">
          <h3 className="text-lg font-semibold text-gray-900 mb-4">Aylık Karşılaştırma</h3>
          <div className="space-y-3">
            {monthlyRevenue.map((month, index) => (
              <div key={index} className="flex justify-between items-center">
                <span className="text-sm text-gray-600">{month.month}</span>
                <div className="flex items-center space-x-2">
                  <div className="w-24 bg-gray-200 rounded-full h-2">
                    {month.revenue > 0 && (
                      <div 
                        className="bg-green-600 h-2 rounded-full" 
                        style={{ width: `${(month.revenue / 50000) * 100}%` }}
                      ></div>
                    )}
                  </div>
                  <span className="text-sm font-medium text-gray-900 w-16 text-right">
                    {month.revenue > 0 ? `₺${month.revenue.toLocaleString()}` : '-'}
                  </span>
                </div>
              </div>
            ))}
          </div>
        </div>
      </div>

      {/* Payment Methods */}
      <div className="bg-white p-6 rounded-lg shadow">
        <h3 className="text-lg font-semibold text-gray-900 mb-4">Ödeme Yöntemleri</h3>
        <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
          <div className="text-center p-4 bg-gray-50 rounded-lg">
            <CreditCard className="w-8 h-8 text-blue-600 mx-auto mb-2" />
            <h4 className="font-medium text-gray-900">Kredi Kartı</h4>
            <p className="text-2xl font-bold text-gray-900">₺32,400</p>
            <p className="text-sm text-gray-600">71.7%</p>
          </div>
          <div className="text-center p-4 bg-gray-50 rounded-lg">
            <Calendar className="w-8 h-8 text-green-600 mx-auto mb-2" />
            <h4 className="font-medium text-gray-900">Banka Havalesi</h4>
            <p className="text-2xl font-bold text-gray-900">₺8,200</p>
            <p className="text-sm text-gray-600">18.1%</p>
          </div>
          <div className="text-center p-4 bg-gray-50 rounded-lg">
            <DollarSign className="w-8 h-8 text-purple-600 mx-auto mb-2" />
            <h4 className="font-medium text-gray-900">Diğer</h4>
            <p className="text-2xl font-bold text-gray-900">₺4,600</p>
            <p className="text-sm text-gray-600">10.2%</p>
          </div>
        </div>
      </div>

      {/* Revenue Forecast */}
      <div className="bg-white p-6 rounded-lg shadow">
        <h3 className="text-lg font-semibold text-gray-900 mb-4">Gelir Tahmini</h3>
        <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
          <div className="text-center">
            <p className="text-sm text-gray-600">Bu Ay Tahmini</p>
            <p className="text-2xl font-bold text-gray-900">₺48,500</p>
            <p className="text-sm text-green-600">+7.3% artış</p>
          </div>
          <div className="text-center">
            <p className="text-sm text-gray-600">Gelecek Ay</p>
            <p className="text-2xl font-bold text-gray-900">₺52,200</p>
            <p className="text-sm text-green-600">+15.5% artış</p>
          </div>
          <div className="text-center">
            <p className="text-sm text-gray-600">Yıllık Tahmini</p>
            <p className="text-2xl font-bold text-gray-900">₺580,000</p>
            <p className="text-sm text-green-600">+22.1% artış</p>
          </div>
        </div>
      </div>
    </div>
  )
}

