import Link from 'next/link'
import { Home, Search, ArrowLeft } from 'lucide-react'

export default function NotFound() {
  return (
    <div className="min-h-screen bg-gray-50 flex items-center justify-center px-4">
      <div className="max-w-md w-full text-center">
        {/* 404 Illustration */}
        <div className="mb-8">
          <div className="w-32 h-32 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-4">
            <span className="text-6xl">💃</span>
          </div>
          <h1 className="text-6xl font-bold text-gray-900 mb-2">404</h1>
          <h2 className="text-2xl font-semibold text-gray-700 mb-4">
            Sayfa Bulunamadı
          </h2>
          <p className="text-gray-600 mb-8">
            Aradığınız sayfa mevcut değil veya taşınmış olabilir. 
            Dans kurslarımızı keşfetmeye devam edin!
          </p>
        </div>

        {/* Action Buttons */}
        <div className="space-y-4">
          <Link
            href="/"
            className="btn-primary w-full flex items-center justify-center space-x-2"
          >
            <Home className="w-5 h-5" />
            <span>Ana Sayfaya Dön</span>
          </Link>
          
          <Link
            href="/arama"
            className="btn-outline w-full flex items-center justify-center space-x-2"
          >
            <Search className="w-5 h-5" />
            <span>Kurs Ara</span>
          </Link>
        </div>

        {/* Helpful Links */}
        <div className="mt-12 pt-8 border-t border-gray-200">
          <h3 className="text-lg font-semibold text-gray-900 mb-4">
            Popüler Sayfalar
          </h3>
          <div className="grid grid-cols-2 gap-4 text-sm">
            <Link 
              href="/dans-turleri" 
              className="text-primary-600 hover:text-primary-700 transition-colors"
            >
              Dans Türleri
            </Link>
            <Link 
              href="/sehirler" 
              className="text-primary-600 hover:text-primary-700 transition-colors"
            >
              Şehirler
            </Link>
            <Link 
              href="/kurslar" 
              className="text-primary-600 hover:text-primary-700 transition-colors"
            >
              Tüm Kurslar
            </Link>
            <Link 
              href="/iletisim" 
              className="text-primary-600 hover:text-primary-700 transition-colors"
            >
              İletişim
            </Link>
          </div>
        </div>

        {/* Back Button */}
        <div className="mt-8">
          <button
            onClick={() => window.history.back()}
            className="text-gray-500 hover:text-gray-700 flex items-center justify-center space-x-2 mx-auto"
          >
            <ArrowLeft className="w-4 h-4" />
            <span>Geri Dön</span>
          </button>
        </div>
      </div>
    </div>
  )
}

