import Hero from '@/components/Hero'
import DanceTypes from '@/components/DanceTypes'
import FeaturedCourses from '@/components/FeaturedCourses'
import CitySearch from '@/components/CitySearch'
import Stats from '@/components/Stats'
import Testimonials from '@/components/Testimonials'
import CTA from '@/components/CTA'
import StructuredData from '@/components/StructuredData'
import { generateOrganizationSchema, generateWebsiteSchema } from '@/lib/schema'

export default function Home() {
  return (
    <>
      <StructuredData data={generateOrganizationSchema()} />
      <StructuredData data={generateWebsiteSchema()} />
      
      <div className="min-h-screen">
        <Hero />
        <Stats />
        <DanceTypes />
        <CitySearch />
        <FeaturedCourses />
        <Testimonials />
        <CTA />
      </div>
    </>
  )
}
