import { MetadataRoute } from 'next'

export default function sitemap(): MetadataRoute.Sitemap {
  const baseUrl = 'https://dansdersleri.com'
  
  // Şehirler
  const cities = [
    'istanbul', 'ankara', 'izmir', 'bursa', 'antalya', 'adana', 
    'konya', 'gaziantep', 'mersin', 'diyarbakir'
  ]
  
  // Dans türleri
  const danceTypes = [
    'salsa', 'bachata', 'tango', 'hip-hop', 'klasik-bale', 
    'modern-dans', 'latin-danslari', 'swing'
  ]
  
  // Statik sayfalar
  const staticPages = [
    {
      url: baseUrl,
      lastModified: new Date(),
      changeFrequency: 'daily' as const,
      priority: 1.0,
    },
    {
      url: `${baseUrl}/kurslar`,
      lastModified: new Date(),
      changeFrequency: 'daily' as const,
      priority: 0.9,
    },
    {
      url: `${baseUrl}/dans-turleri`,
      lastModified: new Date(),
      changeFrequency: 'weekly' as const,
      priority: 0.8,
    },
    {
      url: `${baseUrl}/sehirler`,
      lastModified: new Date(),
      changeFrequency: 'weekly' as const,
      priority: 0.8,
    },
    {
      url: `${baseUrl}/blog`,
      lastModified: new Date(),
      changeFrequency: 'daily' as const,
      priority: 0.7,
    },
    {
      url: `${baseUrl}/sss`,
      lastModified: new Date(),
      changeFrequency: 'monthly' as const,
      priority: 0.6,
    },
    {
      url: `${baseUrl}/hakkimizda`,
      lastModified: new Date(),
      changeFrequency: 'monthly' as const,
      priority: 0.5,
    },
    {
      url: `${baseUrl}/iletisim`,
      lastModified: new Date(),
      changeFrequency: 'monthly' as const,
      priority: 0.5,
    },
  ]
  
  // Şehir sayfaları
  const cityPages = cities.map(city => ({
    url: `${baseUrl}/sehirler/${city}`,
    lastModified: new Date(),
    changeFrequency: 'weekly' as const,
    priority: 0.7,
  }))
  
  // Dans türü sayfaları
  const danceTypePages = danceTypes.map(type => ({
    url: `${baseUrl}/dans-turleri/${type}`,
    lastModified: new Date(),
    changeFrequency: 'weekly' as const,
    priority: 0.7,
  }))
  
  // Örnek kurs sayfaları (gerçek uygulamada database'den gelecek)
  const coursePages = Array.from({ length: 6 }, (_, i) => ({
    url: `${baseUrl}/kurslar/${i + 1}`,
    lastModified: new Date(),
    changeFrequency: 'weekly' as const,
    priority: 0.6,
  }))
  
  return [
    ...staticPages,
    ...cityPages,
    ...danceTypePages,
    ...coursePages,
  ]
}

