'use client'

import { useState } from 'react'
import Link from 'next/link'
import { ArrowRight, Star, Users, Clock } from 'lucide-react'

export default function DanceTypes() {
  const [hoveredCard, setHoveredCard] = useState<number | null>(null)

  const danceTypes = [
    {
      id: 1,
      name: 'Salsa',
      description: 'Sıcak Latin ritimleri ile coşkulu dans',
      image: 'https://images.unsplash.com/photo-1547036967-23d11aacaee0?w=400&h=300&fit=crop',
      courseCount: 45,
      rating: 4.8,
      duration: '8 hafta',
      level: 'Başlangıç',
      color: 'from-red-500 to-orange-500',
      emoji: '💃'
    },
    {
      id: 2,
      name: 'Bachata',
      description: 'Romantik ve duygusal Latin dansı',
      image: 'https://images.unsplash.com/photo-1571019613454-1cb2f99b2d8b?w=400&h=300&fit=crop',
      courseCount: 32,
      rating: 4.9,
      duration: '6 hafta',
      level: 'Başlangıç',
      color: 'from-pink-500 to-rose-500',
      emoji: '🌹'
    },
    {
      id: 3,
      name: 'Tango',
      description: 'Tutkulu ve zarif Arjantin dansı',
      image: 'https://images.unsplash.com/photo-1508700929628-666bc8bd84ea?w=400&h=300&fit=crop',
      courseCount: 28,
      rating: 4.7,
      duration: '10 hafta',
      level: 'Orta',
      color: 'from-purple-500 to-indigo-500',
      emoji: '🕺'
    },
    {
      id: 4,
      name: 'Hip-Hop',
      description: 'Enerjik ve modern şehir dansı',
      image: 'https://images.unsplash.com/photo-1518611012118-696072aa579a?w=400&h=300&fit=crop',
      courseCount: 38,
      rating: 4.6,
      duration: '6 hafta',
      level: 'Başlangıç',
      color: 'from-blue-500 to-cyan-500',
      emoji: '🎵'
    },
    {
      id: 5,
      name: 'Klasik Bale',
      description: 'Zarif ve disiplinli klasik dans',
      image: 'https://images.unsplash.com/photo-1508700929628-666bc8bd84ea?w=400&h=300&fit=crop',
      courseCount: 25,
      rating: 4.9,
      duration: '12 hafta',
      level: 'Tüm Seviyeler',
      color: 'from-gray-500 to-slate-500',
      emoji: '🩰'
    },
    {
      id: 6,
      name: 'Modern Dans',
      description: 'Yaratıcı ve özgür ifade dansı',
      image: 'https://images.unsplash.com/photo-1518611012118-696072aa579a?w=400&h=300&fit=crop',
      courseCount: 22,
      rating: 4.8,
      duration: '8 hafta',
      level: 'Orta',
      color: 'from-green-500 to-emerald-500',
      emoji: '🌿'
    },
    {
      id: 7,
      name: 'Latin Dansları',
      description: 'Sıcak ve ritimli Latin kültürü',
      image: 'https://images.unsplash.com/photo-1547036967-23d11aacaee0?w=400&h=300&fit=crop',
      courseCount: 35,
      rating: 4.7,
      duration: '6 hafta',
      level: 'Başlangıç',
      color: 'from-yellow-500 to-orange-500',
      emoji: '🌶️'
    },
    {
      id: 8,
      name: 'Swing',
      description: 'Eğlenceli ve enerjik swing dansı',
      image: 'https://images.unsplash.com/photo-1571019613454-1cb2f99b2d8b?w=400&h=300&fit=crop',
      courseCount: 18,
      rating: 4.6,
      duration: '8 hafta',
      level: 'Başlangıç',
      color: 'from-amber-500 to-yellow-500',
      emoji: '🎷'
    }
  ]

  return (
    <section className="section-padding bg-white">
      <div className="container-custom">
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold text-gray-900 mb-6">
            Popüler Dans Türleri
          </h2>
          <p className="text-xl text-gray-600 max-w-3xl mx-auto">
            Her seviye ve yaş grubu için uygun dans türlerini keşfedin. 
            Profesyonel öğretmenler eşliğinde dans etmeye başlayın.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
          {danceTypes.map((dance, index) => (
            <div
              key={dance.id}
              className="group card-hover cursor-pointer"
              onMouseEnter={() => setHoveredCard(dance.id)}
              onMouseLeave={() => setHoveredCard(null)}
            >
              {/* Image */}
              <div className="relative overflow-hidden rounded-t-xl">
                <img
                  src={dance.image}
                  alt={dance.name}
                  className="w-full h-48 object-cover group-hover:scale-105 transition-transform duration-300"
                />
                <div className={`absolute inset-0 bg-gradient-to-t ${dance.color} opacity-20 group-hover:opacity-30 transition-opacity duration-300`}></div>
                
                {/* Emoji Overlay */}
                <div className="absolute top-4 right-4 text-3xl">
                  {dance.emoji}
                </div>

                {/* Level Badge */}
                <div className="absolute bottom-4 left-4">
                  <span className="bg-white/90 text-gray-800 px-3 py-1 rounded-full text-sm font-medium">
                    {dance.level}
                  </span>
                </div>
              </div>

              {/* Content */}
              <div className="p-6">
                <h3 className="text-xl font-bold text-gray-900 mb-2 group-hover:text-primary-600 transition-colors">
                  {dance.name}
                </h3>
                <p className="text-gray-600 mb-4 text-sm">
                  {dance.description}
                </p>

                {/* Stats */}
                <div className="flex items-center justify-between text-sm text-gray-500 mb-4">
                  <div className="flex items-center space-x-1">
                    <Users className="w-4 h-4" />
                    <span>{dance.courseCount} kurs</span>
                  </div>
                  <div className="flex items-center space-x-1">
                    <Star className="w-4 h-4 text-yellow-400 fill-current" />
                    <span>{dance.rating}</span>
                  </div>
                  <div className="flex items-center space-x-1">
                    <Clock className="w-4 h-4" />
                    <span>{dance.duration}</span>
                  </div>
                </div>

                {/* Action Button */}
                <Link
                  href={`/dans-turleri/${dance.name.toLowerCase().replace(/\s+/g, '-')}`}
                  className={`w-full btn-outline group-hover:bg-gradient-to-r group-hover:from-primary-600 group-hover:to-accent-600 group-hover:border-transparent group-hover:text-white transition-all duration-300 flex items-center justify-center space-x-2 ${
                    hoveredCard === dance.id ? 'transform scale-105' : ''
                  }`}
                >
                  <span>Kurslara Göz At</span>
                  <ArrowRight className="w-4 h-4 group-hover:translate-x-1 transition-transform" />
                </Link>
              </div>
            </div>
          ))}
        </div>

        {/* CTA */}
        <div className="text-center mt-12">
          <Link
            href="/dans-turleri"
            className="btn-primary text-lg px-8 py-3 inline-flex items-center space-x-2"
          >
            <span>Tüm Dans Türlerini Gör</span>
            <ArrowRight className="w-5 h-5" />
          </Link>
        </div>
      </div>
    </section>
  )
}

