import Link from 'next/link'
import { MapPin, Phone, Mail, Facebook, Instagram, Twitter, Youtube } from 'lucide-react'

export default function Footer() {
  const danceTypes = [
    'Salsa',
    'Bachata',
    'Tango',
    'Hip-Hop',
    'Klasik Bale',
    'Modern Dans',
    'Latin Dansları',
    'Swing',
  ]

  const cities = [
    'İstanbul',
    'Ankara',
    'İzmir',
    'Bursa',
    'Antalya',
    'Adana',
    'Konya',
    'Gaziantep',
  ]

  const quickLinks = [
    { name: 'Hakkımızda', href: '/hakkimizda' },
    { name: 'Gizlilik Politikası', href: '/gizlilik' },
    { name: 'Kullanım Şartları', href: '/kullanim-sartlari' },
    { name: 'İletişim', href: '/iletisim' },
    { name: 'SSS', href: '/sss' },
    { name: 'Blog', href: '/blog' },
  ]

  return (
    <footer className="bg-gray-900 text-white">
      <div className="container-custom section-padding">
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
          {/* Logo & Description */}
          <div className="lg:col-span-1">
            <div className="flex items-center space-x-2 mb-4">
              <div className="w-10 h-10 bg-gradient-primary rounded-lg flex items-center justify-center">
                <span className="text-white font-bold text-xl">D</span>
              </div>
              <div>
                <h3 className="text-xl font-bold">Dans Dersleri</h3>
                <p className="text-sm text-gray-400">Türkiye'nin Dans Rehberi</p>
              </div>
            </div>
            <p className="text-gray-300 mb-6">
              Türkiye'nin en kapsamlı dans kursu rehberi. İstanbul, Ankara, İzmir ve tüm şehirlerde 
              profesyonel dans kurslarını keşfedin.
            </p>
            <div className="flex space-x-4">
              <a href="#" className="text-gray-400 hover:text-white transition-colors">
                <Facebook className="w-5 h-5" />
              </a>
              <a href="#" className="text-gray-400 hover:text-white transition-colors">
                <Instagram className="w-5 h-5" />
              </a>
              <a href="#" className="text-gray-400 hover:text-white transition-colors">
                <Twitter className="w-5 h-5" />
              </a>
              <a href="#" className="text-gray-400 hover:text-white transition-colors">
                <Youtube className="w-5 h-5" />
              </a>
            </div>
          </div>

          {/* Dans Türleri */}
          <div>
            <h4 className="text-lg font-semibold mb-4">Dans Türleri</h4>
            <ul className="space-y-2">
              {danceTypes.map((type) => (
                <li key={type}>
                  <Link 
                    href={`/dans-turleri/${type.toLowerCase().replace(/\s+/g, '-')}`}
                    className="text-gray-300 hover:text-white transition-colors text-sm"
                  >
                    {type}
                  </Link>
                </li>
              ))}
            </ul>
          </div>

          {/* Şehirler */}
          <div>
            <h4 className="text-lg font-semibold mb-4">Popüler Şehirler</h4>
            <ul className="space-y-2">
              {cities.map((city) => (
                <li key={city}>
                  <Link 
                    href={`/sehirler/${city.toLowerCase()}`}
                    className="text-gray-300 hover:text-white transition-colors text-sm"
                  >
                    {city}
                  </Link>
                </li>
              ))}
            </ul>
          </div>

          {/* İletişim */}
          <div>
            <h4 className="text-lg font-semibold mb-4">İletişim</h4>
            <div className="space-y-3">
              <div className="flex items-center space-x-3">
                <MapPin className="w-5 h-5 text-primary-400" />
                <span className="text-gray-300 text-sm">
                  İstanbul, Ankara, İzmir<br />
                  Türkiye Geneli
                </span>
              </div>
              <div className="flex items-center space-x-3">
                <Phone className="w-5 h-5 text-primary-400" />
                <span className="text-gray-300 text-sm">+90 (212) 555 0123</span>
              </div>
              <div className="flex items-center space-x-3">
                <Mail className="w-5 h-5 text-primary-400" />
                <span className="text-gray-300 text-sm">info@dansdersleri.com</span>
              </div>
            </div>
          </div>
        </div>

        {/* Bottom Bar */}
        <div className="border-t border-gray-800 mt-12 pt-8">
          <div className="flex flex-col md:flex-row justify-between items-center">
            <div className="flex flex-wrap gap-6 mb-4 md:mb-0">
              {quickLinks.map((link) => (
                <Link
                  key={link.name}
                  href={link.href}
                  className="text-gray-400 hover:text-white transition-colors text-sm"
                >
                  {link.name}
                </Link>
              ))}
            </div>
            <p className="text-gray-400 text-sm">
              © 2024 Dans Dersleri. Tüm hakları saklıdır.
            </p>
          </div>
        </div>
      </div>
    </footer>
  )
}

