'use client'

import { useEffect, useState } from 'react'
import { Users, MapPin, Star, Award } from 'lucide-react'

export default function Stats() {
  const [isVisible, setIsVisible] = useState(false)

  useEffect(() => {
    const timer = setTimeout(() => setIsVisible(true), 500)
    return () => clearTimeout(timer)
  }, [])

  const stats = [
    {
      icon: <Users className="w-8 h-8" />,
      number: '500+',
      label: 'Dans Kursu',
      description: 'Türkiye genelinde kayıtlı kurs'
    },
    {
      icon: <MapPin className="w-8 h-8" />,
      number: '50+',
      label: 'Şehir',
      description: 'Hizmet verdiğimiz şehir sayısı'
    },
    {
      icon: <Star className="w-8 h-8" />,
      number: '15+',
      label: 'Dans Türü',
      description: 'Farklı dans türü seçeneği'
    },
    {
      icon: <Award className="w-8 h-8" />,
      number: '10K+',
      label: 'Mutlu Öğrenci',
      description: 'Platformumuzdan faydalanan kişi'
    }
  ]

  return (
    <section className="bg-gray-50 py-16">
      <div className="container-custom">
        <div className="text-center mb-12">
          <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
            Rakamlarla Dans Dersleri
          </h2>
          <p className="text-xl text-gray-600 max-w-2xl mx-auto">
            Türkiye'nin en kapsamlı dans kursu rehberi olarak sizlere hizmet veriyoruz
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
          {stats.map((stat, index) => (
            <div
              key={index}
              className={`text-center p-6 bg-white rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 hover:-translate-y-1 ${
                isVisible ? 'animate-fade-in' : 'opacity-0'
              }`}
              style={{ animationDelay: `${index * 0.1}s` }}
            >
              <div className="inline-flex items-center justify-center w-16 h-16 bg-gradient-primary rounded-full text-white mb-4">
                {stat.icon}
              </div>
              <div className="text-4xl font-bold text-gray-900 mb-2">
                {stat.number}
              </div>
              <div className="text-lg font-semibold text-gray-700 mb-2">
                {stat.label}
              </div>
              <div className="text-sm text-gray-500">
                {stat.description}
              </div>
            </div>
          ))}
        </div>

        {/* Additional Info */}
        <div className="mt-16 text-center">
          <div className="bg-white rounded-2xl p-8 shadow-lg max-w-4xl mx-auto">
            <h3 className="text-2xl font-bold text-gray-900 mb-4">
              Neden Dans Dersleri?
            </h3>
            <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
              <div className="text-center">
                <div className="w-12 h-12 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-3">
                  <span className="text-2xl">✓</span>
                </div>
                <h4 className="font-semibold text-gray-900 mb-2">Güvenilir</h4>
                <p className="text-sm text-gray-600">
                  Tüm kurslarımız doğrulanmış ve güvenilir
                </p>
              </div>
              <div className="text-center">
                <div className="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-3">
                  <span className="text-2xl">🎯</span>
                </div>
                <h4 className="font-semibold text-gray-900 mb-2">Kapsamlı</h4>
                <p className="text-sm text-gray-600">
                  Her seviye ve yaş grubu için kurs seçenekleri
                </p>
              </div>
              <div className="text-center">
                <div className="w-12 h-12 bg-purple-100 rounded-full flex items-center justify-center mx-auto mb-3">
                  <span className="text-2xl">💎</span>
                </div>
                <h4 className="font-semibold text-gray-900 mb-2">Kaliteli</h4>
                <p className="text-sm text-gray-600">
                  Profesyonel öğretmenler ve kaliteli eğitim
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}

