'use client'

import { useState, useEffect } from 'react'
import { Star, Quote, ChevronLeft, ChevronRight } from 'lucide-react'

export default function Testimonials() {
  const [currentSlide, setCurrentSlide] = useState(0)
  const [isAutoPlaying, setIsAutoPlaying] = useState(true)

  const testimonials = [
    {
      id: 1,
      name: 'Ayşe Kaya',
      age: 28,
      city: 'İstanbul',
      danceType: 'Salsa',
      rating: 5,
      text: 'Dans Dersleri sayesinde salsa öğrenmeye başladım. Öğretmenim çok profesyonel ve sabırlı. Artık dans etmekten çok keyif alıyorum!',
      image: 'https://images.unsplash.com/photo-1494790108755-2616b612b786?w=100&h=100&fit=crop&crop=face',
      course: 'Salsa & Bachata Akademi'
    },
    {
      id: 2,
      name: 'Mehmet Özkan',
      age: 35,
      city: 'Ankara',
      danceType: 'Tango',
      rating: 5,
      text: 'Tango tutkum bu platform sayesinde başladı. Eşimle birlikte katıldığımız kurslar sayesinde hem dans ediyoruz hem de ilişkimiz güçlendi.',
      image: 'https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=100&h=100&fit=crop&crop=face',
      course: 'Tango Passion'
    },
    {
      id: 3,
      name: 'Zeynep Demir',
      age: 24,
      city: 'İzmir',
      danceType: 'Hip-Hop',
      rating: 5,
      text: 'Hip-hop kursunda harika zaman geçiriyorum. Öğretmenimiz çok enerjik ve yaratıcı. Artık kendimi çok daha özgüvenli hissediyorum.',
      image: 'https://images.unsplash.com/photo-1438761681033-6461ffad8d80?w=100&h=100&fit=crop&crop=face',
      course: 'Hip-Hop Academy'
    },
    {
      id: 4,
      name: 'Can Yılmaz',
      age: 31,
      city: 'Bursa',
      danceType: 'Bachata',
      rating: 5,
      text: 'Bachata öğrenmek istiyordum ama nereden başlayacağımı bilmiyordum. Bu platform sayesinde mükemmel bir kurs buldum. Çok memnunum!',
      image: 'https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?w=100&h=100&fit=crop&crop=face',
      course: 'Latin Fire Dance'
    },
    {
      id: 5,
      name: 'Elif Şahin',
      age: 26,
      city: 'Antalya',
      danceType: 'Modern Dans',
      rating: 5,
      text: 'Modern dans kursu benim için bir dönüm noktası oldu. Yaratıcılığımı keşfettim ve kendimi ifade etmeyi öğrendim. Harika bir deneyim!',
      image: 'https://images.unsplash.com/photo-1544005313-94ddf0286df2?w=100&h=100&fit=crop&crop=face',
      course: 'Modern Dans Stüdyosu'
    },
    {
      id: 6,
      name: 'Oğuz Arslan',
      age: 29,
      city: 'İstanbul',
      danceType: 'Klasik Bale',
      rating: 5,
      text: 'Klasik bale eğitimi almak çocukluk hayalimdi. Bu platform sayesinde hayalimi gerçekleştirdim. Öğretmenim çok deneyimli ve sabırlı.',
      image: 'https://images.unsplash.com/photo-1500648767791-00dcc994a43e?w=100&h=100&fit=crop&crop=face',
      course: 'Bale & Dans Okulu'
    }
  ]

  const nextSlide = () => {
    setCurrentSlide((prev) => (prev + 1) % testimonials.length)
  }

  const prevSlide = () => {
    setCurrentSlide((prev) => (prev - 1 + testimonials.length) % testimonials.length)
  }

  const goToSlide = (index: number) => {
    setCurrentSlide(index)
  }

  // Auto-play functionality
  useEffect(() => {
    if (!isAutoPlaying) return

    const interval = setInterval(() => {
      nextSlide()
    }, 5000)

    return () => clearInterval(interval)
  }, [isAutoPlaying])

  return (
    <section className="section-padding bg-gradient-to-br from-primary-50 to-accent-50">
      <div className="container-custom">
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold text-gray-900 mb-6">
            Öğrencilerimiz Ne Diyor?
          </h2>
          <p className="text-xl text-gray-600 max-w-3xl mx-auto">
            Binlerce mutlu öğrencimizin deneyimlerini okuyun. 
            Dans yolculuğunuzda size ilham verecek hikayeler.
          </p>
        </div>

        {/* Testimonials Carousel */}
        <div className="relative max-w-4xl mx-auto">
          <div className="overflow-hidden rounded-2xl">
            <div 
              className="flex transition-transform duration-500 ease-in-out"
              style={{ transform: `translateX(-${currentSlide * 100}%)` }}
            >
              {testimonials.map((testimonial) => (
                <div key={testimonial.id} className="w-full flex-shrink-0">
                  <div className="bg-white rounded-2xl p-8 md:p-12 shadow-xl">
                    {/* Quote Icon */}
                    <div className="flex justify-center mb-6">
                      <div className="w-16 h-16 bg-primary-100 rounded-full flex items-center justify-center">
                        <Quote className="w-8 h-8 text-primary-600" />
                      </div>
                    </div>

                    {/* Testimonial Text */}
                    <blockquote className="text-lg md:text-xl text-gray-700 text-center mb-8 leading-relaxed">
                      "{testimonial.text}"
                    </blockquote>

                    {/* Rating */}
                    <div className="flex justify-center mb-6">
                      {[...Array(testimonial.rating)].map((_, i) => (
                        <Star key={i} className="w-5 h-5 text-yellow-400 fill-current" />
                      ))}
                    </div>

                    {/* User Info */}
                    <div className="flex flex-col md:flex-row items-center justify-center space-y-4 md:space-y-0 md:space-x-6">
                      <div className="flex items-center space-x-4">
                        <img
                          src={testimonial.image}
                          alt={testimonial.name}
                          className="w-16 h-16 rounded-full object-cover"
                        />
                        <div className="text-left">
                          <h4 className="font-semibold text-gray-900">{testimonial.name}</h4>
                          <p className="text-gray-600 text-sm">
                            {testimonial.age} yaş, {testimonial.city}
                          </p>
                          <p className="text-primary-600 text-sm font-medium">
                            {testimonial.danceType} - {testimonial.course}
                          </p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              ))}
            </div>
          </div>

          {/* Navigation Arrows */}
          <button
            onClick={prevSlide}
            onMouseEnter={() => setIsAutoPlaying(false)}
            onMouseLeave={() => setIsAutoPlaying(true)}
            aria-label="Önceki yorum"
            className="absolute left-4 top-1/2 transform -translate-y-1/2 w-12 h-12 bg-white rounded-full shadow-lg flex items-center justify-center hover:bg-gray-50 transition-colors"
          >
            <ChevronLeft className="w-6 h-6 text-gray-600" aria-hidden="true" />
          </button>
          <button
            onClick={nextSlide}
            onMouseEnter={() => setIsAutoPlaying(false)}
            onMouseLeave={() => setIsAutoPlaying(true)}
            aria-label="Sonraki yorum"
            className="absolute right-4 top-1/2 transform -translate-y-1/2 w-12 h-12 bg-white rounded-full shadow-lg flex items-center justify-center hover:bg-gray-50 transition-colors"
          >
            <ChevronRight className="w-6 h-6 text-gray-600" aria-hidden="true" />
          </button>
        </div>

        {/* Dots Indicator */}
        <div className="flex justify-center mt-8 space-x-2">
          {testimonials.map((_, index) => (
            <button
              key={index}
              onClick={() => goToSlide(index)}
              onMouseEnter={() => setIsAutoPlaying(false)}
              onMouseLeave={() => setIsAutoPlaying(true)}
              aria-label={`Yorum ${index + 1}'e git`}
              aria-current={index === currentSlide}
              className={`w-3 h-3 rounded-full transition-colors min-h-[12px] min-w-[12px] ${
                index === currentSlide 
                  ? 'bg-primary-600' 
                  : 'bg-gray-300 hover:bg-gray-400'
              }`}
            />
          ))}
        </div>

        {/* Stats */}
        <div className="mt-16 grid grid-cols-1 md:grid-cols-3 gap-8 text-center">
          <div>
            <div className="text-4xl font-bold text-primary-600 mb-2">4.9/5</div>
            <div className="text-gray-600">Ortalama Değerlendirme</div>
          </div>
          <div>
            <div className="text-4xl font-bold text-primary-600 mb-2">2,500+</div>
            <div className="text-gray-600">Mutlu Öğrenci</div>
          </div>
          <div>
            <div className="text-4xl font-bold text-primary-600 mb-2">98%</div>
            <div className="text-gray-600">Memnuniyet Oranı</div>
          </div>
        </div>
      </div>
    </section>
  )
}
