'use client'

import { School, Users, DollarSign, TrendingUp, ArrowUp, ArrowDown } from 'lucide-react'

export default function DashboardStats() {
  const stats = [
    {
      name: 'Toplam Kurslar',
      value: '486',
      change: '+12%',
      changeType: 'increase',
      icon: <School className="w-6 h-6" />,
      color: 'bg-blue-500'
    },
    {
      name: 'Aktif Kullanıcılar',
      value: '2,845',
      change: '+8%',
      changeType: 'increase',
      icon: <Users className="w-6 h-6" />,
      color: 'bg-green-500'
    },
    {
      name: 'Aylık Gelir',
      value: '₺45,280',
      change: '+23%',
      changeType: 'increase',
      icon: <DollarSign className="w-6 h-6" />,
      color: 'bg-yellow-500'
    },
    {
      name: 'Büyüme Oranı',
      value: '+18.2%',
      change: '-2%',
      changeType: 'decrease',
      icon: <TrendingUp className="w-6 h-6" />,
      color: 'bg-purple-500'
    }
  ]

  return (
    <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
      {stats.map((stat, index) => (
        <div key={index} className="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-shadow">
          <div className="flex items-center justify-between mb-4">
            <div className={`${stat.color} p-3 rounded-lg text-white`}>
              {stat.icon}
            </div>
            <div className={`flex items-center space-x-1 text-sm font-medium ${
              stat.changeType === 'increase' ? 'text-green-600' : 'text-red-600'
            }`}>
              {stat.changeType === 'increase' ? (
                <ArrowUp className="w-4 h-4" />
              ) : (
                <ArrowDown className="w-4 h-4" />
              )}
              <span>{stat.change}</span>
            </div>
          </div>
          <div>
            <p className="text-gray-600 text-sm mb-1">{stat.name}</p>
            <p className="text-3xl font-bold text-gray-900">{stat.value}</p>
          </div>
        </div>
      ))}
    </div>
  )
}
