'use client'

import { MapPin, TrendingUp } from 'lucide-react'

export default function PopularCities() {
  const cities = [
    { name: 'İstanbul', courses: 156, percentage: 32, growth: '+12%' },
    { name: 'Ankara', courses: 89, percentage: 18, growth: '+8%' },
    { name: 'İzmir', courses: 67, percentage: 14, growth: '+15%' },
    { name: 'Bursa', courses: 45, percentage: 9, growth: '+5%' },
    { name: 'Antalya', courses: 38, percentage: 8, growth: '+10%' },
    { name: 'Diğer', courses: 91, percentage: 19, growth: '+7%' }
  ]

  const totalCourses = cities.reduce((sum, city) => sum + city.courses, 0)

  return (
    <div className="bg-white rounded-xl shadow-lg p-6">
      <div className="flex items-center justify-between mb-6">
        <div>
          <h3 className="text-lg font-semibold text-gray-900 flex items-center space-x-2">
            <MapPin className="w-5 h-5 text-primary-600" />
            <span>Popüler Şehirler</span>
          </h3>
          <p className="text-sm text-gray-600 mt-1">Şehirlere göre kurs dağılımı</p>
        </div>
      </div>

      {/* City List */}
      <div className="space-y-4">
        {cities.map((city, index) => (
          <div key={index} className="group">
            <div className="flex items-center justify-between mb-2">
              <div className="flex items-center space-x-3">
                <span className="text-sm font-medium text-gray-900">{city.name}</span>
                <span className="text-xs text-green-600 font-medium flex items-center space-x-1">
                  <TrendingUp className="w-3 h-3" />
                  <span>{city.growth}</span>
                </span>
              </div>
              <div className="text-right">
                <span className="text-sm font-bold text-gray-900">{city.courses}</span>
                <span className="text-xs text-gray-500 ml-1">kurs</span>
              </div>
            </div>
            <div className="relative">
              <div className="w-full bg-gray-200 rounded-full h-3">
                <div
                  className="bg-gradient-to-r from-blue-500 to-blue-600 h-3 rounded-full transition-all duration-300 group-hover:from-primary-600 group-hover:to-accent-600"
                  style={{ width: `${city.percentage}%` }}
                ></div>
              </div>
              <span className="absolute right-2 top-0 text-xs text-gray-600">
                {city.percentage}%
              </span>
            </div>
          </div>
        ))}
      </div>

      {/* Summary */}
      <div className="mt-6 pt-6 border-t border-gray-200">
        <div className="grid grid-cols-2 gap-4">
          <div>
            <p className="text-sm text-gray-600">Toplam Kurs</p>
            <p className="text-2xl font-bold text-gray-900">{totalCourses}</p>
          </div>
          <div>
            <p className="text-sm text-gray-600">Öncelik Şehirler</p>
            <p className="text-2xl font-bold text-gray-900">3</p>
          </div>
        </div>
      </div>
    </div>
  )
}
