import { Clock, Calendar, Users, MapPin } from 'lucide-react'

interface ScheduleItem {
  day: string
  time: string
  level: string
  type: string
}

interface CourseScheduleProps {
  schedule: ScheduleItem[]
}

export default function CourseSchedule({ schedule }: CourseScheduleProps) {
  const getLevelColor = (level: string) => {
    switch (level.toLowerCase()) {
      case 'başlangıç':
        return 'bg-green-100 text-green-800'
      case 'orta':
        return 'bg-yellow-100 text-yellow-800'
      case 'ileri':
        return 'bg-red-100 text-red-800'
      default:
        return 'bg-gray-100 text-gray-800'
    }
  }

  const getTypeColor = (type: string) => {
    const colors = [
      'bg-blue-100 text-blue-800',
      'bg-purple-100 text-purple-800',
      'bg-pink-100 text-pink-800',
      'bg-indigo-100 text-indigo-800',
      'bg-teal-100 text-teal-800'
    ]
    
    const index = type.length % colors.length
    return colors[index]
  }

  return (
    <div className="bg-white rounded-xl shadow-lg p-6 md:p-8">
      <h2 className="text-2xl font-bold text-gray-900 mb-6">Ders Programı</h2>
      
      {schedule.length > 0 ? (
        <div className="space-y-4">
          {schedule.map((item, index) => (
            <div
              key={index}
              className="border border-gray-200 rounded-lg p-4 hover:shadow-md transition-shadow"
            >
              <div className="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
                {/* Day and Time */}
                <div className="flex items-center space-x-4">
                  <div className="flex items-center space-x-2">
                    <Calendar className="w-5 h-5 text-gray-600" />
                    <span className="font-semibold text-gray-900">{item.day}</span>
                  </div>
                  <div className="flex items-center space-x-2">
                    <Clock className="w-5 h-5 text-gray-600" />
                    <span className="text-gray-700">{item.time}</span>
                  </div>
                </div>

                {/* Level and Type */}
                <div className="flex items-center space-x-3">
                  <span className={`px-3 py-1 rounded-full text-sm font-medium ${getLevelColor(item.level)}`}>
                    {item.level}
                  </span>
                  <span className={`px-3 py-1 rounded-full text-sm font-medium ${getTypeColor(item.type)}`}>
                    {item.type}
                  </span>
                </div>
              </div>
            </div>
          ))}
        </div>
      ) : (
        <div className="text-center py-8">
          <Calendar className="w-12 h-12 text-gray-400 mx-auto mb-4" />
          <p className="text-gray-500">Ders programı bilgisi mevcut değil.</p>
        </div>
      )}

      {/* Additional Info */}
      <div className="mt-8 p-4 bg-gray-50 rounded-lg">
        <div className="flex items-center space-x-2 mb-2">
          <Users className="w-5 h-5 text-primary-600" />
          <span className="font-semibold text-gray-900">Grup Dersleri</span>
        </div>
        <p className="text-sm text-gray-600">
          Tüm derslerimiz grup halinde yapılmaktadır. Maksimum 12 kişilik sınıflarda 
          her öğrenciye özel ilgi gösterilir.
        </p>
      </div>

      {/* Contact for Schedule Changes */}
      <div className="mt-6 p-4 bg-primary-50 rounded-lg">
        <div className="flex items-center space-x-2 mb-2">
          <MapPin className="w-5 h-5 text-primary-600" />
          <span className="font-semibold text-gray-900">Program Değişiklikleri</span>
        </div>
        <p className="text-sm text-gray-600">
          Ders programında değişiklik olması durumunda önceden bilgilendirilirsiniz. 
          Detaylı bilgi için bizimle iletişime geçin.
        </p>
      </div>
    </div>
  )
}

