import Link from 'next/link'
import Image from 'next/image'
import { Star, MapPin, ArrowRight } from 'lucide-react'

interface RelatedCourse {
  id: string
  name: string
  location: string
  rating: number
  price: number
  image: string
}

interface RelatedCoursesProps {
  courses: RelatedCourse[]
}

export default function RelatedCourses({ courses }: RelatedCoursesProps) {
  if (courses.length === 0) return null

  return (
    <div className="bg-white rounded-xl shadow-lg p-6">
      <h3 className="text-xl font-bold text-gray-900 mb-6">Benzer Kurslar</h3>
      
      <div className="space-y-4">
        {courses.map((course) => (
          <Link
            key={course.id}
            href={`/kurslar/${course.id}`}
            className="group block"
          >
            <div className="flex space-x-4 hover:bg-gray-50 rounded-lg p-2 -m-2 transition-colors">
              <div className="relative w-20 h-20 flex-shrink-0">
                <Image
                  src={course.image}
                  alt={course.name}
                  fill
                  className="object-cover rounded-lg"
                />
              </div>
              
              <div className="flex-1 min-w-0">
                <h4 className="font-semibold text-gray-900 group-hover:text-primary-600 transition-colors line-clamp-2">
                  {course.name}
                </h4>
                
                <div className="flex items-center space-x-1 mt-1">
                  <MapPin className="w-3 h-3 text-gray-400" />
                  <span className="text-sm text-gray-600">{course.location}</span>
                </div>
                
                <div className="flex items-center justify-between mt-2">
                  <div className="flex items-center space-x-1">
                    <Star className="w-3 h-3 text-yellow-400 fill-current" />
                    <span className="text-sm font-medium">{course.rating}</span>
                  </div>
                  
                  <div className="text-sm font-bold text-primary-600">
                    {course.price} TL
                  </div>
                </div>
              </div>
              
              <div className="flex items-center text-gray-400 group-hover:text-primary-600 transition-colors">
                <ArrowRight className="w-4 h-4" />
              </div>
            </div>
          </Link>
        ))}
      </div>
      
      <div className="mt-6 pt-4 border-t border-gray-200">
        <Link
          href="/kurslar"
          className="text-primary-600 hover:text-primary-700 font-medium text-sm flex items-center space-x-1"
        >
          <span>Tüm kursları gör</span>
          <ArrowRight className="w-4 h-4" />
        </Link>
      </div>
    </div>
  )
}

