<?php
/**
 * The main template file
 *
 * @package FirmaRehberiPro
 */

get_header(); ?>

<main id="main" class="site-main" role="main">
    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <h1 class="hero-title"><?php _e('Türkiye\'nin En Kapsamlı Firma Rehberi', 'firma-rehberi-pro'); ?></h1>
            <p class="hero-subtitle"><?php _e('Güvenilir işletmeleri keşfedin, detaylı bilgileri inceleyin ve en uygun hizmeti bulun', 'firma-rehberi-pro'); ?></p>
            
            <form class="search-form" role="search" method="get" action="<?php echo esc_url(home_url('/')); ?>">
                <input type="search" name="s" class="search-input" placeholder="<?php _e('Firma adı, kategori veya şehir ara...', 'firma-rehberi-pro'); ?>" value="<?php echo get_search_query(); ?>">
                <button type="submit" class="search-button"><?php _e('Ara', 'firma-rehberi-pro'); ?></button>
            </form>
        </div>
    </section>

    <!-- Quick Links Section -->
    <section class="quick-links-section">
        <div class="container">
            <h2 class="section-title"><?php _e('Popüler Kategoriler', 'firma-rehberi-pro'); ?></h2>
            <div class="categories-grid">
                <?php
                $categories = get_terms(array(
                    'taxonomy'   => 'company_category',
                    'hide_empty' => true,
                    'number'     => 8,
                    'orderby'    => 'count',
                    'order'      => 'DESC',
                ));
                
                if ($categories && !is_wp_error($categories)) :
                    foreach ($categories as $category) :
                        $icon = get_term_meta($category->term_id, 'category_icon', true) ?: '🏢';
                ?>
                    <a href="<?php echo esc_url(get_term_link($category)); ?>" class="category-card">
                        <span class="category-icon"><?php echo esc_html($icon); ?></span>
                        <span class="category-name"><?php echo esc_html($category->name); ?></span>
                        <span class="category-count"><?php echo esc_html($category->count); ?> <?php _e('firma', 'firma-rehberi-pro'); ?></span>
                    </a>
                <?php 
                    endforeach;
                endif;
                ?>
            </div>
        </div>
    </section>

    <!-- Popular Cities Section -->
    <section class="cities-section">
        <div class="container">
            <h2 class="section-title"><?php _e('Popüler Şehirler', 'firma-rehberi-pro'); ?></h2>
            <div class="cities-grid">
                <?php
                $cities = get_terms(array(
                    'taxonomy'   => 'company_city',
                    'hide_empty' => true,
                    'number'     => 6,
                    'orderby'    => 'count',
                    'order'      => 'DESC',
                ));
                
                if ($cities && !is_wp_error($cities)) :
                    foreach ($cities as $city) :
                ?>
                    <a href="<?php echo esc_url(get_term_link($city)); ?>" class="city-card">
                        <span class="city-name"><?php echo esc_html($city->name); ?></span>
                        <span class="city-count"><?php echo esc_html($city->count); ?> <?php _e('firma', 'firma-rehberi-pro'); ?></span>
                    </a>
                <?php 
                    endforeach;
                endif;
                ?>
            </div>
        </div>
    </section>

    <!-- Featured Companies Section -->
    <section class="featured-companies-section">
        <div class="container">
            <h2 class="section-title"><?php _e('Öne Çıkan Firmalar', 'firma-rehberi-pro'); ?></h2>
            <div class="companies-grid">
                <?php
                $featured_companies = new WP_Query(array(
                    'post_type'      => 'company',
                    'posts_per_page' => 6,
                    'meta_key'       => '_featured',
                    'meta_value'     => '1',
                    'orderby'        => 'rand',
                ));
                
                if ($featured_companies->have_posts()) :
                    while ($featured_companies->have_posts()) : $featured_companies->the_post();
                        get_template_part('template-parts/company-card');
                    endwhile;
                    wp_reset_postdata();
                else :
                    // Fallback to recent companies
                    $recent_companies = new WP_Query(array(
                        'post_type'      => 'company',
                        'posts_per_page' => 6,
                        'orderby'        => 'date',
                        'order'          => 'DESC',
                    ));
                    
                    if ($recent_companies->have_posts()) :
                        while ($recent_companies->have_posts()) : $recent_companies->the_post();
                            get_template_part('template-parts/company-card');
                        endwhile;
                        wp_reset_postdata();
                    endif;
                endif;
                ?>
            </div>
        </div>
    </section>

    <!-- Latest News Section -->
    <section class="latest-news-section">
        <div class="container">
            <h2 class="section-title"><?php _e('Son Haberler', 'firma-rehberi-pro'); ?></h2>
            <div class="news-grid">
                <?php
                $latest_posts = new WP_Query(array(
                    'post_type'      => 'post',
                    'posts_per_page' => 3,
                    'orderby'        => 'date',
                    'order'          => 'DESC',
                ));
                
                if ($latest_posts->have_posts()) :
                    while ($latest_posts->have_posts()) : $latest_posts->the_post();
                ?>
                    <article class="news-card">
                        <?php if (has_post_thumbnail()) : ?>
                            <div class="news-image">
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_post_thumbnail('medium'); ?>
                                </a>
                            </div>
                        <?php endif; ?>
                        
                        <div class="news-content">
                            <div class="news-meta">
                                <span class="news-date"><?php echo get_the_date(); ?></span>
                                <?php
                                $categories = get_the_category();
                                if ($categories) :
                                ?>
                                    <span class="news-category"><?php echo esc_html($categories[0]->name); ?></span>
                                <?php endif; ?>
                            </div>
                            
                            <h3 class="news-title">
                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                            </h3>
                            
                            <div class="news-excerpt">
                                <?php echo wp_trim_words(get_the_excerpt(), 20); ?>
                            </div>
                        </div>
                    </article>
                <?php 
                    endwhile;
                    wp_reset_postdata();
                endif;
                ?>
            </div>
        </div>
    </section>
</main>

<style>
.quick-links-section,
.cities-section,
.featured-companies-section,
.latest-news-section {
    padding: 4rem 0;
}

.quick-links-section {
    background: #f8fafc;
}

.section-title {
    font-size: 2.5rem;
    font-weight: 700;
    text-align: center;
    margin-bottom: 3rem;
    color: #1a1a1a;
}

.categories-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1.5rem;
}

.category-card {
    background: #ffffff;
    padding: 2rem 1.5rem;
    border-radius: 12px;
    text-align: center;
    text-decoration: none;
    color: #1a1a1a;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
    transition: transform 0.2s ease, box-shadow 0.2s ease;
    border: 1px solid #e5e7eb;
}

.category-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
    color: #1a1a1a;
    text-decoration: none;
}

.category-icon {
    font-size: 2.5rem;
    display: block;
    margin-bottom: 1rem;
}

.category-name {
    font-size: 1.25rem;
    font-weight: 600;
    display: block;
    margin-bottom: 0.5rem;
}

.category-count {
    font-size: 0.875rem;
    color: #6b7280;
    display: block;
}

.cities-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    gap: 1rem;
}

.city-card {
    background: #1e40af;
    color: #ffffff;
    padding: 1.5rem 1rem;
    border-radius: 8px;
    text-align: center;
    text-decoration: none;
    transition: transform 0.2s ease, background 0.2s ease;
}

.city-card:hover {
    background: #1d4ed8;
    transform: translateY(-2px);
    color: #ffffff;
    text-decoration: none;
}

.city-name {
    font-size: 1.125rem;
    font-weight: 600;
    display: block;
    margin-bottom: 0.5rem;
}

.city-count {
    font-size: 0.875rem;
    opacity: 0.9;
    display: block;
}

.news-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 2rem;
}

.news-card {
    background: #ffffff;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
    transition: transform 0.2s ease, box-shadow 0.2s ease;
}

.news-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
}

.news-image {
    height: 200px;
    overflow: hidden;
}

.news-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.2s ease;
}

.news-card:hover .news-image img {
    transform: scale(1.05);
}

.news-content {
    padding: 1.5rem;
}

.news-meta {
    display: flex;
    gap: 1rem;
    margin-bottom: 1rem;
    font-size: 0.875rem;
    color: #6b7280;
}

.news-category {
    background: #1e40af;
    color: #ffffff;
    padding: 0.25rem 0.75rem;
    border-radius: 12px;
    font-size: 0.75rem;
    font-weight: 600;
}

.news-title {
    font-size: 1.25rem;
    font-weight: 600;
    margin-bottom: 1rem;
    line-height: 1.3;
}

.news-title a {
    color: #1a1a1a;
    text-decoration: none;
}

.news-title a:hover {
    color: #1e40af;
}

.news-excerpt {
    color: #6b7280;
    line-height: 1.6;
}

@media (max-width: 768px) {
    .section-title {
        font-size: 2rem;
    }
    
    .categories-grid {
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    }
    
    .news-grid {
        grid-template-columns: 1fr;
    }
}
</style>

<?php get_footer(); ?>
