<?php
/**
 * Template part for displaying breadcrumbs
 *
 * @package FirmaRehberiPro
 */

if (is_front_page()) {
    return;
}

$breadcrumbs = array();
$breadcrumbs[] = array(
    'name' => __('Ana Sayfa', 'firma-rehberi-pro'),
    'url'  => home_url('/'),
);

if (is_singular('company')) {
    // Add company archive
    $breadcrumbs[] = array(
        'name' => __('Firmalar', 'firma-rehberi-pro'),
        'url'  => get_post_type_archive_link('company'),
    );
    
    // Add category if exists
    $categories = get_the_terms(get_the_ID(), 'company_category');
    if ($categories && !is_wp_error($categories)) {
        $category = $categories[0];
        $breadcrumbs[] = array(
            'name' => $category->name,
            'url'  => get_term_link($category),
        );
    }
    
    // Add current page
    $breadcrumbs[] = array(
        'name' => get_the_title(),
        'url'  => get_permalink(),
    );
    
} elseif (is_post_type_archive('company')) {
    // Add current page
    $breadcrumbs[] = array(
        'name' => __('Firmalar', 'firma-rehberi-pro'),
        'url'  => get_post_type_archive_link('company'),
    );
    
} elseif (is_tax('company_category')) {
    // Add company archive
    $breadcrumbs[] = array(
        'name' => __('Firmalar', 'firma-rehberi-pro'),
        'url'  => get_post_type_archive_link('company'),
    );
    
    // Add current category
    $term = get_queried_object();
    $breadcrumbs[] = array(
        'name' => $term->name,
        'url'  => get_term_link($term),
    );
    
} elseif (is_tax('company_city')) {
    // Add company archive
    $breadcrumbs[] = array(
        'name' => __('Firmalar', 'firma-rehberi-pro'),
        'url'  => get_post_type_archive_link('company'),
    );
    
    // Add current city
    $term = get_queried_object();
    $breadcrumbs[] = array(
        'name' => $term->name,
        'url'  => get_term_link($term),
    );
    
} elseif (is_category()) {
    // Add blog archive
    $breadcrumbs[] = array(
        'name' => __('Haberler', 'firma-rehberi-pro'),
        'url'  => get_permalink(get_option('page_for_posts')),
    );
    
    // Add current category
    $term = get_queried_object();
    $breadcrumbs[] = array(
        'name' => $term->name,
        'url'  => get_term_link($term),
    );
    
} elseif (is_single() && get_post_type() === 'post') {
    // Add blog archive
    $breadcrumbs[] = array(
        'name' => __('Haberler', 'firma-rehberi-pro'),
        'url'  => get_permalink(get_option('page_for_posts')),
    );
    
    // Add current post
    $breadcrumbs[] = array(
        'name' => get_the_title(),
        'url'  => get_permalink(),
    );
    
} elseif (is_page()) {
    // Add current page
    $breadcrumbs[] = array(
        'name' => get_the_title(),
        'url'  => get_permalink(),
    );
    
} elseif (is_search()) {
    // Add search results
    $breadcrumbs[] = array(
        'name' => sprintf(__('Arama sonuçları: "%s"', 'firma-rehberi-pro'), get_search_query()),
        'url'  => get_search_link(),
    );
}

// Remove last item URL since it's current page
if (!empty($breadcrumbs)) {
    $breadcrumbs[count($breadcrumbs) - 1]['url'] = '';
}
?>

<nav class="breadcrumb" role="navigation" aria-label="<?php _e('Breadcrumb navigasyonu', 'firma-rehberi-pro'); ?>">
    <div class="container">
        <ol class="breadcrumb-list">
            <?php foreach ($breadcrumbs as $index => $breadcrumb) : ?>
                <li class="breadcrumb-item">
                    <?php if ($breadcrumb['url'] && $index < count($breadcrumbs) - 1) : ?>
                        <a href="<?php echo esc_url($breadcrumb['url']); ?>" class="breadcrumb-link">
                            <?php echo esc_html($breadcrumb['name']); ?>
                        </a>
                        <span class="breadcrumb-separator" aria-hidden="true">›</span>
                    <?php else : ?>
                        <span class="breadcrumb-current" aria-current="page">
                            <?php echo esc_html($breadcrumb['name']); ?>
                        </span>
                    <?php endif; ?>
                </li>
            <?php endforeach; ?>
        </ol>
    </div>
</nav>

<style>
.breadcrumb {
    background: #f8fafc;
    padding: 1rem 0;
    border-bottom: 1px solid #e5e7eb;
    font-size: 0.875rem;
}

.breadcrumb-list {
    display: flex;
    flex-wrap: wrap;
    align-items: center;
    list-style: none;
    margin: 0;
    padding: 0;
    gap: 0.5rem;
}

.breadcrumb-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.breadcrumb-link {
    color: #1e40af;
    text-decoration: none;
    transition: color 0.2s ease;
}

.breadcrumb-link:hover {
    color: #1d4ed8;
    text-decoration: underline;
}

.breadcrumb-separator {
    color: #9ca3af;
    font-weight: 600;
    margin-left: 0.5rem;
}

.breadcrumb-current {
    color: #6b7280;
    font-weight: 500;
}

@media (max-width: 768px) {
    .breadcrumb {
        padding: 0.75rem 0;
    }
    
    .breadcrumb-list {
        font-size: 0.8rem;
    }
    
    .breadcrumb-separator {
        margin-left: 0.25rem;
    }
}
</style>
