import { NextResponse } from 'next/server'
import type { NextRequest } from 'next/server'

export function middleware(request: NextRequest) {
  const { pathname } = request.nextUrl

  // Admin routes kontrolü
  if (pathname.startsWith('/admin') && pathname !== '/admin/login') {
    // Session kontrolü (gerçek uygulamada cookie'den okunacak)
    const session = request.cookies.get('adminSession')
    
    // Session yoksa login sayfasına yönlendir
    if (!session) {
      return NextResponse.redirect(new URL('/admin/login', request.url))
    }

    // Session timeout kontrolü
    try {
      const sessionData = JSON.parse(session.value)
      const expiresAt = new Date(sessionData.expiresAt)
      
      if (expiresAt < new Date()) {
        // Session süresi dolmuş
        const response = NextResponse.redirect(new URL('/admin/login', request.url))
        response.cookies.delete('adminSession')
        return response
      }
    } catch (error) {
      // Geçersiz session
      const response = NextResponse.redirect(new URL('/admin/login', request.url))
      response.cookies.delete('adminSession')
      return response
    }
  }

  // Login sayfasında session varsa admin panele yönlendir
  if (pathname === '/admin/login') {
    const session = request.cookies.get('adminSession')
    if (session) {
      return NextResponse.redirect(new URL('/admin', request.url))
    }
  }

  return NextResponse.next()
}

export const config = {
  matcher: '/admin/:path*',
}

