<?php get_header(); ?>

<main class="main-content">
    <div class="container">
        <div class="archive-header">
            <h1 class="archive-title">İlanlar</h1>
            <p class="archive-description">Aradığınız ilanı kolayca bulun ve en uygun fırsatları yakalayın</p>
        </div>
        
        <!-- Filtreler -->
        <div class="filters-section">
            <div class="filters">
                <div class="filter-group">
                    <label>Kategori:</label>
                    <select id="category-filter">
                        <option value="">Tüm Kategoriler</option>
                        <?php
                        $categories = get_terms(array(
                            'taxonomy' => 'ilan_kategori',
                            'hide_empty' => false,
                        ));
                        foreach ($categories as $category) :
                        ?>
                            <option value="<?php echo $category->slug; ?>"><?php echo $category->name; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="filter-group">
                    <label>Şehir:</label>
                    <select id="city-filter">
                        <option value="">Tüm Şehirler</option>
                        <?php
                        $cities = get_terms(array(
                            'taxonomy' => 'sehir',
                            'hide_empty' => false,
                        ));
                        foreach ($cities as $city) :
                        ?>
                            <option value="<?php echo $city->slug; ?>"><?php echo $city->name; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="filter-group">
                    <label>Fiyat Aralığı:</label>
                    <select id="price-filter">
                        <option value="">Tüm Fiyatlar</option>
                        <option value="0-1000">0 - 1.000 TL</option>
                        <option value="1000-5000">1.000 - 5.000 TL</option>
                        <option value="5000-10000">5.000 - 10.000 TL</option>
                        <option value="10000-50000">10.000 - 50.000 TL</option>
                        <option value="50000+">50.000+ TL</option>
                    </select>
                </div>
                
                <div class="filter-group">
                    <label>Sıralama:</label>
                    <select id="sort-filter">
                        <option value="date">En Yeni</option>
                        <option value="price-low">Fiyat (Düşük-Yüksek)</option>
                        <option value="price-high">Fiyat (Yüksek-Düşük)</option>
                        <option value="popular">En Popüler</option>
                    </select>
                </div>
            </div>
        </div>
        
        <!-- İlan Listesi -->
        <div class="ilans-grid">
            <?php if (have_posts()) : ?>
                <?php while (have_posts()) : the_post(); ?>
                    <div class="ilan-card">
                        <div class="ilan-image">
                            <?php if (has_post_thumbnail()) : ?>
                                <?php the_post_thumbnail('medium'); ?>
                            <?php else : ?>
                                <div class="no-image">
                                    <?php
                                    $categories = get_the_terms(get_the_ID(), 'ilan_kategori');
                                    if ($categories && !is_wp_error($categories)) {
                                        $category = $categories[0];
                                        if ($category->slug == 'araba') echo '🚗';
                                        elseif ($category->slug == 'konut') echo '🏠';
                                        elseif ($category->slug == 'arsa') echo '🏞️';
                                        else echo '📋';
                                    } else {
                                        echo '📋';
                                    }
                                    ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if (get_post_meta(get_the_ID(), 'price', true)) : ?>
                                <div class="price-badge">
                                    <?php echo get_post_meta(get_the_ID(), 'price', true); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="ilan-content">
                            <h2 class="ilan-title">
                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                            </h2>
                            
                            <div class="ilan-meta">
                                <?php if (get_post_meta(get_the_ID(), 'location', true)) : ?>
                                    <div class="location">
                                        <span>📍 <?php echo get_post_meta(get_the_ID(), 'location', true); ?></span>
                                    </div>
                                <?php endif; ?>
                                
                                <div class="ilan-date">
                                    <span>📅 <?php echo get_the_date(); ?></span>
                                </div>
                                
                                <div class="views-count">
                                    <span>👁️ <?php echo get_post_meta(get_the_ID(), 'views_count', true) ?: 0; ?></span>
                                </div>
                            </div>
                            
                            <div class="ilan-categories">
                                <?php
                                $categories = get_the_terms(get_the_ID(), 'ilan_kategori');
                                if ($categories && !is_wp_error($categories)) :
                                    foreach ($categories as $category) :
                                ?>
                                    <span class="category-tag"><?php echo $category->name; ?></span>
                                <?php 
                                    endforeach;
                                endif;
                                ?>
                            </div>
                            
                            <div class="ilan-location">
                                <?php
                                $cities = get_the_terms(get_the_ID(), 'sehir');
                                if ($cities && !is_wp_error($cities)) :
                                    foreach ($cities as $city) :
                                ?>
                                    <span class="location-tag"><?php echo $city->name; ?></span>
                                <?php 
                                    endforeach;
                                endif;
                                ?>
                            </div>
                            
                            <div class="ilan-excerpt">
                                <?php echo wp_trim_words(get_the_excerpt(), 15); ?>
                            </div>
                            
                            <div class="ilan-actions">
                                <a href="<?php the_permalink(); ?>" class="view-ilan-btn">Detayları Gör</a>
                                <?php if (get_post_meta(get_the_ID(), 'contact_phone', true)) : ?>
                                    <a href="tel:<?php echo get_post_meta(get_the_ID(), 'contact_phone', true); ?>" class="contact-btn">📞 Ara</a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            <?php else : ?>
                <div class="no-ilans">
                    <h2>İlan bulunamadı</h2>
                    <p>Aradığınız kriterlere uygun ilan bulunamadı. Lütfen filtreleri değiştirerek tekrar deneyin.</p>
                </div>
            <?php endif; ?>
        </div>
        
        <!-- Pagination -->
        <div class="pagination">
            <?php
            echo paginate_links(array(
                'prev_text' => '← Önceki',
                'next_text' => 'Sonraki →',
                'mid_size' => 2,
            ));
            ?>
        </div>
    </div>
</main>

<style>
.archive-header {
    text-align: center;
    margin: 40px 0 60px 0;
}

.archive-title {
    font-size: 48px;
    font-weight: 700;
    color: #2c3e50;
    margin-bottom: 20px;
}

.archive-description {
    font-size: 20px;
    color: #666;
}

.filters-section {
    background: white;
    padding: 30px;
    border-radius: 15px;
    box-shadow: 0 3px 15px rgba(0,0,0,0.1);
    margin-bottom: 40px;
}

.filters {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    align-items: end;
}

.filter-group {
    display: flex;
    flex-direction: column;
}

.filter-group label {
    font-weight: 600;
    margin-bottom: 8px;
    color: #2c3e50;
}

.filter-group select {
    padding: 12px;
    border: 2px solid #e0e0e0;
    border-radius: 8px;
    font-size: 16px;
    background: white;
}

.ilans-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
    gap: 30px;
    margin-bottom: 60px;
}

.ilan-card {
    background: white;
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    transition: transform 0.3s, box-shadow 0.3s;
}

.ilan-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 40px rgba(0,0,0,0.15);
}

.ilan-image {
    height: 200px;
    overflow: hidden;
    position: relative;
}

.ilan-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.no-image {
    width: 100%;
    height: 100%;
    background: #f8f9fa;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 48px;
}

.price-badge {
    position: absolute;
    top: 15px;
    right: 15px;
    background: #e74c3c;
    color: white;
    padding: 8px 15px;
    border-radius: 20px;
    font-weight: 600;
    font-size: 14px;
}

.ilan-content {
    padding: 25px;
}

.ilan-title {
    font-size: 20px;
    font-weight: 600;
    margin-bottom: 15px;
    line-height: 1.4;
}

.ilan-title a {
    color: #2c3e50;
    text-decoration: none;
}

.ilan-title a:hover {
    color: #e74c3c;
}

.ilan-meta {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 10px;
    margin-bottom: 15px;
    font-size: 14px;
    color: #666;
}

.category-tag, .location-tag {
    display: inline-block;
    background: #e74c3c;
    color: white;
    padding: 4px 12px;
    border-radius: 15px;
    margin: 2px 5px 2px 0;
    font-size: 12px;
    font-weight: 500;
}

.ilan-excerpt {
    color: #666;
    line-height: 1.6;
    margin-bottom: 20px;
    font-size: 14px;
}

.ilan-actions {
    display: flex;
    gap: 10px;
    flex-wrap: wrap;
}

.view-ilan-btn, .contact-btn {
    display: inline-block;
    padding: 10px 20px;
    border-radius: 25px;
    text-decoration: none;
    font-weight: 600;
    font-size: 14px;
    transition: all 0.3s;
}

.view-ilan-btn {
    background: #e74c3c;
    color: white;
    flex: 1;
    text-align: center;
}

.view-ilan-btn:hover {
    background: #c0392b;
    transform: translateY(-2px);
}

.contact-btn {
    background: #27ae60;
    color: white;
    white-space: nowrap;
}

.contact-btn:hover {
    background: #219a52;
    transform: translateY(-2px);
}

.no-ilans {
    text-align: center;
    padding: 60px 20px;
    color: #666;
}

.pagination {
    text-align: center;
    margin-top: 40px;
}

.pagination a, .pagination span {
    display: inline-block;
    padding: 10px 15px;
    margin: 0 5px;
    background: white;
    color: #2c3e50;
    text-decoration: none;
    border-radius: 5px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    transition: all 0.3s;
}

.pagination a:hover, .pagination .current {
    background: #e74c3c;
    color: white;
}

@media (max-width: 768px) {
    .filters {
        grid-template-columns: 1fr;
    }
    
    .ilans-grid {
        grid-template-columns: 1fr;
    }
    
    .archive-title {
        font-size: 36px;
    }
    
    .ilan-meta {
        grid-template-columns: 1fr;
    }
    
    .ilan-actions {
        flex-direction: column;
    }
}
</style>

<script>
// Filtreleme JavaScript'i
document.addEventListener('DOMContentLoaded', function() {
    const categoryFilter = document.getElementById('category-filter');
    const cityFilter = document.getElementById('city-filter');
    const priceFilter = document.getElementById('price-filter');
    const sortFilter = document.getElementById('sort-filter');
    
    function applyFilters() {
        const url = new URL(window.location);
        
        if (categoryFilter.value) {
            url.searchParams.set('ilan_kategori', categoryFilter.value);
        } else {
            url.searchParams.delete('ilan_kategori');
        }
        
        if (cityFilter.value) {
            url.searchParams.set('sehir', cityFilter.value);
        } else {
            url.searchParams.delete('sehir');
        }
        
        if (priceFilter.value) {
            url.searchParams.set('price_range', priceFilter.value);
        } else {
            url.searchParams.delete('price_range');
        }
        
        if (sortFilter.value) {
            url.searchParams.set('sort', sortFilter.value);
        } else {
            url.searchParams.delete('sort');
        }
        
        window.location.href = url.toString();
    }
    
    categoryFilter.addEventListener('change', applyFilters);
    cityFilter.addEventListener('change', applyFilters);
    priceFilter.addEventListener('change', applyFilters);
    sortFilter.addEventListener('change', applyFilters);
});
</script>

<?php get_footer(); ?>
