<?php
/**
 * Firma Rehberi Pro Theme Functions
 */

// Theme Setup
function firma_rehberi_setup() {
    // Add theme support
    add_theme_support('post-thumbnails');
    add_theme_support('title-tag');
    add_theme_support('custom-logo');
    add_theme_support('html5', array(
        'search-form',
        'comment-form',
        'comment-list',
        'gallery',
        'caption',
    ));
    
    // Register navigation menus
    register_nav_menus(array(
        'primary' => __('Ana Menü', 'firma-rehberi'),
        'footer' => __('Footer Menü', 'firma-rehberi'),
    ));
}
add_action('after_setup_theme', 'firma_rehberi_setup');

// Enqueue scripts and styles
function firma_rehberi_scripts() {
    wp_enqueue_style('firma-rehberi-style', get_stylesheet_uri(), array(), '1.0.0');
    wp_enqueue_style('google-fonts', 'https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap', array(), null);
    
    wp_enqueue_script('firma-rehberi-script', get_template_directory_uri() . '/js/main.js', array('jquery'), '1.0.0', true);
}
add_action('wp_enqueue_scripts', 'firma_rehberi_scripts');

// Register Custom Post Types
function create_custom_post_types() {
    // Firma Post Type
    register_post_type('firma', array(
        'labels' => array(
            'name' => 'Firmalar',
            'singular_name' => 'Firma',
            'add_new' => 'Yeni Firma Ekle',
            'add_new_item' => 'Yeni Firma Ekle',
            'edit_item' => 'Firmayı Düzenle',
            'new_item' => 'Yeni Firma',
            'view_item' => 'Firmayı Görüntüle',
            'search_items' => 'Firma Ara',
            'not_found' => 'Firma bulunamadı',
            'not_found_in_trash' => 'Çöp kutusunda firma bulunamadı'
        ),
        'public' => true,
        'has_archive' => true,
        'menu_icon' => 'dashicons-building',
        'supports' => array('title', 'editor', 'thumbnail', 'excerpt', 'comments'),
        'rewrite' => array('slug' => 'firma'),
        'show_in_rest' => true,
    ));
    
    // İlan Post Type
    register_post_type('ilan', array(
        'labels' => array(
            'name' => 'İlanlar',
            'singular_name' => 'İlan',
            'add_new' => 'Yeni İlan Ekle',
            'add_new_item' => 'Yeni İlan Ekle',
            'edit_item' => 'İlanı Düzenle',
            'new_item' => 'Yeni İlan',
            'view_item' => 'İlanı Görüntüle',
            'search_items' => 'İlan Ara',
            'not_found' => 'İlan bulunamadı',
            'not_found_in_trash' => 'Çöp kutusunda ilan bulunamadı'
        ),
        'public' => true,
        'has_archive' => true,
        'menu_icon' => 'dashicons-megaphone',
        'supports' => array('title', 'editor', 'thumbnail', 'excerpt', 'comments'),
        'rewrite' => array('slug' => 'ilan'),
        'show_in_rest' => true,
    ));
}
add_action('init', 'create_custom_post_types');

// Register Custom Taxonomies
function create_custom_taxonomies() {
    // Firma Kategorileri
    register_taxonomy('firma_kategori', 'firma', array(
        'labels' => array(
            'name' => 'Firma Kategorileri',
            'singular_name' => 'Firma Kategorisi',
            'search_items' => 'Kategori Ara',
            'all_items' => 'Tüm Kategoriler',
            'edit_item' => 'Kategoriyi Düzenle',
            'update_item' => 'Kategoriyi Güncelle',
            'add_new_item' => 'Yeni Kategori Ekle',
            'new_item_name' => 'Yeni Kategori Adı',
            'menu_name' => 'Kategoriler',
        ),
        'hierarchical' => true,
        'public' => true,
        'show_in_rest' => true,
    ));
    
    // İlan Kategorileri
    register_taxonomy('ilan_kategori', 'ilan', array(
        'labels' => array(
            'name' => 'İlan Kategorileri',
            'singular_name' => 'İlan Kategorisi',
            'search_items' => 'Kategori Ara',
            'all_items' => 'Tüm Kategoriler',
            'edit_item' => 'Kategoriyi Düzenle',
            'update_item' => 'Kategoriyi Güncelle',
            'add_new_item' => 'Yeni Kategori Ekle',
            'new_item_name' => 'Yeni Kategori Adı',
            'menu_name' => 'Kategoriler',
        ),
        'hierarchical' => true,
        'public' => true,
        'show_in_rest' => true,
    ));
    
    // Şehirler
    register_taxonomy('sehir', array('firma', 'ilan'), array(
        'labels' => array(
            'name' => 'Şehirler',
            'singular_name' => 'Şehir',
            'search_items' => 'Şehir Ara',
            'all_items' => 'Tüm Şehirler',
            'edit_item' => 'Şehri Düzenle',
            'update_item' => 'Şehri Güncelle',
            'add_new_item' => 'Yeni Şehir Ekle',
            'new_item_name' => 'Yeni Şehir Adı',
            'menu_name' => 'Şehirler',
        ),
        'hierarchical' => true,
        'public' => true,
        'show_in_rest' => true,
    ));
}
add_action('init', 'create_custom_taxonomies');

// Add custom meta boxes
function add_custom_meta_boxes() {
    // Firma meta box
    add_meta_box(
        'firma_details',
        'Firma Detayları',
        'firma_details_callback',
        'firma',
        'normal',
        'high'
    );
    
    // İlan meta box
    add_meta_box(
        'ilan_details',
        'İlan Detayları',
        'ilan_details_callback',
        'ilan',
        'normal',
        'high'
    );
}
add_action('add_meta_boxes', 'add_custom_meta_boxes');

// Firma meta box callback
function firma_details_callback($post) {
    wp_nonce_field('firma_details_nonce', 'firma_details_nonce');
    
    $phone = get_post_meta($post->ID, 'phone', true);
    $email = get_post_meta($post->ID, 'email', true);
    $website = get_post_meta($post->ID, 'website', true);
    $address = get_post_meta($post->ID, 'address', true);
    $rating = get_post_meta($post->ID, 'rating', true);
    
    echo '<table class="form-table">';
    echo '<tr><th><label for="phone">Telefon</label></th><td><input type="text" id="phone" name="phone" value="' . esc_attr($phone) . '" /></td></tr>';
    echo '<tr><th><label for="email">E-posta</label></th><td><input type="email" id="email" name="email" value="' . esc_attr($email) . '" /></td></tr>';
    echo '<tr><th><label for="website">Website</label></th><td><input type="url" id="website" name="website" value="' . esc_attr($website) . '" /></td></tr>';
    echo '<tr><th><label for="address">Adres</label></th><td><textarea id="address" name="address">' . esc_textarea($address) . '</textarea></td></tr>';
    echo '<tr><th><label for="rating">Değerlendirme (1-5)</label></th><td><input type="number" id="rating" name="rating" min="1" max="5" value="' . esc_attr($rating) . '" /></td></tr>';
    echo '</table>';
}

// İlan meta box callback
function ilan_details_callback($post) {
    wp_nonce_field('ilan_details_nonce', 'ilan_details_nonce');
    
    $price = get_post_meta($post->ID, 'price', true);
    $location = get_post_meta($post->ID, 'location', true);
    $contact_phone = get_post_meta($post->ID, 'contact_phone', true);
    $contact_email = get_post_meta($post->ID, 'contact_email', true);
    $views_count = get_post_meta($post->ID, 'views_count', true);
    
    echo '<table class="form-table">';
    echo '<tr><th><label for="price">Fiyat</label></th><td><input type="text" id="price" name="price" value="' . esc_attr($price) . '" /></td></tr>';
    echo '<tr><th><label for="location">Konum</label></th><td><input type="text" id="location" name="location" value="' . esc_attr($location) . '" /></td></tr>';
    echo '<tr><th><label for="contact_phone">İletişim Telefonu</label></th><td><input type="text" id="contact_phone" name="contact_phone" value="' . esc_attr($contact_phone) . '" /></td></tr>';
    echo '<tr><th><label for="contact_email">İletişim E-postası</label></th><td><input type="email" id="contact_email" name="contact_email" value="' . esc_attr($contact_email) . '" /></td></tr>';
    echo '<tr><th><label for="views_count">Görüntülenme Sayısı</label></th><td><input type="number" id="views_count" name="views_count" value="' . esc_attr($views_count) . '" /></td></tr>';
    echo '</table>';
}

// Save custom meta data
function save_custom_meta_data($post_id) {
    // Firma meta data
    if (isset($_POST['firma_details_nonce']) && wp_verify_nonce($_POST['firma_details_nonce'], 'firma_details_nonce')) {
        if (isset($_POST['phone'])) update_post_meta($post_id, 'phone', sanitize_text_field($_POST['phone']));
        if (isset($_POST['email'])) update_post_meta($post_id, 'email', sanitize_email($_POST['email']));
        if (isset($_POST['website'])) update_post_meta($post_id, 'website', esc_url_raw($_POST['website']));
        if (isset($_POST['address'])) update_post_meta($post_id, 'address', sanitize_textarea_field($_POST['address']));
        if (isset($_POST['rating'])) update_post_meta($post_id, 'rating', intval($_POST['rating']));
    }
    
    // İlan meta data
    if (isset($_POST['ilan_details_nonce']) && wp_verify_nonce($_POST['ilan_details_nonce'], 'ilan_details_nonce')) {
        if (isset($_POST['price'])) update_post_meta($post_id, 'price', sanitize_text_field($_POST['price']));
        if (isset($_POST['location'])) update_post_meta($post_id, 'location', sanitize_text_field($_POST['location']));
        if (isset($_POST['contact_phone'])) update_post_meta($post_id, 'contact_phone', sanitize_text_field($_POST['contact_phone']));
        if (isset($_POST['contact_email'])) update_post_meta($post_id, 'contact_email', sanitize_email($_POST['contact_email']));
        if (isset($_POST['views_count'])) update_post_meta($post_id, 'views_count', intval($_POST['views_count']));
    }
}
add_action('save_post', 'save_custom_meta_data');

// Register widget areas
function firma_rehberi_widgets_init() {
    register_sidebar(array(
        'name' => 'Ana Sidebar',
        'id' => 'main-sidebar',
        'description' => 'Ana sayfa sidebar alanı',
        'before_widget' => '<div class="widget">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>',
    ));
    
    register_sidebar(array(
        'name' => 'Footer 1',
        'id' => 'footer-1',
        'description' => 'Footer 1. sütun',
        'before_widget' => '<div class="footer-widget">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>',
    ));
    
    register_sidebar(array(
        'name' => 'Footer 2',
        'id' => 'footer-2',
        'description' => 'Footer 2. sütun',
        'before_widget' => '<div class="footer-widget">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>',
    ));
    
    register_sidebar(array(
        'name' => 'Footer 3',
        'id' => 'footer-3',
        'description' => 'Footer 3. sütun',
        'before_widget' => '<div class="footer-widget">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>',
    ));
}
add_action('widgets_init', 'firma_rehberi_widgets_init');

// Custom search functionality
function custom_search_query($query) {
    if (!is_admin() && $query->is_main_query()) {
        if ($query->is_search()) {
            $query->set('post_type', array('post', 'firma', 'ilan'));
        }
    }
}
add_action('pre_get_posts', 'custom_search_query');

// Add view count functionality
function increment_post_views($post_id) {
    if (is_single() && !is_admin()) {
        $views = get_post_meta($post_id, 'views_count', true);
        $views = $views ? $views + 1 : 1;
        update_post_meta($post_id, 'views_count', $views);
    }
}
add_action('wp_head', 'increment_post_views');

// Custom excerpt length
function custom_excerpt_length($length) {
    return 20;
}
add_filter('excerpt_length', 'custom_excerpt_length');

// Custom excerpt more
function custom_excerpt_more($more) {
    return '...';
}
add_filter('excerpt_more', 'custom_excerpt_more');

// Include widget files
require_once get_template_directory() . '/widgets/popular-listings-widget.php';
require_once get_template_directory() . '/widgets/best-companies-widget.php';
require_once get_template_directory() . '/widgets/recent-news-widget.php';

// AJAX view count increment
function ajax_increment_view_count() {
    $post_id = intval($_POST['post_id']);
    if ($post_id) {
        $views = get_post_meta($post_id, 'views_count', true);
        $views = $views ? $views + 1 : 1;
        update_post_meta($post_id, 'views_count', $views);
    }
    wp_die();
}
add_action('wp_ajax_increment_view_count', 'ajax_increment_view_count');
add_action('wp_ajax_nopriv_increment_view_count', 'ajax_increment_view_count');

// Add AJAX URL to frontend
function add_ajax_url() {
    ?>
    <script type="text/javascript">
        var ajaxurl = '<?php echo admin_url('admin-ajax.php'); ?>';
    </script>
    <?php
}
add_action('wp_head', 'add_ajax_url');
?>
